# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.render_pass import RenderPass


class OSPRayPass(RenderPass):
    r"""
    OSPRayPass - a render pass that uses OSPRay instead of GL
    
    Superclass: RenderPass
    
    This is a render pass that can be put into a RenderWindow which
    makes it use OSPRay instead of open_gl to render. Adding/Removing the
    pass will swap back and forth between the two.
    
    
     OSPRay MPI - OSPRay can use its own internal MPI layer to replicate
       the scene data across mpi processes and composite the image.
       This results in linear performance scaling and supports secondary
       rays.  To run in this mode, a special environment variable is
    supplied
       called VTKOSPRAY_ARGS where commandline flags can be inserted for
       OSPRay's init call.  As an example of this, below is a commandline
       for running paraview on localhost, but having OSPRay's rendering
       occur on 2 remote nodes.  ospray_mpi_worker is a separate
    application
       supplied with OSPRay binary packages or when built with MPI
    support
       from source.
       'mpirun -ppn 1 -hosts localhost VTKOSPRAY_ARGS="-osp:mpi"
         ./paraview : -hosts n1, n2 ./ospray_mpi_worker -osp:mpi'
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOSPRayPass, obj, update, **traits)
    
    def _get_scene_graph(self):
        return wrap_vtk(self._vtk_obj.GetSceneGraph())
    def _set_scene_graph(self, arg):
        old_val = self._get_scene_graph()
        self._wrap_call(self._vtk_obj.SetSceneGraph,
                        deref_vtk(arg))
        self.trait_property_changed('scene_graph', old_val, arg)
    scene_graph = traits.Property(_get_scene_graph, _set_scene_graph, desc=\
        r"""
        
        """
    )

    def is_backend_available(self, *args):
        """
        is_backend_available(name:str) -> bool
        C++: static bool is_backend_available(const char *name)
        A run time query to see if a particular backend is available. Eg.
        "OSPRay raycaster", "OSPRay pathtracer" or "OptiX pathtracer".
        """
        ret = self._wrap_call(self._vtk_obj.IsBackendAvailable, *args)
        return ret

    def is_supported(self):
        """
        is_supported() -> bool
        C++: static bool is_supported()
        A run time query to see if OSPRay can possibly work.
        """
        ret = self._vtk_obj.IsSupported()
        return ret
        

    def rt_init(self):
        """
        rt_init() -> None
        C++: static void rt_init()"""
        ret = self._vtk_obj.RTInit()
        return ret
        

    def rt_shutdown(self):
        """
        rt_shutdown() -> None
        C++: static void rt_shutdown()"""
        ret = self._vtk_obj.RTShutdown()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OSPRayPass, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OSPRayPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit OSPRayPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OSPRayPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

