# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.open_gl_skybox import OpenGLSkybox


class OpenGLMovieSphere(OpenGLSkybox):
    r"""
    OpenGLMovieSphere - open_gl movie_sphere, an optimized VR sphere for
    movies
    
    Superclass: OpenGLSkybox
    
    This class is designed to more efficiently convert ffmpeg output to a
    movie sphere. The Skybox will work, but it does an expensive
    conversion of the data from YUV to RGB, does an extra copy of the RGB
    data and the RGB data is twice as large when pushing to the GPU. This
    class also uses double buffering of textures to help prevent pipeline
    stalls. In a quick test between the two classes playing a 4K30p video
    sphere along with VR rendering, decoding etc just switching out the
    Skybox for this class resulting in CPU usage going from 124
    seconds down to 81 seconds. Likewise the frame timings in VR became
    noticably better which could partially be due to pushing half as much
    data to the GPU. (YUV420 is half the size of RGB)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOpenGLMovieSphere, obj, update, **traits)
    
    def set_video_source(self, *args):
        """
        set_video_source(self, val:FFMPEGVideoSource) -> None
        C++: void set_video_source(FFMPEGVideoSource *val)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetVideoSource, *my_args)
        return ret

    _updateable_traits_ = \
    (('gamma_correct', 'GetGammaCorrect'), ('force_opaque',
    'GetForceOpaque'), ('force_translucent', 'GetForceTranslucent'),
    ('dragable', 'GetDragable'), ('pickable', 'GetPickable'),
    ('use_bounds', 'GetUseBounds'), ('visibility', 'GetVisibility'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('projection', 'GetProjection'),
    ('floor_plane', 'GetFloorPlane'), ('floor_right', 'GetFloorRight'),
    ('orientation', 'GetOrientation'), ('origin', 'GetOrigin'),
    ('position', 'GetPosition'), ('scale', 'GetScale'),
    ('estimated_render_time', 'GetEstimatedRenderTime'),
    ('render_time_multiplier', 'GetRenderTimeMultiplier'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'dragable', 'force_opaque', 'force_translucent',
    'gamma_correct', 'global_warning_display', 'pickable', 'use_bounds',
    'visibility', 'projection', 'estimated_render_time', 'floor_plane',
    'floor_right', 'orientation', 'origin', 'position',
    'render_time_multiplier', 'scale'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OpenGLMovieSphere, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OpenGLMovieSphere properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['force_opaque', 'force_translucent', 'gamma_correct',
            'use_bounds', 'visibility'], ['projection'], ['estimated_render_time',
            'floor_plane', 'floor_right', 'orientation', 'origin', 'position',
            'render_time_multiplier', 'scale']),
            title='Edit OpenGLMovieSphere properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OpenGLMovieSphere properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

