# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.array_data_algorithm import ArrayDataAlgorithm


class mNDHistogram(ArrayDataAlgorithm):
    r"""
    vtkmNDHistogram - generate a n dimensional histogram field from input
    fields
    
    Superclass: ArrayDataAlgorithm
    
    vtkmNDhistogram is a filter that generate a n dimensional histogram
    field from some input fields. This filter takes a data set and with
    target fields and bins defined, it would generate a N-Dims histogram
    from input fields. The input fields should have the same number of
    values. The result is stored in a field named as "Frequency". This
    field contains all the frequencies of the N-Dims histogram in sparse
    representation. That being said, the result field does not store 0
    frequency bins. Meanwhile all input fields now would have the same
    length and store bin ids instead. E.g. (FieldA[i], FieldB[i],
    FieldC[i], Frequency[i]) is a bin in the histogram. The first three
    numbers are binIDs for FieldA, FieldB and FieldC. Frequency[i] stores
    the frequency for this bin (FieldA[i], FieldB[i], FieldC[i]).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkmNDHistogram, obj, update, **traits)
    
    def get_bin_delta(self, *args):
        """
        get_bin_delta(self, fieldIndex:int) -> float
        C++: double get_bin_delta(size_t fieldIndex)"""
        ret = self._wrap_call(self._vtk_obj.GetBinDelta, *args)
        return ret

    def get_field_index_from_field_name(self, *args):
        """
        get_field_index_from_field_name(self, fieldName:str) -> int
        C++: int get_field_index_from_field_name(const std::string &fieldName)
        get_field_index_from_field_name
        @param fieldName
        @return the index of the fieldName. If it's not in the field_names
        list, a -1
        would be returned.
        """
        ret = self._wrap_call(self._vtk_obj.GetFieldIndexFromFieldName, *args)
        return ret

    def add_field_and_bin(self, *args):
        """
        add_field_and_bin(self, fieldName:str, numberOfBins:int) -> None
        C++: void add_field_and_bin(const std::string &fieldName,
            const IdType &numberOfBins)"""
        ret = self._wrap_call(self._vtk_obj.AddFieldAndBin, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(mNDHistogram, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit mNDHistogram properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit mNDHistogram properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit mNDHistogram properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

