# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class mLevelOfDetail(PolyDataAlgorithm):
    r"""
    vtkmLevelOfDetail - reduce the number of triangles in a mesh
    
    Superclass: PolyDataAlgorithm
    
    vtkmLevelOfDetail is a filter to reduce the number of triangles in a
    triangle mesh, forming a good approximation to the original geometry.
    The input to vtkmLevelOfDetail is a PolyData or UnstrcutredGrid
    object, and only triangles are treated. If you desire to decimate
    polygonal meshes, first triangulate the polygons with
    TriangleFilter object.
    
    The general approach of the algorithm is to cluster vertices in a
    uniform binning of space, accumulating to an average point within
    each bin. In more detail, the algorithm first gets the bounds of the
    input poly data. It then breaks this bounding volume into a
    user-specified number of spatial bins.  It then reads each triangle
    from the input and hashes its vertices into these bins. Then, if 2 or
    more vertices of the triangle fall in the same bin, the triangle is
    dicarded.  If the triangle is not discarded, it adds the triangle to
    the list of output triangles as a list of vertex identifiers.  (There
    is one vertex id per bin.)  After all the triangles have been read,
    the representative vertex for each bin is computed.  This determines
    the spatial location of the vertices of each of the triangles in the
    output.
    
    To use this filter, specify the divisions defining the spatial
    subdivision in the x, y, and z directions. Compared to algorithms
    such as QuadricClustering, a significantly higher bin count is
    recommended as it doesn't increase the computation or memory of the
    algorithm and will produce significantly better results.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkmLevelOfDetail, obj, update, **traits)
    
    number_of_divisions = traits.Trait((traits.Undefined, traits.Undefined, traits.Undefined), traits.Array(shape=(3,), dtype="int", value=(0, 0, 0), cols=3), enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the number of divisions for each axis for the spatial
        bins. The number of spatial bins is
        number_of_x_divisions*number_of_y_divisions* number_of_z_divisions.
        """
    )

    def _number_of_divisions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfDivisions,
                        self.number_of_divisions)

    number_of_x_divisions = traits.Int(512, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the number of divisions along an individual axis for the
        spatial bins. The number of spatial bins is
        number_of_x_divisions*number_of_y_divisions* number_of_z_divisions.
        """
    )

    def _number_of_x_divisions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfXDivisions,
                        self.number_of_x_divisions)

    number_of_y_divisions = traits.Int(512, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the number of divisions along an individual axis for the
        spatial bins. The number of spatial bins is
        number_of_x_divisions*number_of_y_divisions* number_of_z_divisions.
        """
    )

    def _number_of_y_divisions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfYDivisions,
                        self.number_of_y_divisions)

    number_of_z_divisions = traits.Int(512, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the number of divisions along an individual axis for the
        spatial bins. The number of spatial bins is
        number_of_x_divisions*number_of_y_divisions* number_of_z_divisions.
        """
    )

    def _number_of_z_divisions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfZDivisions,
                        self.number_of_z_divisions)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('number_of_x_divisions', 'GetNumberOfXDivisions'),
    ('number_of_y_divisions', 'GetNumberOfYDivisions'),
    ('number_of_z_divisions', 'GetNumberOfZDivisions'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'number_of_x_divisions', 'number_of_y_divisions',
    'number_of_z_divisions', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(mLevelOfDetail, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit mLevelOfDetail properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['number_of_x_divisions', 'number_of_y_divisions',
            'number_of_z_divisions']),
            title='Edit mLevelOfDetail properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit mLevelOfDetail properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

