# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.table_algorithm import TableAlgorithm


class mHistogram(TableAlgorithm):
    r"""
    vtkmHistogram - generate a histogram out of a scalar data
    
    Superclass: TableAlgorithm
    
    vtkmHistogram is a filter that generates a histogram out of a scalar
    data. The histogram consists of a certain number of bins specified by
    the user, and the user can fetch the range and bin delta after
    completion.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkmHistogram, obj, update, **traits)
    
    center_bins_around_min_and_max = tvtk_base.false_bool_trait(desc=\
        r"""
        Get/Set if first and last bins must be centered around the min
        and max data. This is only used when use_custom_bin_ranges is set to
        false. Default is false.
        """
    )

    def _center_bins_around_min_and_max_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCenterBinsAroundMinAndMax,
                        self.center_bins_around_min_and_max_)

    use_custom_bin_ranges = tvtk_base.false_bool_trait(desc=\
        r"""
        When set to true, custom_bin_ranges will  be used instead of using
        the full range for the selected array. By default, set to false.
        """
    )

    def _use_custom_bin_ranges_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseCustomBinRanges,
                        self.use_custom_bin_ranges_)

    custom_bin_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(100.0, 0.0), cols=2, desc=\
        r"""
        Specify the range to use to generate the histogram. They are only
        used when use_custom_bin_ranges is set to true.
        """
    )

    def _custom_bin_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCustomBinRange,
                        self.custom_bin_range)

    number_of_bins = traits.Int(10, enter_set=True, auto_set=False, desc=\
        r"""
        Specify number of bins.  Default is 10.
        """
    )

    def _number_of_bins_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfBins,
                        self.number_of_bins)

    def _get_bin_delta(self):
        return self._vtk_obj.GetBinDelta()
    bin_delta = traits.Property(_get_bin_delta, desc=\
        r"""
        Return the bin delta of the computed field.
        """
    )

    def _get_computed_range(self):
        return self._vtk_obj.GetComputedRange()
    computed_range = traits.Property(_get_computed_range, desc=\
        r"""
        Return the range used to generate the histogram.
        """
    )

    _updateable_traits_ = \
    (('center_bins_around_min_and_max', 'GetCenterBinsAroundMinAndMax'),
    ('use_custom_bin_ranges', 'GetUseCustomBinRanges'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('custom_bin_range', 'GetCustomBinRange'),
    ('number_of_bins', 'GetNumberOfBins'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'center_bins_around_min_and_max', 'debug',
    'global_warning_display', 'release_data_flag',
    'use_custom_bin_ranges', 'custom_bin_range', 'number_of_bins',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(mHistogram, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit mHistogram properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['center_bins_around_min_and_max', 'use_custom_bin_ranges'], [],
            ['custom_bin_range', 'number_of_bins']),
            title='Edit mHistogram properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit mHistogram properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

