# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.multi_block_data_set_algorithm import MultiBlockDataSetAlgorithm


class GDALVectorReader(MultiBlockDataSetAlgorithm):
    r"""
    GDALVectorReader - Read vector file formats using GDAL.
    
    Superclass: MultiBlockDataSetAlgorithm
    
    GDALVectorReader is a source object that reads vector files and
    uses GDAL as the underlying library for the task. GDAL is required
    for this reader. The output of the reader is a MultiBlockDataSet
    
    This filter uses the active_layer member to only load entries from the
    specified layer (when active_layer >= 0).
    
    @sa
    MultiBlockDataSet
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGDALVectorReader, obj, update, **traits)
    
    add_feature_ids = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/get whether feature IDs should be generated. Some GDAL
        primitives (e.g., a polygon with a hole in its interior) are
        represented by multiple VTK cells. If you wish to identify the
        primitive responsible for a VTK cell, turn this on. It is off by
        default for backwards compatibility. The array of feature IDs
        will be the active cell-data pedigree IDs.
        """
    )

    def _add_feature_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAddFeatureIds,
                        self.add_feature_ids_)

    append_features = tvtk_base.false_bool_trait(desc=\
        r"""
        Set and Get whether features are appended to a single
        PolyData. Turning the option on is useful when a shapefile has
        a number of features which could otherwise lead to a huge
        multiblock structure.
        """
    )

    def _append_features_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAppendFeatures,
                        self.append_features_)

    active_layer = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        r"""
        Set and Get the active layer. If active_layer is less than 0 (the
        default is -1), then all layers are read. Otherwise, only the
        specified layer is read.
        """
    )

    def _active_layer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetActiveLayer,
                        self.active_layer)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    def _get_active_layer_feature_count(self):
        return self._vtk_obj.GetActiveLayerFeatureCount()
    active_layer_feature_count = traits.Property(_get_active_layer_feature_count, desc=\
        r"""
        Return the number of features in the active layer (shapes).
        """
    )

    def _get_active_layer_type(self):
        return self._vtk_obj.GetActiveLayerType()
    active_layer_type = traits.Property(_get_active_layer_type, desc=\
        r"""
        Return the active layer type (eg point, line, polygon).
        """
    )

    def get_feature_count(self, *args):
        """
        get_feature_count(self, layerIndex:int=0) -> int
        C++: int get_feature_count(int layerIndex=0)
        Given a layer index return number of features (shapes).
        """
        ret = self._wrap_call(self._vtk_obj.GetFeatureCount, *args)
        return ret

    def get_layer_projection(self, *args):
        """
        get_layer_projection(self, layerIndex:int) -> str
        C++: const char *get_layer_projection(int layerIndex)
        Return projection string belonging to a layer in WKT format.
        """
        ret = self._wrap_call(self._vtk_obj.GetLayerProjection, *args)
        return ret

    def get_layer_projection_as_proj4(self, *args):
        """
        get_layer_projection_as_proj4(self, layerIndex:int) -> str
        C++: const char *get_layer_projection_as_proj4(int layerIndex)
        Return projection string belonging to a layer in PROJ.4 format
        
        ote The returned string has to be deleted (via delete[]) by the
        calling program.
        """
        ret = self._wrap_call(self._vtk_obj.GetLayerProjectionAsProj4, *args)
        return ret

    def get_layer_type(self, *args):
        """
        get_layer_type(self, layerIndex:int=0) -> int
        C++: int get_layer_type(int layerIndex=0)
        Given a index return layer type (eg point, line, polygon).
        """
        ret = self._wrap_call(self._vtk_obj.GetLayerType, *args)
        return ret

    def _get_number_of_layers(self):
        return self._vtk_obj.GetNumberOfLayers()
    number_of_layers = traits.Property(_get_number_of_layers, desc=\
        r"""
        Return number of layers.
        """
    )

    _updateable_traits_ = \
    (('add_feature_ids', 'GetAddFeatureIds'), ('append_features',
    'GetAppendFeatures'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('active_layer', 'GetActiveLayer'), ('file_name', 'GetFileName'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'add_feature_ids', 'append_features', 'debug',
    'global_warning_display', 'release_data_flag', 'active_layer',
    'file_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GDALVectorReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GDALVectorReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['add_feature_ids', 'append_features'], [], ['active_layer',
            'file_name']),
            title='Edit GDALVectorReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GDALVectorReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

