# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.algorithm import Algorithm


class FidesReader(Algorithm):
    r"""
    FidesReader - Read ADIOS2 streams using Fides data model
    
    Superclass: Algorithm
    
    FidesReader is a data source that reads ADIOS2 files or data
    streams (SST engine, inline engine etc.). The data model in these
    data streams is defined by the Fides library:
    (https://gitlab.kitware.com/vtk/fides/) See the Fides documentation
    for the details of the schema used to represent VTK/VTK-m data
    models. The reader can create partitioned datasets containing native
    VTK dataset or  VTK VTK-m datasets. Time and time streaming is
    supported. Note that the interface for time streaming is different.
    It requires calling prepare_next_step() and Update() for each new step.
    Partitioned (in ADIOS2 terminology blocks) data is supported.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkFidesReader, obj, update, **traits)
    
    convert_to_vtk = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _convert_to_vtk_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConvertToVTK,
                        self.convert_to_vtk_)

    def _get_cell_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetCellDataArraySelection())
    cell_data_array_selection = traits.Property(_get_cell_data_array_selection, desc=\
        r"""
        Object to perform cell array selection before update.
        """
    )

    def _get_next_step_status(self):
        return self._vtk_obj.GetNextStepStatus()
    next_step_status = traits.Property(_get_next_step_status, desc=\
        r"""
        Get the step_status of the next step reported by Fides. See enum
        FidesReader::StepStatus for potential return values. This is
        updated in prepare_next_step() and set back to not_ready after
        reading a step.
        """
    )

    def _get_point_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetPointDataArraySelection())
    point_data_array_selection = traits.Property(_get_point_data_array_selection, desc=\
        r"""
        Object to perform point array selection before update.
        """
    )

    def can_read_file(self, *args):
        """
        can_read_file(self, name:str) -> int
        C++: int can_read_file(const std::string &name)
        Test whether or not a given file should even be attempted for use
        with this reader.
        """
        ret = self._wrap_call(self._vtk_obj.CanReadFile, *args)
        return ret

    def parse_data_model(self, *args):
        """
        parse_data_model(self, fname:str) -> None
        C++: void parse_data_model(const std::string &fname)
        parse_data_model(self) -> None
        C++: void parse_data_model()
        Given a json filename, parse and internally store a data model.
        Has to be called before any data input can take place. See the
        Fides documentation for the description of the schema.
        """
        ret = self._wrap_call(self._vtk_obj.ParseDataModel, *args)
        return ret

    def prepare_next_step(self):
        """
        prepare_next_step(self) -> None
        C++: void prepare_next_step()
        This method has to be called before each step when streaming. It
        will move to the next step and initialize any meta-data
        necessary. The loading of the next step is done in the update
        pipeline pass. Note that this internally calls Modified() on the
        reader to force the next update to cause an execution.
        """
        ret = self._vtk_obj.PrepareNextStep()
        return ret
        

    def set_data_source_path(self, *args):
        """
        set_data_source_path(self, name:str, path:str) -> None
        C++: void set_data_source_path(const std::string &name,
            const std::string &path)
        Set the path for a Fides data source. This can be a file, an SST
        stream or an inline data source. The name of the data source
        corresponds to what is in the data model.
        """
        ret = self._wrap_call(self._vtk_obj.SetDataSourcePath, *args)
        return ret

    def set_file_name(self, *args):
        """
        set_file_name(self, fname:str) -> None
        C++: void set_file_name(const std::string &fname)
        Set the filename to be read
        """
        ret = self._wrap_call(self._vtk_obj.SetFileName, *args)
        return ret

    _updateable_traits_ = \
    (('convert_to_vtk', 'GetConvertToVTK'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'convert_to_vtk', 'debug',
    'global_warning_display', 'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(FidesReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit FidesReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['convert_to_vtk'], [], []),
            title='Edit FidesReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit FidesReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

