# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.open_gl_renderer import OpenGLRenderer


class ExternalOpenGLRenderer(OpenGLRenderer):
    r"""
    ExternalOpenGLRenderer - open_gl renderer
    
    Superclass: OpenGLRenderer
    
    ExternalOpenGLRenderer is a secondary implementation of the class
    OpenGLRenderer. ExternalOpenGLRenderer interfaces to the open_gl
    graphics library. This class provides API to preserve the color and
    depth buffers, thereby allowing external applications to manage the
    open_gl buffers. This becomes very useful when there are multiple
    open_gl applications sharing the same open_gl context.
    
    ExternalOpenGLRenderer makes sure that the camera used in the
    scene if of type ExternalOpenGLCamera. It manages light and camera
    transformations for VTK objects in the open_gl context.
    
    \sa ExternalOpenGLCamera
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExternalOpenGLRenderer, obj, update, **traits)
    
    preserve_gl_camera_matrices = tvtk_base.true_bool_trait(desc=\
        r"""
        
        """
    )

    def _preserve_gl_camera_matrices_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPreserveGLCameraMatrices,
                        self.preserve_gl_camera_matrices_)

    preserve_gl_lights = tvtk_base.true_bool_trait(desc=\
        r"""
        
        """
    )

    def _preserve_gl_lights_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPreserveGLLights,
                        self.preserve_gl_lights_)

    def add_external_light(self, *args):
        """
        add_external_light(self, __a:ExternalLight) -> None
        C++: virtual void add_external_light(ExternalLight *)
        Add an external light to the list of external lights.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddExternalLight, *my_args)
        return ret

    def remove_all_external_lights(self):
        """
        remove_all_external_lights(self) -> None
        C++: virtual void remove_all_external_lights()
        Remove all external lights
        """
        ret = self._vtk_obj.RemoveAllExternalLights()
        return ret
        

    def remove_external_light(self, *args):
        """
        remove_external_light(self, __a:ExternalLight) -> None
        C++: virtual void remove_external_light(ExternalLight *)
        Remove an external light from the list of external lights.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveExternalLight, *my_args)
        return ret

    _updateable_traits_ = \
    (('preserve_gl_camera_matrices', 'GetPreserveGLCameraMatrices'),
    ('preserve_gl_lights', 'GetPreserveGLLights'),
    ('use_spherical_harmonics', 'GetUseSphericalHarmonics'),
    ('automatic_light_creation', 'GetAutomaticLightCreation'),
    ('backing_store', 'GetBackingStore'), ('draw', 'GetDraw'), ('erase',
    'GetErase'), ('interactive', 'GetInteractive'),
    ('light_follow_camera', 'GetLightFollowCamera'),
    ('preserve_color_buffer', 'GetPreserveColorBuffer'),
    ('preserve_depth_buffer', 'GetPreserveDepthBuffer'), ('ssao_blur',
    'GetSSAOBlur'), ('textured_background', 'GetTexturedBackground'),
    ('two_sided_lighting', 'GetTwoSidedLighting'),
    ('use_depth_peeling_for_volumes', 'GetUseDepthPeelingForVolumes'),
    ('use_depth_peeling', 'GetUseDepthPeeling'), ('use_fxaa',
    'GetUseFXAA'), ('use_hidden_line_removal', 'GetUseHiddenLineRemoval'),
    ('use_image_based_lighting', 'GetUseImageBasedLighting'), ('use_ssao',
    'GetUseSSAO'), ('use_shadows', 'GetUseShadows'),
    ('gradient_background', 'GetGradientBackground'),
    ('gradient_environmental_bg', 'GetGradientEnvironmentalBG'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('allocated_render_time', 'GetAllocatedRenderTime'), ('ambient',
    'GetAmbient'), ('clipping_range_expansion',
    'GetClippingRangeExpansion'), ('environment_right',
    'GetEnvironmentRight'), ('environment_up', 'GetEnvironmentUp'),
    ('layer', 'GetLayer'), ('maximum_number_of_peels',
    'GetMaximumNumberOfPeels'), ('near_clipping_plane_tolerance',
    'GetNearClippingPlaneTolerance'), ('occlusion_ratio',
    'GetOcclusionRatio'), ('ssao_bias', 'GetSSAOBias'),
    ('ssao_kernel_size', 'GetSSAOKernelSize'), ('ssao_radius',
    'GetSSAORadius'), ('aspect', 'GetAspect'), ('background',
    'GetBackground'), ('background2', 'GetBackground2'),
    ('background_alpha', 'GetBackgroundAlpha'), ('display_point',
    'GetDisplayPoint'), ('environmental_bg', 'GetEnvironmentalBG'),
    ('environmental_bg2', 'GetEnvironmentalBG2'), ('pixel_aspect',
    'GetPixelAspect'), ('view_point', 'GetViewPoint'), ('viewport',
    'GetViewport'), ('world_point', 'GetWorldPoint'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['automatic_light_creation', 'backing_store', 'debug', 'draw',
    'erase', 'global_warning_display', 'gradient_background',
    'gradient_environmental_bg', 'interactive', 'light_follow_camera',
    'preserve_color_buffer', 'preserve_depth_buffer',
    'preserve_gl_camera_matrices', 'preserve_gl_lights', 'ssao_blur',
    'textured_background', 'two_sided_lighting', 'use_depth_peeling',
    'use_depth_peeling_for_volumes', 'use_fxaa',
    'use_hidden_line_removal', 'use_image_based_lighting', 'use_shadows',
    'use_spherical_harmonics', 'use_ssao', 'allocated_render_time',
    'ambient', 'aspect', 'background', 'background2', 'background_alpha',
    'clipping_range_expansion', 'display_point', 'environment_right',
    'environment_up', 'environmental_bg', 'environmental_bg2', 'layer',
    'maximum_number_of_peels', 'near_clipping_plane_tolerance',
    'occlusion_ratio', 'pixel_aspect', 'ssao_bias', 'ssao_kernel_size',
    'ssao_radius', 'view_point', 'viewport', 'world_point'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExternalOpenGLRenderer, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExternalOpenGLRenderer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['automatic_light_creation', 'backing_store', 'draw', 'erase',
            'gradient_background', 'gradient_environmental_bg', 'interactive',
            'light_follow_camera', 'preserve_color_buffer',
            'preserve_depth_buffer', 'preserve_gl_camera_matrices',
            'preserve_gl_lights', 'ssao_blur', 'textured_background',
            'two_sided_lighting', 'use_depth_peeling',
            'use_depth_peeling_for_volumes', 'use_fxaa',
            'use_hidden_line_removal', 'use_image_based_lighting', 'use_shadows',
            'use_spherical_harmonics', 'use_ssao'], [], ['allocated_render_time',
            'ambient', 'aspect', 'background', 'background2', 'background_alpha',
            'clipping_range_expansion', 'display_point', 'environment_right',
            'environment_up', 'environmental_bg', 'environmental_bg2', 'layer',
            'maximum_number_of_peels', 'near_clipping_plane_tolerance',
            'occlusion_ratio', 'pixel_aspect', 'ssao_bias', 'ssao_kernel_size',
            'ssao_radius', 'view_point', 'viewport', 'world_point']),
            title='Edit ExternalOpenGLRenderer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExternalOpenGLRenderer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

