# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Compositer(Object):
    r"""
    Compositer - Super class for composite algorthms.
    
    Superclass: Object
    
    Compositer operates in multiple processes.  Each compositer has a
    render window.  They use MultiProcessControllers to communicate
    the color and depth buffer to process 0's render window. It will not
    handle transparency well.
    
    @sa
    CompositeManager.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCompositer, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        r"""
        
        """
    )

    number_of_processes = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        A hack to get a sub world until I can get communicators working.
        """
    )

    def _number_of_processes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfProcesses,
                        self.number_of_processes)

    def composite_buffer(self, *args):
        """
        composite_buffer(self, pBuf:DataArray, zBuf:FloatArray,
            pTmp:DataArray, zTmp:FloatArray) -> None
        C++: virtual void composite_buffer(DataArray *pBuf,
            FloatArray *zBuf, DataArray *pTmp, FloatArray *zTmp)
        This method gets called on every process.  The final image gets
        put into pBuf and zBuf.
        """
        my_args = deref_array(args, [('vtkDataArray', 'vtkFloatArray', 'vtkDataArray', 'vtkFloatArray')])
        ret = self._wrap_call(self._vtk_obj.CompositeBuffer, *my_args)
        return ret

    def delete_array(self, *args):
        """
        delete_array(da:DataArray) -> None
        C++: static void delete_array(DataArray *da)
        Methods that allocate and delete memory with special MPIPro
        calls.
        """
        my_args = deref_array(args, [['vtkDataArray']])
        ret = self._wrap_call(self._vtk_obj.DeleteArray, *my_args)
        return ret

    def resize_float_array(self, *args):
        """
        resize_float_array(fa:FloatArray, numComp:int, size:int) -> None
        C++: static void resize_float_array(FloatArray *fa, int numComp,
            IdType size)"""
        my_args = deref_array(args, [('vtkFloatArray', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.ResizeFloatArray, *my_args)
        return ret

    def resize_unsigned_char_array(self, *args):
        """
        resize_unsigned_char_array(uca:UnsignedCharArray, numComp:int,
            size:int) -> None
        C++: static void resize_unsigned_char_array(
            UnsignedCharArray *uca, int numComp, IdType size)"""
        my_args = deref_array(args, [('vtkUnsignedCharArray', 'int', 'int')])
        ret = self._wrap_call(self._vtk_obj.ResizeUnsignedCharArray, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('number_of_processes',
    'GetNumberOfProcesses'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'number_of_processes'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Compositer, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Compositer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['number_of_processes']),
            title='Edit Compositer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Compositer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

