# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.render_pass import RenderPass


class CompositeRGBAPass(RenderPass):
    r"""
    CompositeRGBAPass - Blend RGBA buffers of processes.
    
    Superclass: RenderPass
    
    Blend the RGBA buffers of satellite processes over the root process
    RGBA buffer. The RGBA buffer of the satellite processes are not
    changed.
    
    This pass requires a open_gl context that supports texture objects
    (TO), and pixel buffer objects (PBO). If not, it will emit an error
    message and will render its delegate and return.
    
    @sa
    RenderPass
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCompositeRGBAPass, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        r"""
        Controller If it is NULL, nothing will be rendered and a warning
        will be emitted. Initial value is a NULL pointer.
        """
    )

    def _get_kdtree(self):
        return wrap_vtk(self._vtk_obj.GetKdtree())
    def _set_kdtree(self, arg):
        old_val = self._get_kdtree()
        self._wrap_call(self._vtk_obj.SetKdtree,
                        deref_vtk(arg))
        self.trait_property_changed('kdtree', old_val, arg)
    kdtree = traits.Property(_get_kdtree, _set_kdtree, desc=\
        r"""
        kd tree that gives processes ordering. Initial value is a NULL
        pointer.
        """
    )

    def is_supported(self, *args):
        """
        is_supported(self, context:OpenGLRenderWindow) -> bool
        C++: bool is_supported(OpenGLRenderWindow *context)
        Is the pass supported by the open_gl context?
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.IsSupported, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CompositeRGBAPass, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CompositeRGBAPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit CompositeRGBAPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CompositeRGBAPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

