# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.archiver import Archiver


class BufferedArchiver(Archiver):
    r"""
    BufferedArchiver - Writes an archive to a buffer for vtk-js
    datasets
    
    Superclass: Archiver
    
    vtkJSBufferedArchiver is a specialized archiver for writing
    datasets into a memory buffer with zip compression.
    
    @sa
    Archiver
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBufferedArchiver, obj, update, **traits)
    
    allocated_size = traits.Int(100000, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the allocated buffer size.
        """
    )

    def _allocated_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAllocatedSize,
                        self.allocated_size)

    def _get_buffer(self):
        return self._vtk_obj.GetBuffer()
    buffer = traits.Property(_get_buffer, desc=\
        r"""
        Access the buffer.
        """
    )

    def _get_buffer_address(self):
        return self._vtk_obj.GetBufferAddress()
    buffer_address = traits.Property(_get_buffer_address, desc=\
        r"""
        Access the address of the buffer.
        """
    )

    def _get_buffer_size(self):
        return self._vtk_obj.GetBufferSize()
    buffer_size = traits.Property(_get_buffer_size, desc=\
        r"""
        Get the buffer used size.
        """
    )

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('allocated_size', 'GetAllocatedSize'),
    ('archive_name', 'GetArchiveName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'allocated_size',
    'archive_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BufferedArchiver, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BufferedArchiver properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['allocated_size', 'archive_name']),
            title='Edit BufferedArchiver properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BufferedArchiver properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

