# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.undirected_graph_algorithm import UndirectedGraphAlgorithm


class BoostBiconnectedComponents(UndirectedGraphAlgorithm):
    r"""
    BoostBiconnectedComponents - Find the biconnected components of a
    graph
    
    Superclass: UndirectedGraphAlgorithm
    
    The biconnected components of a graph are maximal regions of the
    graph where the removal of any single vertex from the region will not
    disconnect the graph.  Every edge belongs to exactly one biconnected
    component.  The biconnected component of each edge is given in the
    edge array named "biconnected component".  The biconnected component
    of each vertex is also given in the vertex array named "biconnected
    component".  Cut vertices (or articulation points) belong to multiple
    biconnected components, and break the graph apart if removed.  These
    are indicated by assigning a component value of -1.  To get the
    biconnected components that a cut vertex belongs to, traverse its
    edge list and collect the distinct component ids for its incident
    edges.
    
    Self-loop edges that start and end at the same vertex are not
    assigned a biconnected component, and are given component id -1.
    
    @warning
    The boost graph bindings currently only support boost version 1.33.1.
    There are apparently backwards-compatibility issues with later
    versions.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBoostBiconnectedComponents, obj, update, **traits)
    
    def set_output_array_name(self, *args):
        """
        set_output_array_name(self, _arg:str) -> None
        C++: virtual void set_output_array_name(const char *_arg)
        Set the output array name. If no output array name is set then
        the name "biconnected component" is used.
        """
        ret = self._wrap_call(self._vtk_obj.SetOutputArrayName, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BoostBiconnectedComponents, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BoostBiconnectedComponents properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit BoostBiconnectedComponents properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BoostBiconnectedComponents properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

