"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubjectRemovedAndUpdatedError = void 0;
var tslib_1 = require("tslib");
var TypeORMError_1 = require("./TypeORMError");
/**
 * Thrown when same object is scheduled for remove and updation at the same time.
 */
var SubjectRemovedAndUpdatedError = /** @class */ (function (_super) {
    (0, tslib_1.__extends)(SubjectRemovedAndUpdatedError, _super);
    function SubjectRemovedAndUpdatedError(subject) {
        return _super.call(this, "Removed entity \"" + subject.metadata.name + "\" is also scheduled for update operation. " +
            "Make sure you are not updating and removing same object (note that update or remove may be executed by cascade operations).") || this;
    }
    return SubjectRemovedAndUpdatedError;
}(TypeORMError_1.TypeORMError));
exports.SubjectRemovedAndUpdatedError = SubjectRemovedAndUpdatedError;

//# sourceMappingURL=SubjectRemovedAndUpdatedError.js.map
