/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.UpperBoundChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.jvm.checkers.EnhancedNullabilityInfo;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityChecker;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityCheckerKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.WarningAwareUpperBoundChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.AbstractNullabilityChecker;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.NotNullTypeParameter;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerState;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerStateKt;
import org.jetbrains.kotlin.types.checker.KotlinTypePreparator;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerImpl;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J,\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J$\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002Jf\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f26\u0010 \u001a2\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\b0!H\u0002JI\u0010%\u001a\u0004\u0018\u0001H&\"\b\b\u0000\u0010&*\u00020'2\u0006\u0010(\u001a\u00020\u00152\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00172\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H&0\u001cH\u0002\u00a2\u0006\u0002\u0010+J&\u0010,\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J,\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00172\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00061\u00b2\u0006\n\u0010)\u001a\u00020\u001dX\u008a\u0084\u0002\u00b2\u0006\n\u0010)\u001a\u00020\u001dX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaNullabilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "upperBoundChecker", "Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "(Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;)V", "getUpperBoundChecker", "()Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "checkReceiver", "", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "safeAccess", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "checkType", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkTypeParameterBounds", "doCheckType", "expectedType", "expressionTypeDataFlowValue", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "reportWarning", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "actualType", "doIfNotNull", "T", "", "type", "dataFlowValue", "body", "(Lorg/jetbrains/kotlin/types/KotlinType;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "exactedExpressionTypeByDataFlowNullability", "findTypeParameterWithWrongBoundsNullability", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "dataFlowValueForWholeExpression", "Companion", "frontend.java"})
public final class JavaNullabilityChecker
implements AdditionalTypeChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UpperBoundChecker upperBoundChecker;
    @NotNull
    private static final NewKotlinTypeCheckerImpl typeCheckerForEnhancedTypes = new NewKotlinTypeCheckerImpl(KotlinTypeRefiner.Default.INSTANCE, new KotlinTypePreparator(){

        @NotNull
        public UnwrappedType prepareType(@NotNull KotlinTypeMarker type2) {
            Intrinsics.checkNotNullParameter(type2, "type");
            UnwrappedType it = super.prepareType(type2);
            boolean bl = false;
            KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply(it);
            if (kotlinType == null) {
                kotlinType = it;
            }
            return kotlinType.unwrap();
        }
    });
    @NotNull
    private static final NewKotlinTypeCheckerImpl typeCheckerForBaseTypes = new NewKotlinTypeCheckerImpl(KotlinTypeRefiner.Default.INSTANCE, null, 2, null);

    public JavaNullabilityChecker(@NotNull UpperBoundChecker upperBoundChecker) {
        Intrinsics.checkNotNullParameter(upperBoundChecker, "upperBoundChecker");
        this.upperBoundChecker = upperBoundChecker;
    }

    @NotNull
    public final UpperBoundChecker getUpperBoundChecker() {
        return this.upperBoundChecker;
    }

    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        IElementType iElementType;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(expressionType, "expressionType");
        Intrinsics.checkNotNullParameter(expressionTypeWithSmartCast, "expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, "c");
        this.checkTypeParameterBounds(expression2, expressionType, c);
        Lazy<DataFlowValue> dataFlowValue$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<DataFlowValue>(c, expression2, expressionType){
            final /* synthetic */ ResolutionContext<?> $c;
            final /* synthetic */ KtExpression $expression;
            final /* synthetic */ KotlinType $expressionType;
            {
                this.$c = $c;
                this.$expression = $expression;
                this.$expressionType = $expressionType;
                super(0);
            }

            @NotNull
            public final DataFlowValue invoke() {
                return this.$c.dataFlowValueFactory.createDataFlowValue(this.$expression, this.$expressionType, this.$c);
            }
        });
        TypeParameterDescriptor typeParameterDescriptor = this.findTypeParameterWithWrongBoundsNullability(expressionType, c, new Function0<DataFlowValue>(dataFlowValue$delegate){
            final /* synthetic */ Lazy<DataFlowValue> $dataFlowValue$delegate;
            {
                this.$dataFlowValue$delegate = $dataFlowValue$delegate;
                super(0);
            }

            @NotNull
            public final DataFlowValue invoke() {
                return JavaNullabilityChecker.access$checkType$lambda$0(this.$dataFlowValue$delegate);
            }
        });
        if (typeParameterDescriptor != null) {
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            boolean bl = false;
            c.trace.report(ErrorsJvm.NULLABLE_TYPE_PARAMETER_AGAINST_NOT_NULL_TYPE_PARAMETER.on((KtElement)((PsiElement)expression2), typeParameterDescriptor2));
        }
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkNotNullExpressionValue(kotlinType, "c.expectedType");
        Function0 function0 = new Function0<DataFlowValue>(dataFlowValue$delegate){
            final /* synthetic */ Lazy<DataFlowValue> $dataFlowValue$delegate;
            {
                this.$dataFlowValue$delegate = $dataFlowValue$delegate;
                super(0);
            }

            @NotNull
            public final DataFlowValue invoke() {
                return JavaNullabilityChecker.access$checkType$lambda$0(this.$dataFlowValue$delegate);
            }
        };
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "c.dataFlowInfo");
        this.doCheckType(expressionType, kotlinType, function0, dataFlowInfo, (Function2<? super KotlinType, ? super KotlinType, Unit>)new Function2<KotlinType, KotlinType, Unit>(c, expression2){
            final /* synthetic */ ResolutionContext<?> $c;
            final /* synthetic */ KtExpression $expression;
            {
                this.$c = $c;
                this.$expression = $expression;
                super(2);
            }

            public final void invoke(@NotNull KotlinType expectedType, @NotNull KotlinType actualType) {
                Intrinsics.checkNotNullParameter(expectedType, "expectedType");
                Intrinsics.checkNotNullParameter(actualType, "actualType");
                this.$c.trace.report(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)this.$expression), expectedType, actualType));
            }
        });
        KtExpression ktExpression = expression2;
        if (ktExpression instanceof KtWhenExpression) {
            if (((KtWhenExpression)expression2).getElseExpression() == null) {
                KtExpression ktExpression2 = ((KtWhenExpression)expression2).getSubjectExpression();
                if (ktExpression2 == null) {
                    return;
                }
                KtExpression subjectExpression = ktExpression2;
                KotlinType kotlinType2 = c.trace.getType(subjectExpression);
                if (kotlinType2 == null) {
                    return;
                }
                KotlinType type2 = kotlinType2;
                if (FlexibleTypesKt.isFlexible(type2) && TypeUtils.isNullableType(FlexibleTypesKt.asFlexibleType(type2).getUpperBound())) {
                    ClassDescriptor classDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum(type2);
                    if (classDescriptor == null) {
                        return;
                    }
                    ClassDescriptor enumClassDescriptor = classDescriptor;
                    BindingContext bindingContext = c.trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue(bindingContext, "c.trace.bindingContext");
                    BindingContext context = bindingContext;
                    if (WhenChecker.getEnumMissingCases((KtWhenExpression)expression2, context, enumClassDescriptor).isEmpty() && !WhenChecker.INSTANCE.containsNullCase((KtWhenExpression)expression2, context)) {
                        DataFlowInfo dataFlowInfo2;
                        DataFlowValue subjectDataFlowValue = c.dataFlowValueFactory.createDataFlowValue(subjectExpression, type2, c);
                        KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)c.trace.get(BindingContext.EXPRESSION_TYPE_INFO, subjectExpression);
                        DataFlowInfo dataFlowInfo3 = dataFlowInfo2 = kotlinTypeInfo != null ? kotlinTypeInfo.getDataFlowInfo() : null;
                        if (dataFlowInfo2 != null && !dataFlowInfo2.getStableNullability(subjectDataFlowValue).canBeNull()) {
                            return;
                        }
                        BindingTrace bindingTrace = c.trace;
                        KtExpression ktExpression3 = ((KtWhenExpression)expression2).getSubjectExpression();
                        Intrinsics.checkNotNull(ktExpression3);
                        bindingTrace.report(ErrorsJvm.WHEN_ENUM_CAN_BE_NULL_IN_JAVA.on((KtExpression)((PsiElement)ktExpression3)));
                    }
                }
            }
        } else if (ktExpression instanceof KtPostfixExpression) {
            if (Intrinsics.areEqual(((KtPostfixExpression)expression2).getOperationToken(), KtTokens.EXCLEXCL)) {
                KtExpression ktExpression4 = ((KtPostfixExpression)expression2).getBaseExpression();
                if (ktExpression4 == null) {
                    return;
                }
                KtExpression baseExpression = ktExpression4;
                KotlinType kotlinType3 = c.trace.getType(baseExpression);
                if (kotlinType3 == null) {
                    return;
                }
                KotlinType baseExpressionType = kotlinType3;
                this.doIfNotNull(baseExpressionType, new Function0<DataFlowValue>(c, baseExpression, baseExpressionType){
                    final /* synthetic */ ResolutionContext<?> $c;
                    final /* synthetic */ KtExpression $baseExpression;
                    final /* synthetic */ KotlinType $baseExpressionType;
                    {
                        this.$c = $c;
                        this.$baseExpression = $baseExpression;
                        this.$baseExpressionType = $baseExpressionType;
                        super(0);
                    }

                    @NotNull
                    public final DataFlowValue invoke() {
                        return this.$c.dataFlowValueFactory.createDataFlowValue(this.$baseExpression, this.$baseExpressionType, this.$c);
                    }
                }, c, (Function0)new Function0<Unit>(c, expression2, baseExpressionType){
                    final /* synthetic */ ResolutionContext<?> $c;
                    final /* synthetic */ KtExpression $expression;
                    final /* synthetic */ KotlinType $baseExpressionType;
                    {
                        this.$c = $c;
                        this.$expression = $expression;
                        this.$baseExpressionType = $baseExpressionType;
                        super(0);
                    }

                    public final void invoke() {
                        this.$c.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on(((KtPostfixExpression)this.$expression).getOperationReference(), this.$baseExpressionType));
                    }
                });
            }
        } else if (ktExpression instanceof KtBinaryExpression && (((Intrinsics.areEqual(iElementType = ((KtBinaryExpression)expression2).getOperationToken(), KtTokens.EQEQ) ? true : Intrinsics.areEqual(iElementType, KtTokens.EXCLEQ)) ? true : Intrinsics.areEqual(iElementType, KtTokens.EQEQEQ)) ? true : Intrinsics.areEqual(iElementType, KtTokens.EXCLEQEQEQ)) && ((KtBinaryExpression)expression2).getLeft() != null && ((KtBinaryExpression)expression2).getRight() != null) {
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)expression2;
            KtExpression ktExpression5 = ((KtBinaryExpression)expression2).getLeft();
            Intrinsics.checkNotNull(ktExpression5);
            KtExpression ktExpression6 = ((KtBinaryExpression)expression2).getRight();
            Intrinsics.checkNotNull(ktExpression6);
            SenselessComparisonChecker.checkSenselessComparisonWithNull(ktBinaryExpression, ktExpression5, ktExpression6, c, (Function1<? super KtExpression, ? extends KotlinType>)new Function1<KtExpression, KotlinType>(c){
                final /* synthetic */ ResolutionContext<?> $c;
                {
                    this.$c = $c;
                    super(1);
                }

                @Nullable
                public final KotlinType invoke(@NotNull KtExpression it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$c.trace.getType(it);
                }
            }, (Function1<? super DataFlowValue, ? extends Nullability>)new Function1<DataFlowValue, Nullability>(this, c){
                final /* synthetic */ JavaNullabilityChecker this$0;
                final /* synthetic */ ResolutionContext<?> $c;
                {
                    this.this$0 = $receiver;
                    this.$c = $c;
                    super(1);
                }

                @NotNull
                public final Nullability invoke(@NotNull DataFlowValue value2) {
                    Intrinsics.checkNotNullParameter(value2, "value");
                    Nullability nullability = (Nullability)((Object)JavaNullabilityChecker.access$doIfNotNull(this.this$0, value2.getType(), new Function0<DataFlowValue>(value2){
                        final /* synthetic */ DataFlowValue $value;
                        {
                            this.$value = $value;
                            super(0);
                        }

                        @NotNull
                        public final DataFlowValue invoke() {
                            return this.$value;
                        }
                    }, this.$c, checkType.2.INSTANCE));
                    if (nullability == null) {
                        nullability = Nullability.UNKNOWN;
                    }
                    return nullability;
                }
            });
        }
    }

    private final void checkTypeParameterBounds(KtExpression expression2, KotlinType expressionType, ResolutionContext<?> c) {
        if (expressionType instanceof AbbreviatedType) {
            KotlinType kotlinType = ((AbbreviatedType)expressionType).getExpandedType();
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace, "c.trace");
            this.upperBoundChecker.checkBoundsOfExpandedTypeAlias(kotlinType, expression2, bindingTrace);
        }
        if (!(this.upperBoundChecker instanceof WarningAwareUpperBoundChecker)) {
            return;
        }
        Object object = c instanceof BasicCallResolutionContext ? (BasicCallResolutionContext)c : null;
        if (object == null || (object = ((BasicCallResolutionContext)object).call) == null) {
            KtCallExpression ktCallExpression = expression2 instanceof KtCallExpression ? (KtCallExpression)expression2 : null;
            object = (Call)c.trace.getBindingContext().get(BindingContext.CALL, ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null);
            if (object == null) {
                return;
            }
        }
        Object call2 = object;
        ResolvedCall resolvedCall2 = (ResolvedCall)c.trace.getBindingContext().get(BindingContext.RESOLVED_CALL, call2);
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        Iterable typeArguments2 = resolvedCall3 instanceof NewResolvedCallImpl ? (Iterable)((NewResolvedCallImpl)resolvedCall3).getResolvedCallAtom().getTypeArgumentMappingByOriginal() : (Iterable)resolvedCall3.getTypeArguments().entrySet();
        for (Map.Entry entry : typeArguments2) {
            TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)entry.getKey();
            KotlinType typeArgument = (KotlinType)entry.getValue();
            List<KtTypeProjection> list2 = call2.getTypeArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "call.typeArguments");
            KtModifierListOwnerStub ktModifierListOwnerStub = CollectionsKt.getOrNull(list2, typeParameter.getIndex());
            if (ktModifierListOwnerStub == null || (ktModifierListOwnerStub = ktModifierListOwnerStub.getTypeReference()) == null) continue;
            KtModifierListOwnerStub typeReference = ktModifierListOwnerStub;
            if (typeArgument == null) continue;
            WarningAwareUpperBoundChecker warningAwareUpperBoundChecker = (WarningAwareUpperBoundChecker)this.upperBoundChecker;
            TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(typeArgument);
            Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(typeArgument)");
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace, "c.trace");
            WarningAwareUpperBoundChecker.checkBounds$default(warningAwareUpperBoundChecker, (KtTypeReference)typeReference, typeArgument, typeParameter, typeSubstitutor2, bindingTrace, null, true, null, 160, null);
        }
    }

    private final TypeParameterDescriptor findTypeParameterWithWrongBoundsNullability(KotlinType expressionType, ResolutionContext<?> c, Function0<DataFlowValue> dataFlowValueForWholeExpression) {
        if (c.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitUsingNullableTypeParameterAgainstNotNullAnnotated)) {
            return null;
        }
        if (TypeUtils.noExpectedType(c.expectedType)) {
            return null;
        }
        Ref.ObjectRef<TypeParameterDescriptor> foundSubtypeTypeParameter = new Ref.ObjectRef<TypeParameterDescriptor>();
        TypeCheckerState typeState2 = new ClassicTypeCheckerState(c, dataFlowValueForWholeExpression, foundSubtypeTypeParameter){
            private boolean expectsTypeArgument;
            final /* synthetic */ ResolutionContext<?> $c;
            final /* synthetic */ Function0<DataFlowValue> $dataFlowValueForWholeExpression;
            final /* synthetic */ Ref.ObjectRef<TypeParameterDescriptor> $foundSubtypeTypeParameter;
            {
                this.$c = $c;
                this.$dataFlowValueForWholeExpression = $dataFlowValueForWholeExpression;
                this.$foundSubtypeTypeParameter = $foundSubtypeTypeParameter;
                super(true, false, null, null, null, 30, null);
            }

            public boolean customIsSubtypeOf(@NotNull KotlinTypeMarker subType, @NotNull KotlinTypeMarker superType2) {
                Intrinsics.checkNotNullParameter(subType, "subType");
                Intrinsics.checkNotNullParameter(superType2, "superType");
                if (JavaNullabilityChecker.Companion.isNullableTypeAgainstNotNullTypeParameter((KotlinType)subType, (KotlinType)superType2) && (this.expectsTypeArgument || this.$c.dataFlowInfo.getStableNullability(this.$dataFlowValueForWholeExpression.invoke()) != Nullability.NOT_NULL)) {
                    ClassifierDescriptor classifierDescriptor = ((KotlinType)subType).getConstructor().getDeclarationDescriptor();
                    this.$foundSubtypeTypeParameter.element = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
                    return false;
                }
                if (!this.expectsTypeArgument) {
                    this.expectsTypeArgument = true;
                }
                return true;
            }
        };
        KotlinTypeMarker kotlinTypeMarker = expressionType;
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkNotNullExpressionValue(kotlinType, "c.expectedType");
        AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeState2, kotlinTypeMarker, (KotlinTypeMarker)kotlinType, false, 8, null);
        return (TypeParameterDescriptor)foundSubtypeTypeParameter.element;
    }

    @Override
    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        Intrinsics.checkNotNullParameter(receiverParameter, "receiverParameter");
        Intrinsics.checkNotNullParameter(receiverArgument, "receiverArgument");
        Intrinsics.checkNotNullParameter(c, "c");
        Lazy<DataFlowValue> dataFlowValue$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<DataFlowValue>(c, receiverArgument){
            final /* synthetic */ CallResolutionContext<?> $c;
            final /* synthetic */ ReceiverValue $receiverArgument;
            {
                this.$c = $c;
                this.$receiverArgument = $receiverArgument;
                super(0);
            }

            @NotNull
            public final DataFlowValue invoke() {
                return this.$c.dataFlowValueFactory.createDataFlowValue(this.$receiverArgument, (ResolutionContext)this.$c);
            }
        });
        if (safeAccess) {
            ASTNode aSTNode = c.call.getCallOperationNode();
            PsiElement psiElement = aSTNode != null ? aSTNode.getPsi() : null;
            if (psiElement == null) {
                return;
            }
            PsiElement safeAccessElement = psiElement;
            KotlinType kotlinType = receiverArgument.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "receiverArgument.type");
            this.doIfNotNull(kotlinType, new Function0<DataFlowValue>(dataFlowValue$delegate){
                final /* synthetic */ Lazy<DataFlowValue> $dataFlowValue$delegate;
                {
                    this.$dataFlowValue$delegate = $dataFlowValue$delegate;
                    super(0);
                }

                @NotNull
                public final DataFlowValue invoke() {
                    return JavaNullabilityChecker.access$checkReceiver$lambda$2(this.$dataFlowValue$delegate);
                }
            }, (ResolutionContext)c, (Function0)new Function0<Unit>(c, safeAccessElement, receiverArgument){
                final /* synthetic */ CallResolutionContext<?> $c;
                final /* synthetic */ PsiElement $safeAccessElement;
                final /* synthetic */ ReceiverValue $receiverArgument;
                {
                    this.$c = $c;
                    this.$safeAccessElement = $safeAccessElement;
                    this.$receiverArgument = $receiverArgument;
                    super(0);
                }

                public final void invoke() {
                    this.$c.trace.report(Errors.UNNECESSARY_SAFE_CALL.on(this.$safeAccessElement, this.$receiverArgument.getType()));
                }
            });
            return;
        }
        KotlinType kotlinType = receiverArgument.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "receiverArgument.type");
        KotlinType kotlinType2 = receiverParameter.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType2, "receiverParameter.type");
        Function0 function0 = new Function0<DataFlowValue>(dataFlowValue$delegate){
            final /* synthetic */ Lazy<DataFlowValue> $dataFlowValue$delegate;
            {
                this.$dataFlowValue$delegate = $dataFlowValue$delegate;
                super(0);
            }

            @NotNull
            public final DataFlowValue invoke() {
                return JavaNullabilityChecker.access$checkReceiver$lambda$2(this.$dataFlowValue$delegate);
            }
        };
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "c.dataFlowInfo");
        this.doCheckType(kotlinType, kotlinType2, function0, dataFlowInfo, (Function2<? super KotlinType, ? super KotlinType, Unit>)new Function2<KotlinType, KotlinType, Unit>(receiverArgument, c){
            final /* synthetic */ ReceiverValue $receiverArgument;
            final /* synthetic */ CallResolutionContext<?> $c;
            {
                this.$receiverArgument = $receiverArgument;
                this.$c = $c;
                super(2);
            }

            public final void invoke(@NotNull KotlinType expectedType, @NotNull KotlinType actualType) {
                KtExpression receiverExpression;
                Intrinsics.checkNotNullParameter(expectedType, "expectedType");
                Intrinsics.checkNotNullParameter(actualType, "actualType");
                ReceiverValue receiverValue = this.$receiverArgument;
                ExpressionReceiver expressionReceiver = receiverValue instanceof ExpressionReceiver ? (ExpressionReceiver)receiverValue : null;
                KtExpression ktExpression = receiverExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
                if (receiverExpression != null) {
                    this.$c.trace.report(ErrorsJvm.RECEIVER_NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)receiverExpression), actualType));
                } else {
                    KtExpression ktExpression2 = this.$c.call.getCalleeExpression();
                    KtElement ktElement = ktExpression2 != null ? (KtElement)ktExpression2 : this.$c.call.getCallElement();
                    Intrinsics.checkNotNullExpressionValue(ktElement, "c.call.calleeExpression ?: c.call.callElement");
                    KtElement reportOn = ktElement;
                    this.$c.trace.report(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)reportOn), expectedType, actualType));
                }
            }
        });
    }

    private final void doCheckType(KotlinType expressionType, KotlinType expectedType, Function0<DataFlowValue> expressionTypeDataFlowValue, DataFlowInfo dataFlowInfo, Function2<? super KotlinType, ? super KotlinType, Unit> reportWarning) {
        if (TypeUtils.noExpectedType(expectedType)) {
            return;
        }
        KotlinType expressionType2 = this.exactedExpressionTypeByDataFlowNullability(expressionType, expressionTypeDataFlowValue, dataFlowInfo);
        boolean isEnhancedExpectedTypeSubtypeOfExpressionType = typeCheckerForEnhancedTypes.isSubtypeOf(expressionType2, expectedType);
        if (isEnhancedExpectedTypeSubtypeOfExpressionType) {
            return;
        }
        boolean isExpectedTypeSubtypeOfExpressionType = typeCheckerForBaseTypes.isSubtypeOf(expressionType2, expectedType);
        if (!isEnhancedExpectedTypeSubtypeOfExpressionType && isExpectedTypeSubtypeOfExpressionType) {
            reportWarning.invoke(TypeWithEnhancementKt.unwrapEnhancementDeeply(expectedType), TypeWithEnhancementKt.unwrapEnhancementDeeply(expressionType2));
        }
    }

    private final KotlinType exactedExpressionTypeByDataFlowNullability(KotlinType expressionType, Function0<DataFlowValue> expressionTypeDataFlowValue, DataFlowInfo dataFlowInfo) {
        boolean isNotNullByDataFlowInfo = dataFlowInfo.getStableNullability(expressionTypeDataFlowValue.invoke()) == Nullability.NOT_NULL;
        return KotlinTypeKt.isNullable(expressionType) && isNotNullByDataFlowInfo ? TypeUtilsKt.makeNotNullable(expressionType) : expressionType;
    }

    private final <T> T doIfNotNull(KotlinType type2, Function0<DataFlowValue> dataFlowValue2, ResolutionContext<?> c, Function0<? extends T> body2) {
        EnhancedNullabilityInfo enhancedNullabilityInfo = JavaNullabilityCheckerKt.mustNotBeNull(type2);
        return (enhancedNullabilityInfo != null ? enhancedNullabilityInfo.isFromJava() : false) && c.dataFlowInfo.getStableNullability(dataFlowValue2.invoke()).canBeNull() ? (T)body2.invoke() : null;
    }

    private static final DataFlowValue checkType$lambda$0(Lazy<DataFlowValue> $dataFlowValue$delegate) {
        Lazy<DataFlowValue> lazy = $dataFlowValue$delegate;
        return lazy.getValue();
    }

    private static final DataFlowValue checkReceiver$lambda$2(Lazy<DataFlowValue> $dataFlowValue$delegate) {
        Lazy<DataFlowValue> lazy = $dataFlowValue$delegate;
        return lazy.getValue();
    }

    public static final /* synthetic */ DataFlowValue access$checkType$lambda$0(Lazy $dataFlowValue$delegate) {
        return JavaNullabilityChecker.checkType$lambda$0($dataFlowValue$delegate);
    }

    public static final /* synthetic */ Object access$doIfNotNull(JavaNullabilityChecker $this, KotlinType type2, Function0 dataFlowValue2, ResolutionContext c, Function0 body2) {
        return $this.doIfNotNull(type2, dataFlowValue2, c, body2);
    }

    public static final /* synthetic */ DataFlowValue access$checkReceiver$lambda$2(Lazy $dataFlowValue$delegate) {
        return JavaNullabilityChecker.checkReceiver$lambda$2($dataFlowValue$delegate);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaNullabilityChecker$Companion;", "", "()V", "typeCheckerForBaseTypes", "Lorg/jetbrains/kotlin/types/checker/NewKotlinTypeCheckerImpl;", "getTypeCheckerForBaseTypes", "()Lorg/jetbrains/kotlin/types/checker/NewKotlinTypeCheckerImpl;", "typeCheckerForEnhancedTypes", "getTypeCheckerForEnhancedTypes", "isNullableTypeAgainstNotNullTypeParameter", "", "subType", "Lorg/jetbrains/kotlin/types/KotlinType;", "superType", "frontend.java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NewKotlinTypeCheckerImpl getTypeCheckerForEnhancedTypes() {
            return typeCheckerForEnhancedTypes;
        }

        @NotNull
        public final NewKotlinTypeCheckerImpl getTypeCheckerForBaseTypes() {
            return typeCheckerForBaseTypes;
        }

        public final boolean isNullableTypeAgainstNotNullTypeParameter(@NotNull KotlinType subType, @NotNull KotlinType superType2) {
            Intrinsics.checkNotNullParameter(subType, "subType");
            Intrinsics.checkNotNullParameter(superType2, "superType");
            if (!(superType2 instanceof NotNullTypeParameter) || subType instanceof NotNullTypeParameter) {
                return false;
            }
            return !AbstractNullabilityChecker.INSTANCE.isSubtypeOfAny(ClassicTypeCheckerStateKt.createClassicTypeCheckerState$default(true, false, null, null, null, 30, null), (KotlinTypeMarker)subType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

