/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMatcher;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.SmilesStereo;
import org.jmol.smiles.VTemp;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.SimpleEdge;
import org.jmol.util.SimpleNode;

public class SmilesGenerator {
    private Node[] atoms;
    private int ac;
    private BS bsSelected;
    private BS bsAromatic;
    private int flags;
    private int explicitHydrogen;
    private Lst<BS> ringSets;
    private VTemp vTemp = new VTemp();
    private int nPairs;
    private int nPairsMax;
    private BS bsBondsUp = new BS();
    private BS bsBondsDn = new BS();
    private BS bsToDo;
    private BS bsIgnoreHydrogen = new BS();
    private SimpleNode prevAtom;
    private SimpleNode[] prevSp2Atoms;
    private SimpleNode[] alleneStereo;
    private Map<String, Object[]> htRingsSequence = new Hashtable<String, Object[]>();
    private Map<String, Object[]> htRings = new Hashtable<String, Object[]>();
    private BS bsRingKeys = new BS();
    private BS bsIncludingH;
    private boolean topologyOnly;
    boolean getAromatic = true;
    private boolean addAtomComment;
    private boolean noBioComment;
    private boolean aromaticDouble;
    private boolean noStereo;
    private boolean openSMILES;
    public P3 polySmilesCenter;
    private SmilesStereo smilesStereo;
    private boolean isPolyhedral;
    private Lst<BS> aromaticRings;
    private SmilesMatcher sm;
    private int iHypervalent;
    private boolean is2D;
    private boolean haveSmilesAtoms;
    private int ptAtom;
    private int ptSp2Atom0;
    private SimpleNode[] atemp;
    private int chainCheck;

    String getSmiles(SmilesMatcher sm, Node[] atoms, int ac, BS bsSelected, String comment, int flags) throws InvalidSmilesException {
        int ipt = bsSelected.nextSetBit(0);
        if (ipt < 0) {
            return "";
        }
        this.haveSmilesAtoms = atoms[ipt] instanceof SmilesAtom && ((SmilesAtom)atoms[ipt]).definesStereo();
        this.sm = sm;
        this.flags = flags;
        this.atoms = atoms;
        this.ac = ac;
        bsSelected = BSUtil.copy(bsSelected);
        this.bsSelected = BS.copy(bsSelected);
        this.flags = flags = SmilesSearch.addFlags(flags, comment == null ? "" : comment.toUpperCase());
        if ((flags & 0x100000) == 0x100000) {
            return this.getBioSmiles(bsSelected, comment, flags);
        }
        this.openSMILES = (flags & 5) == 5;
        this.addAtomComment = (flags & 0x20000) == 131072;
        boolean bl = this.aromaticDouble = (flags & 0x200) == 512;
        int n = (flags & 0x2000) == 8192 ? 8192 : (this.explicitHydrogen = (flags & 0x1000) == 4096 ? 4096 : 0);
        if (this.explicitHydrogen == 8192) {
            BS bsHa = new BS();
            int i = bsSelected.nextSetBit(0);
            while (i >= 0) {
                Node a = atoms[i];
                if (a.getCovalentHydrogenCount() == 3 && a.getCovalentBondCount() == 4) {
                    boolean doIgnore = true;
                    bsHa.clearAll();
                    int j = a.getBondCount();
                    while (--j >= 0) {
                        int aj = a.getBondedAtomIndex(j);
                        if (atoms[aj].getElementNumber() == 1) {
                            boolean bl2 = doIgnore = atoms[aj].getElementNumber() == 1;
                            if (!doIgnore) break;
                            bsHa.set(aj);
                        }
                        if (!doIgnore) continue;
                        this.bsIgnoreHydrogen.set(i);
                        bsSelected.andNot(bsHa);
                    }
                }
                i = bsSelected.nextSetBit(i + 1);
            }
        }
        this.topologyOnly = (flags & 0x4000) == 16384;
        this.getAromatic = (flags & 0x10) != 16;
        this.noStereo = (flags & 0x20) == 32;
        this.isPolyhedral = (flags & 0x10000) == 65536;
        this.is2D = (flags & 0x8000000) == 0x8000000;
        return this.getSmilesComponent(atoms[ipt], bsSelected, true, false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBioSmiles(BS bsSelected, String comment, int flags) throws InvalidSmilesException {
        String s;
        SB sb;
        boolean noBioComments;
        boolean allowUnmatchedRings;
        block26: {
            this.addAtomComment = (flags & 0x20000) == 131072;
            allowUnmatchedRings = (flags & 0x300000) == 0x300000;
            noBioComments = (flags & 0x2100000) == 0x2100000;
            boolean crosslinkCovalent = (flags & 0x500000) == 0x500000;
            boolean crosslinkHBonds = (flags & 0x900000) == 0x900000;
            boolean addCrosslinks = crosslinkCovalent || crosslinkHBonds;
            sb = new SB();
            BS bs = bsSelected;
            if (comment != null && !this.noBioComment) {
                sb.append("//* Jmol bioSMILES ").append(comment.replace('*', '_')).append(" *//");
            }
            String end = this.noBioComment ? "" : "\n";
            BS bsIgnore = new BS();
            String lastComponent = null;
            String groupString = "";
            Lst<Integer> vLinks = new Lst<Integer>();
            try {
                int len = 0;
                int i = bs.nextSetBit(0);
                while (i >= 0) {
                    block25: {
                        boolean unknown;
                        String bioStructureName;
                        String ch;
                        Node a;
                        block27: {
                            block28: {
                                a = this.atoms[i];
                                ch = a.getGroup1('?');
                                bioStructureName = a.getBioStructureTypeName();
                                boolean bl = unknown = ch == ch.toLowerCase();
                                if (end == null) break block27;
                                if (sb.length() > 0) {
                                    sb.append(end);
                                }
                                end = null;
                                len = 0;
                                if (bioStructureName.length() > 0) break block28;
                                s = this.getSmilesComponent(a, bs, false, true, true);
                                if (s.equals(lastComponent)) {
                                    end = "";
                                    break block25;
                                } else {
                                    String key;
                                    lastComponent = s;
                                    String groupName = a.getGroup3(true);
                                    if (noBioComments) {
                                        key = "/" + s + "/";
                                    } else {
                                        if (groupName != null) {
                                            s = "//* " + groupName + " *//" + s;
                                        }
                                        key = s + "//";
                                    }
                                    if (groupString.indexOf(key) >= 0) {
                                        end = "";
                                        break block25;
                                    } else {
                                        groupString = groupString + key;
                                        sb.append(s);
                                        end = noBioComments ? "." : ".\n";
                                    }
                                }
                                break block25;
                            }
                            int id = a.getChainID();
                            if (id != 0 && !noBioComments) {
                                s = "//* chain " + a.getChainIDStr() + " " + bioStructureName + " " + a.getResno() + " *// ";
                                len = s.length();
                                sb.append(s);
                            }
                            ++len;
                            sb.append("~").appendC(bioStructureName.toLowerCase().charAt(0)).append("~");
                        }
                        if (len >= 75 && !noBioComments) {
                            sb.append("\n  ");
                            len = 2;
                        }
                        if (this.addAtomComment) {
                            sb.append("\n//* [" + a.getGroup3(false) + "#" + a.getResno() + "] *//\t");
                        }
                        if (unknown) {
                            this.addBracketedBioName(sb, a, bioStructureName.length() > 0 ? ".0" : null, false);
                        } else {
                            sb.append(ch);
                        }
                        ++len;
                        if (addCrosslinks) {
                            a.getCrossLinkVector(vLinks, crosslinkCovalent, crosslinkHBonds);
                            for (int j = 0; j < vLinks.size(); len += 1 + s.length(), j += 3) {
                                sb.append(":");
                                s = this.getRingCache((Integer)vLinks.get(j), (Integer)vLinks.get(j + 1), this.htRingsSequence);
                                sb.append(s);
                            }
                            vLinks.clear();
                        }
                        a.getGroupBits(bsIgnore);
                        bs.andNot(bsIgnore);
                        int i2 = a.getOffsetResidueAtom("\u0000", 1);
                        if (i2 < 0 || !bs.get(i2)) {
                            if (!noBioComments) {
                                sb.append(" //* ").appendI(a.getResno()).append(" *//");
                            }
                            if (i2 < 0 && (i2 = bs.nextSetBit(i + 1)) < 0) break block26;
                            if (len > 0) {
                                end = noBioComments ? "." : ".\n";
                            }
                        }
                        i = i2 - 1;
                    }
                    i = bs.nextSetBit(i + 1);
                }
            }
            catch (Exception e) {
                throw new InvalidSmilesException("//* error: " + e.getMessage() + " *//");
            }
        }
        if (!allowUnmatchedRings && !this.htRingsSequence.isEmpty()) {
            this.dumpRingKeys(sb, this.htRingsSequence);
            throw new InvalidSmilesException("//* ?ring error? *//");
        }
        s = sb.toString();
        if (s.endsWith(".\n")) {
            return s.substring(0, s.length() - 2);
        }
        if (!noBioComments) return s;
        if (!s.endsWith(".")) return s;
        return s.substring(0, s.length() - 1);
    }

    private void addBracketedBioName(SB sb, Node atom, String atomName, boolean addComment) {
        sb.append("[");
        if (atomName != null) {
            String chain = atom.getChainIDStr();
            sb.append(atom.getGroup3(false));
            if (!atomName.equals(".0")) {
                sb.append(atomName).append("#").appendI(atom.getElementNumber());
            }
            if (addComment) {
                sb.append("//* ").appendI(atom.getResno());
                if (chain.length() > 0) {
                    sb.append(":").append(chain);
                }
                sb.append(" *//");
            }
        } else {
            sb.append(Elements.elementNameFromNumber(atom.getElementNumber()));
        }
        sb.append("]");
    }

    private String getSmilesComponent(Node atom, BS bs, boolean allowBioResidues, boolean allowConnectionsToOutsideWorld, boolean forceBrackets) throws InvalidSmilesException {
        atom = this.checkFirstAtom(atom);
        this.bsSelected = JmolMolecule.getBranchBitSet(this.atoms, atom.getIndex(), BSUtil.copy(bs), null, -1, true, allowBioResidues);
        bs.andNot(this.bsSelected);
        this.iHypervalent = -1;
        int i = this.bsSelected.nextSetBit(0);
        while (i >= 0 && this.iHypervalent < 0) {
            if (this.atoms[i].getCovalentBondCount() > 4 || this.isPolyhedral) {
                this.iHypervalent = i;
            }
            i = this.bsSelected.nextSetBit(i + 1);
        }
        this.bsIncludingH = BSUtil.copy(this.bsSelected);
        if (this.explicitHydrogen == 0) {
            int j = this.bsSelected.nextSetBit(0);
            while (j >= 0) {
                Node a = this.atoms[j];
                if (a.getAtomicAndIsotopeNumber() == 1 && a.getBondCount() > 0 && a.getBondedAtomIndex(0) != this.iHypervalent && !this.isExplicitOnly(this.atoms[a.getBondedAtomIndex(0)])) {
                    this.bsSelected.clear(j);
                }
                j = this.bsSelected.nextSetBit(j + 1);
            }
        }
        this.bsAromatic = new BS();
        if (!this.topologyOnly && this.bsSelected.cardinality() > 2) {
            this.generateRingData();
            this.setBondDirections();
        }
        this.bsToDo = BSUtil.copy(this.bsSelected);
        SB sb = new SB();
        int i2 = this.bsToDo.nextSetBit(0);
        while (i2 >= 0) {
            if (this.atoms[i2].getCovalentBondCount() > 4 || this.isPolyhedral) {
                if (atom == null) {
                    sb.append(".");
                }
                this.getSmilesAt(sb, this.atoms[i2], allowConnectionsToOutsideWorld, false, forceBrackets);
                atom = null;
            }
            i2 = this.bsToDo.nextSetBit(i2 + 1);
        }
        if (atom != null) {
            while ((atom = this.getSmilesAt(sb, atom, allowConnectionsToOutsideWorld, true, forceBrackets)) != null) {
            }
        }
        while (this.bsToDo.cardinality() > 0 || !this.htRings.isEmpty()) {
            Iterator<Object[]> e = this.htRings.values().iterator();
            if (e.hasNext()) {
                atom = this.atoms[(Integer)e.next()[1]];
                if (!this.bsToDo.get(atom.getIndex())) {
                    break;
                }
            } else {
                atom = this.atoms[this.bsToDo.nextSetBit(0)];
            }
            sb.append(".");
            this.alleneStereo = null;
            this.prevSp2Atoms = null;
            this.prevAtom = null;
            while ((atom = this.getSmilesAt(sb, atom, allowConnectionsToOutsideWorld, true, forceBrackets)) != null) {
            }
        }
        if (!this.htRings.isEmpty()) {
            this.dumpRingKeys(sb, this.htRings);
            throw new InvalidSmilesException("//* ?ring error? *//\n" + sb);
        }
        String s = sb.toString();
        if (s.indexOf("^-") >= 0) {
            String s0 = s;
            try {
                int pt;
                String keys = this.sm.getAtropisomerKeys(s, this.atoms, this.ac, this.bsSelected, this.bsAromatic, this.flags);
                for (int i3 = 1; i3 < keys.length() && (pt = s.indexOf("^-")) >= 0; i3 += 3) {
                    s = s.substring(0, pt + 1) + keys.substring(i3, i3 + 3).trim() + s.substring(pt + 1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                s = s0;
            }
        }
        return s;
    }

    private Node checkFirstAtom(Node atom) {
        Edge[] bonds;
        if (this.explicitHydrogen == 0 && atom.getAtomicAndIsotopeNumber() == 1 && atom.getEdges().length > 0) {
            atom = this.atoms[atom.getBondedAtomIndex(0)];
        }
        Node a = atom;
        Node aprev = null;
        while (a.getCovalentBondCount() == 2 && (bonds = a.getEdges())[0].getBondType() == 2 && bonds[1].getBondType() == 2) {
            Node anext = (Node)bonds[0].getOtherNode(a);
            if (anext == aprev) {
                anext = (Node)bonds[1].getOtherNode(a);
            }
            aprev = a;
            a = anext;
        }
        return a == null ? atom : a;
    }

    private void generateRingData() throws InvalidSmilesException {
        SmilesSearch search = SmilesParser.newSearch("[r500]", true, true);
        search.targetAtoms = this.atoms;
        search.setSelected(this.bsSelected);
        search.setFlags(this.flags);
        search.targetAtomCount = this.ac;
        search.ringDataMax = 7;
        search.flags = this.flags;
        Lst<type>[] vRings = AU.createArrayOfArrayList(4);
        search.setRingData(null, vRings, true);
        this.bsAromatic = search.bsAromatic;
        this.ringSets = search.ringSets;
        this.aromaticRings = vRings[3];
    }

    private char getBondStereochemistry(Edge bond, SimpleNode atomFrom) {
        boolean isFirst;
        if (bond == null) {
            return '\u0000';
        }
        int i = bond.index;
        boolean bl = isFirst = atomFrom == null || bond.getAtomIndex1() == atomFrom.getIndex();
        return (char)(this.bsBondsUp.get(i) ? (isFirst ? 47 : 92) : (this.bsBondsDn.get(i) ? (isFirst ? 92 : 47) : 0));
    }

    private void setBondDirections() {
        BS bsDone = new BS();
        Edge[][] edges = new Edge[2][3];
        int i = this.bsSelected.nextSetBit(0);
        while (i >= 0) {
            Node atom1 = this.atoms[i];
            Edge[] bonds = atom1.getEdges();
            for (int k = 0; k < bonds.length; ++k) {
                SimpleNode atom2;
                Edge bond = bonds[k];
                int index = bond.index;
                if (bsDone.get(index) || bond.getCovalentOrder() != 2 || SmilesSearch.isRingBond(this.ringSets, null, i, (atom2 = bond.getOtherNode(atom1)).getIndex())) continue;
                bsDone.set(index);
                int nCumulene = 0;
                SimpleNode a10 = atom1;
                while (atom2.getCovalentBondCount() == 2 && atom2.getValence() == 4) {
                    Edge[] e2;
                    Edge e = e2[(e2 = (Edge[])atom2.getEdges())[0].getOtherNode(atom2) == a10 ? 1 : 0];
                    bsDone.set(e.index);
                    a10 = atom2;
                    atom2 = e.getOtherNode(atom2);
                    ++nCumulene;
                }
                if (nCumulene % 2 == 1) continue;
                Edge b0 = null;
                SimpleNode a0 = null;
                int i0 = 0;
                SimpleNode[] atom12 = new SimpleNode[]{atom1, atom2};
                int edgeCount = 1;
                for (int j = 0; j < 2 && edgeCount > 0 && edgeCount < 3; ++j) {
                    edgeCount = 0;
                    SimpleNode atomA = atom12[j];
                    Edge[] bb = ((Node)atomA).getEdges();
                    boolean explicitH = this.explicitHydrogen > 0 || this.isExplicitOnly(atomA);
                    for (int b = 0; b < bb.length; ++b) {
                        SimpleNode other;
                        if (bb[b].getCovalentOrder() != 1 || !explicitH && (other = bb[b].getOtherNode(atomA)).getElementNumber() == 1 && other.getIsotopeNumber() == 0) continue;
                        edges[j][edgeCount++] = bb[b];
                        if (this.getBondStereochemistry(bb[b], atomA) == '\u0000') continue;
                        b0 = bb[b];
                        i0 = j;
                    }
                }
                if (edgeCount == 3 || edgeCount == 0) continue;
                if (b0 == null) {
                    i0 = 0;
                    b0 = edges[i0][0];
                    this.bsBondsUp.set(b0.index);
                }
                SimpleNode aA = atom12[i0];
                char c0 = this.getBondStereochemistry(b0, aA);
                a0 = b0.getOtherNode(aA);
                if (a0 == null) continue;
                for (int j = 0; j < 2; ++j) {
                    SimpleNode aB = atom12[j];
                    for (int jj = 0; jj < 2; ++jj) {
                        boolean isOpposite;
                        Edge b1 = edges[j][jj];
                        if (b1 == null || b1 == b0) continue;
                        int bi = b1.index;
                        SimpleNode a1 = b1.getOtherNode(aB);
                        if (a1 == null) continue;
                        char c1 = this.getBondStereochemistry(b1, aB);
                        if (this.haveSmilesAtoms) {
                            Boolean isop = ((SmilesAtom)a0).isStereoOpposite(a1.getIndex(), aA.getIndex(), aB.getIndex());
                            if (isop == null) {
                                if (!Logger.debugging) continue;
                                Logger.debug("SmilesGenerator could not find stereo for " + a0 + "/" + a1);
                                continue;
                            }
                            isOpposite = isop;
                        } else {
                            isOpposite = SmilesStereo.isDiaxial(aA, aB, a0, a1, this.vTemp, 0.0f);
                        }
                        if (c1 == '\u0000' || c1 != c0 == isOpposite) {
                            boolean isUp = c0 == '\\' && isOpposite || c0 == '/' && !isOpposite;
                            if (isUp == (b1.getAtomIndex1() != a1.getIndex())) {
                                this.bsBondsUp.set(bi);
                            } else {
                                this.bsBondsDn.set(bi);
                            }
                        } else {
                            this.bsBondsUp.clear(bi);
                            this.bsBondsDn.clear(bi);
                            Logger.error("BOND STEREOCHEMISTRY PARITY ERROR-stereochemistry for bond " + bi + "");
                        }
                        if (!Logger.debugging) continue;
                        Logger.debug(this.getBondStereochemistry(b0, aA) + " " + a0.getIndex() + " " + a1.getIndex() + " " + this.getBondStereochemistry(b1, aB));
                    }
                }
            }
            i = this.bsSelected.nextSetBit(i + 1);
        }
    }

    private Node getSmilesAt(SB sb, SimpleNode atom, boolean allowConnectionsToOutsideWorld, boolean allowBranches, boolean forceBrackets) {
        int nSp2Atoms;
        int stereoFlag;
        int atomIndex = atom.getIndex();
        if (!this.bsToDo.get(atomIndex)) {
            return null;
        }
        ++this.ptAtom;
        this.bsToDo.clear(atomIndex);
        boolean includeHs = atomIndex == this.iHypervalent || this.explicitHydrogen != 0 && !this.bsIgnoreHydrogen.get(atomIndex);
        boolean explicitHs = this.isExplicitOnly(atom);
        boolean isExtension = !this.bsSelected.get(atomIndex);
        int prevIndex = this.prevAtom == null ? -1 : this.prevAtom.getIndex();
        boolean isAromatic = this.bsAromatic.get(atomIndex);
        SimpleNode[] sp2Atoms = this.prevSp2Atoms;
        boolean havePreviousSp2Atoms = sp2Atoms != null;
        int atomicNumber = atom.getElementNumber();
        int nH = 0;
        SimpleNode[] prevStereo = this.alleneStereo;
        this.alleneStereo = null;
        Lst<Edge> v = new Lst<Edge>();
        SimpleEdge bondNext = null;
        Edge bondPrev = null;
        Edge[] bonds = (Edge[])atom.getEdges();
        if (this.polySmilesCenter != null) {
            allowBranches = false;
            this.sortPolyBonds(atom, this.prevAtom, this.polySmilesCenter);
        }
        SimpleNode aH = null;
        int n = stereoFlag = isAromatic ? 10 : 0;
        if (Logger.debugging) {
            Logger.debug(sb.toString());
        }
        if (bonds != null) {
            int i = bonds.length;
            while (--i >= 0) {
                boolean isH;
                Edge bond = bonds[i];
                if (!bond.isCovalent()) continue;
                SimpleNode atom1 = bonds[i].getOtherNode(atom);
                int index1 = atom1.getIndex();
                if (index1 == prevIndex) {
                    bondPrev = bonds[i];
                    continue;
                }
                boolean bl = isH = !includeHs && !explicitHs && atom1.getElementNumber() == 1 && atom1.getIsotopeNumber() <= 0;
                if (!this.bsIncludingH.get(index1)) {
                    if (isH || !allowConnectionsToOutsideWorld || !this.bsSelected.get(atomIndex)) continue;
                    this.bsToDo.set(index1);
                }
                if (isH) {
                    aH = atom1;
                    if (++nH <= 1) continue;
                    stereoFlag = 10;
                    continue;
                }
                v.addLast(bonds[i]);
            }
        }
        if (nH > 1) {
            sp2Atoms = null;
        }
        int n2 = nSp2Atoms = sp2Atoms != null ? 2 : 0;
        if (sp2Atoms == null && !isAromatic && nH <= 1) {
            sp2Atoms = new Node[5];
        }
        String strPrev = null;
        if (bondPrev != null) {
            strPrev = this.getBondOrder(bondPrev, atomIndex, prevIndex, isAromatic);
            if (sp2Atoms != null && !havePreviousSp2Atoms) {
                sp2Atoms[nSp2Atoms++] = this.prevAtom;
            }
        }
        if (sp2Atoms != null && !havePreviousSp2Atoms) {
            this.ptSp2Atom0 = this.ptAtom;
        }
        if (sp2Atoms != null && nH == 1) {
            sp2Atoms[nSp2Atoms++] = aH;
        }
        int nMax = 0;
        BS bsBranches = new BS();
        int nBonds = v.size();
        if (allowBranches) {
            for (int i = 0; i < nBonds; ++i) {
                Edge bond = (Edge)v.get(i);
                SimpleNode a = bond.getOtherNode(atom);
                int n3 = a.getCovalentBondCount() - (includeHs || this.isExplicitOnly(a) ? 0 : ((Node)a).getCovalentHydrogenCount());
                int order = bond.getCovalentOrder();
                if (n3 == 1 && (bondNext != null || i < nBonds - 1)) {
                    bsBranches.set(bond.index);
                    continue;
                }
                if (order <= 1 && n3 <= nMax || this.htRings.containsKey(SmilesGenerator.getRingKey(a.getIndex(), atomIndex))) continue;
                nMax = order > 1 ? 1000 + order : n3;
                bondNext = bond;
            }
        }
        Node atomNext = bondNext == null ? null : (Node)bondNext.getOtherNode(atom);
        int orderNext = bondNext == null ? 0 : ((Edge)bondNext).getCovalentOrder();
        SimpleNode[] stereo = new Node[7];
        if (stereoFlag < 7 && bondPrev != null) {
            if (havePreviousSp2Atoms && bondPrev.getCovalentOrder() == 2 && orderNext == 2 && sp2Atoms[1] != null) {
                stereo[stereoFlag++] = sp2Atoms[0];
                stereo[stereoFlag++] = sp2Atoms[1];
            } else {
                stereo[stereoFlag++] = this.prevAtom;
            }
        }
        if (stereoFlag < 7 && nH == 1) {
            stereo[stereoFlag++] = aH;
        }
        boolean deferStereo = false;
        char chBond = this.getBondStereochemistry(bondPrev, this.prevAtom);
        if (strPrev != null || chBond != '\u0000') {
            if (chBond != '\u0000') {
                strPrev = "" + chBond;
            }
            sb.append(strPrev);
        }
        int stereoFlag0 = stereoFlag;
        int nSp2Atoms0 = nSp2Atoms;
        SB sbBranches = new SB();
        Lst<String> vBranches = new Lst<String>();
        for (int i = 0; i < v.size(); ++i) {
            Edge bond = (Edge)v.get(i);
            if (!bsBranches.get(bond.index)) continue;
            SimpleNode a = bond.getOtherNode(atom);
            SB s2 = new SB();
            this.prevAtom = atom;
            this.alleneStereo = null;
            this.prevSp2Atoms = null;
            SimpleEdge bond0t = bondNext;
            int ptSp2Atom0t = this.ptSp2Atom0;
            int ptAtomt = this.ptAtom;
            this.getSmilesAt(s2, a, allowConnectionsToOutsideWorld, allowBranches, forceBrackets);
            bondNext = bond0t;
            this.ptAtom = ptAtomt;
            this.ptSp2Atom0 = ptSp2Atom0t;
            String branch = s2.toString();
            v.removeItemAt(i--);
            if (bondNext == null) {
                vBranches.addLast(branch);
            } else {
                sbBranches.append("(").append(branch).append(")");
            }
            if (stereoFlag < 7) {
                stereo[stereoFlag++] = a;
            }
            if (sp2Atoms == null || nSp2Atoms >= 5) continue;
            sp2Atoms[nSp2Atoms++] = a;
        }
        SB sbRings = new SB();
        int stereoFlag1 = stereoFlag;
        int nSp2Atoms1 = nSp2Atoms;
        String atat = null;
        if (!(allowBranches || this.noStereo || this.polySmilesCenter != null || v.size() != 5 && v.size() != 6)) {
            atat = this.sortInorganic(atom, v, this.vTemp);
        }
        for (int i = 0; i < v.size(); ++i) {
            Edge bond = (Edge)v.get(i);
            if (bond == bondNext) continue;
            SimpleNode a = bond.getOtherNode(atom);
            strPrev = this.getBondOrder(bond, atomIndex, a.getIndex(), isAromatic);
            chBond = this.getBondStereochemistry(bond, atom);
            if (!deferStereo && chBond != '\u0000') {
                strPrev = "" + chBond;
            }
            sbRings.append(strPrev);
            sbRings.append(this.getRingCache(atomIndex, a.getIndex(), this.htRings));
            if (stereoFlag < 7) {
                stereo[stereoFlag++] = a;
            }
            if (sp2Atoms == null || nSp2Atoms >= 5) continue;
            sp2Atoms[nSp2Atoms++] = a;
        }
        if (stereoFlag0 != stereoFlag1 && stereoFlag1 != stereoFlag) {
            this.swapArray(stereo, stereoFlag0, stereoFlag1, stereoFlag);
        }
        if (nSp2Atoms0 != nSp2Atoms1 && nSp2Atoms1 != nSp2Atoms) {
            this.swapArray(sp2Atoms, nSp2Atoms0, nSp2Atoms1, nSp2Atoms);
        }
        if (havePreviousSp2Atoms && stereoFlag == 2 && orderNext == 2) {
            boolean lastIsN;
            int nc = this.ptAtom - this.ptSp2Atom0;
            int nb = atomNext.getCovalentBondCount();
            boolean bl = lastIsN = atomNext.getElementNumber() == 7;
            if (nc % 2 == 0) {
                stereoFlag = 8;
            } else if (nb == 3 || nb == 2 && lastIsN) {
                bonds = atomNext.getEdges();
                for (int k = 0; k < bonds.length; ++k) {
                    int index = atomNext.getBondedAtomIndex(k);
                    if (!bonds[k].isCovalent() || index == atomIndex) continue;
                    stereo[stereoFlag++] = this.atoms[index];
                }
                if (nb == 2) {
                    stereo[stereoFlag++] = atomNext;
                }
                if (stereoFlag == 4) {
                    this.alleneStereo = stereo;
                    if (((Node)stereo[3]).getAtomicAndIsotopeNumber() == 1) {
                        SimpleNode n4 = stereo[3];
                        stereo[3] = stereo[2];
                        stereo[2] = n4;
                    }
                }
            }
            nSp2Atoms = 0;
        } else if (atomNext != null && stereoFlag < 7) {
            stereo[stereoFlag++] = atomNext;
        }
        if (prevStereo != null) {
            int ptat;
            if (prevStereo[3] != stereo[2] && (ptat = sb.lastIndexOf("@]=")) > 0) {
                String trail = sb.substring(ptat);
                sb.setLength(sb.charAt(ptat - 1) == '@' ? ptat - 1 : ptat + 1);
                sb.append(trail);
            }
            prevStereo = null;
        }
        if (this.haveSmilesAtoms && atat == null && stereoFlag == 4) {
            atat = ((SmilesAtom)atom).getStereoAtAt(stereo);
        }
        int charge = atom.getFormalCharge();
        int isotope = atom.getIsotopeNumber();
        int valence = atom.getValence();
        float osclass = this.openSMILES ? ((Node)atom).getFloatProperty("property_atomclass") : Float.NaN;
        String atomName = atom.getAtomName();
        String groupType = ((Node)atom).getBioStructureTypeName();
        if (this.addAtomComment) {
            sb.append("\n//* " + atom.toString() + " *//\t");
        }
        if (this.topologyOnly) {
            sb.append("*");
        } else if (isExtension && groupType.length() != 0 && atomName.length() != 0) {
            this.addBracketedBioName(sb, (Node)atom, "." + atomName, false);
        } else {
            sb.append(SmilesAtom.getAtomLabel(atomicNumber, isotope, forceBrackets ? -1 : valence, charge, osclass, nH, isAromatic, (String)(atat != null ? atat : (this.noStereo ? null : this.checkStereoPairs(atom, this.alleneStereo == null ? atomIndex : -1, stereo, stereoFlag, prevIndex == -1))), this.is2D));
        }
        sb.appendSB(sbRings);
        if (bondNext == null) {
            int n5 = vBranches.size() - 1;
            if (n5 >= 0) {
                for (int i = 0; i < n5; ++i) {
                    sb.append("(").append((String)vBranches.get(i)).append(")");
                }
                sb.append((String)vBranches.get(n5));
            }
            return null;
        }
        sb.appendSB(sbBranches);
        if (sp2Atoms != null && orderNext == 2 && (nSp2Atoms == 1 || nSp2Atoms == 2)) {
            if (sp2Atoms[0] == null) {
                sp2Atoms[0] = atom;
            }
            if (sp2Atoms[1] == null) {
                sp2Atoms[1] = atom;
            }
        } else {
            sp2Atoms = null;
            nSp2Atoms = 0;
        }
        this.prevSp2Atoms = sp2Atoms;
        this.prevAtom = atom;
        return atomNext;
    }

    private boolean isExplicitOnly(SimpleNode atom) {
        return atom.getElementNumber() == 7 || atom.getElementNumber() == 6 && atom.getIsotopeNumber() == 17;
    }

    private void swapArray(SimpleNode[] a, int i0, int i1, int i2) {
        int n = i1 - i0;
        if (this.atemp == null || this.atemp.length < n) {
            this.atemp = new Node[n];
        }
        int p = n;
        int i = i1;
        while (p > 0) {
            this.atemp[--p] = a[--i];
        }
        for (int i3 = i1; i3 < i2; ++i3) {
            a[i3 - n] = a[i3];
        }
        p = n;
        i = i2;
        while (p > 0) {
            a[--i] = this.atemp[--p];
        }
    }

    private String getBondOrder(Edge bondPrev, int atomIndex, int prevIndex, boolean isAromatic) {
        if (this.topologyOnly) {
            return "";
        }
        if ((bondPrev.order & 0x10001) == 65537) {
            return "^-";
        }
        int border = bondPrev.getCovalentOrder();
        return !isAromatic || !this.bsAromatic.get(prevIndex) ? SmilesBond.getBondOrderString(border) : (border == 1 && !this.isSameAromaticRing(atomIndex, prevIndex) ? "-" : (this.aromaticDouble && (border == 2 || border == 514) ? "=" : ""));
    }

    private boolean isSameAromaticRing(int a1, int a2) {
        int i = this.aromaticRings.size();
        while (--i >= 0) {
            BS bs = (BS)this.aromaticRings.get(i);
            if (!bs.get(a1) || !bs.get(a2)) continue;
            return true;
        }
        return false;
    }

    void sortPolyBonds(SimpleNode atom, SimpleNode refAtom, P3 center) {
        if (this.smilesStereo == null) {
            try {
                this.smilesStereo = SmilesStereo.newStereo(null);
            }
            catch (InvalidSmilesException invalidSmilesException) {
                // empty catch block
            }
        }
        this.smilesStereo.sortPolyBondsByStereo(atom, refAtom, center, atom.getEdges(), this.vTemp.vA);
    }

    private String sortInorganic(SimpleNode atom, Lst<Edge> v, VTemp vTemp) {
        Edge bond1;
        int atomIndex = atom.getIndex();
        int n = v.size();
        Lst<Edge[]> axialPairs = new Lst<Edge[]>();
        Lst<Edge> bonds = new Lst<Edge>();
        SimpleNode a01 = null;
        SimpleNode a02 = null;
        BS bsDone = new BS();
        Edge[] pair0 = null;
        SimpleNode[] stereo = new Node[6];
        boolean isOK = true;
        String s = "";
        int naxial = 0;
        for (int i = 0; i < n; ++i) {
            bond1 = (Edge)v.get(i);
            SimpleNode a1 = bond1.getOtherNode(atom);
            stereo[0] = a1;
            if (i == 0) {
                s = this.addStereoCheck(0, atomIndex, a1, "", null);
            } else if (isOK && this.addStereoCheck(0, atomIndex, a1, s, null) != null) {
                isOK = false;
            }
            if (bsDone.get(i)) continue;
            bsDone.set(i);
            boolean isAxial = false;
            for (int j = i + 1; j < n; ++j) {
                Edge bond2;
                SimpleNode a2;
                if (bsDone.get(j) || !SmilesStereo.isDiaxial(atom, atom, a1, a2 = (bond2 = (Edge)v.get(j)).getOtherNode(atom), vTemp, -0.95f)) continue;
                switch (++naxial) {
                    case 1: {
                        a01 = a1;
                        break;
                    }
                    case 2: {
                        a02 = a1;
                        break;
                    }
                    case 3: {
                        if (SmilesStereo.getHandedness(a02, a01, a1, atom, vTemp) != 2) break;
                        Edge b = bond1;
                        bond1 = bond2;
                        bond2 = b;
                    }
                }
                axialPairs.addLast(new Edge[]{bond1, bond2});
                isAxial = true;
                bsDone.set(j);
                break;
            }
            if (isAxial) continue;
            bonds.addLast(bond1);
        }
        int npAxial = axialPairs.size();
        if (isOK || n == 6 && npAxial != 3 || n == 5 && npAxial == 0) {
            return "";
        }
        pair0 = (Edge[])axialPairs.get(0);
        bond1 = pair0[0];
        stereo[0] = bond1.getOtherNode(atom);
        v.clear();
        v.addLast(bond1);
        if (npAxial > 1) {
            bonds.addLast(((Edge[])axialPairs.get(1))[0]);
        }
        if (npAxial == 3) {
            bonds.addLast(((Edge[])axialPairs.get(2))[0]);
        }
        if (npAxial > 1) {
            bonds.addLast(((Edge[])axialPairs.get(1))[1]);
        }
        if (npAxial == 3) {
            bonds.addLast(((Edge[])axialPairs.get(2))[1]);
        }
        for (int i = 0; i < bonds.size(); ++i) {
            bond1 = (Edge)bonds.get(i);
            v.addLast(bond1);
            stereo[i + 1] = bond1.getOtherNode(atom);
        }
        v.addLast(pair0[1]);
        stereo[n - 1] = pair0[1].getOtherNode(atom);
        return SmilesStereo.getStereoFlag(atom, stereo, n, vTemp, this.is2D);
    }

    private String checkStereoPairs(SimpleNode atom, int atomIndex, SimpleNode[] stereo, int stereoFlag, boolean isFirst) {
        if (stereoFlag == 10 || stereoFlag < (this.is2D ? 3 : 4)) {
            return "";
        }
        if (this.explicitHydrogen == 0 && atomIndex >= 0 && stereoFlag == 4 && atom.getElementNumber() == 6) {
            String s = "";
            for (int i = 0; i < 4; ++i) {
                if ((s = this.addStereoCheck(0, atomIndex, stereo[i], s, BSUtil.newAndSetBit(atomIndex))) != null) continue;
                return "";
            }
        }
        if (this.is2D) {
            int dir = stereoFlag == 4 || !isFirst ? 1 : -1;
            SimpleEdge[] bonds = atom.getEdges();
            SimpleNode c = null;
            int i = atom.getBondCount();
            while (--i >= 0) {
                SimpleEdge b = bonds[i];
                if (atom != b.getAtom(0)) continue;
                switch (b.getBondType()) {
                    case 1025: {
                        c = b.getAtom(1);
                        this.setStereoTemp(stereo, c, dir);
                        break;
                    }
                    case 1041: {
                        c = b.getAtom(1);
                        this.setStereoTemp(stereo, c, -dir);
                    }
                }
            }
            if (c == null) {
                return "";
            }
            if (stereoFlag == 3) {
                stereo[stereoFlag++] = c;
            }
        }
        return SmilesStereo.getStereoFlag(atom, stereo, stereoFlag, this.vTemp, this.is2D);
    }

    private void setStereoTemp(SimpleNode[] stereo, SimpleNode a, float z) {
        for (int i = 0; i < 4; ++i) {
            if (stereo[i] != a) continue;
            SmilesAtom b = new SmilesAtom();
            P3 c = a.getXYZ();
            b.set(c.x, c.y, z);
            stereo[i] = b;
            break;
        }
    }

    private String addStereoCheck(int level, int atomIndex, SimpleNode atom, String s, BS bsDone) {
        int nh;
        if (bsDone != null) {
            bsDone.set(atomIndex);
        }
        int n = ((Node)atom).getAtomicAndIsotopeNumber();
        int nx = atom.getCovalentBondCount();
        int n2 = nh = n == 6 && this.explicitHydrogen != 0 ? ((Node)atom).getCovalentHydrogenCount() : 0;
        if (n == 6 ? nx != 4 : n == 1 || nx > 1) {
            return s + ++this.chainCheck;
        }
        String sa = ";" + level + "/" + n + "/" + nh + "/" + nx + (level == 0 ? "," : "_");
        if (n == 6) {
            switch (nh) {
                case 1: {
                    return s + sa + ++this.chainCheck;
                }
                case 0: 
                case 2: {
                    if (bsDone == null) {
                        return s;
                    }
                    Edge[] edges = ((Node)atom).getEdges();
                    String s2 = "";
                    String sa2 = "";
                    int nunique = nh == 2 ? 0 : 3;
                    int j = atom.getBondCount();
                    while (--j >= 0) {
                        SimpleNode a2 = edges[j].getOtherNode(atom);
                        int i2 = a2.getIndex();
                        if (bsDone.get(i2) || !edges[j].isCovalent() || a2.getElementNumber() == 1) continue;
                        bsDone.set(i2);
                        sa2 = this.addStereoCheck(level + 1, atom.getIndex(), a2, "", (BS)bsDone.clone());
                        if (s2.indexOf(sa2) >= 0) {
                            --nunique;
                        }
                        s2 = s2 + sa2;
                    }
                    if (nunique == 3) {
                        return s + sa + ++this.chainCheck;
                    }
                    sa = (sa + s2).replace(',', '_');
                    if (level <= 0) break;
                    return s + sa;
                }
            }
        }
        if (s.indexOf(sa) >= 0) {
            if (nh == 3) {
                int ndt = 0;
                for (int j = 0; j < nx && ndt < 3; ++j) {
                    int ia = ((Node)atom).getBondedAtomIndex(j);
                    if (ia == atomIndex) continue;
                    ndt += this.atoms[ia].getAtomicAndIsotopeNumber();
                }
                if (ndt > 3) {
                    return s;
                }
            }
            return null;
        }
        return s + sa;
    }

    private String getRingCache(int i0, int i1, Map<String, Object[]> ht) {
        String s;
        String key = SmilesGenerator.getRingKey(i0, i1);
        Object[] o = ht.get(key);
        String string = s = o == null ? null : (String)o[0];
        if (s == null) {
            this.bsRingKeys.set(++this.nPairs);
            this.nPairsMax = Math.max(this.nPairs, this.nPairsMax);
            Object[] objectArray = new Object[3];
            s = this.getRingPointer(this.nPairs);
            objectArray[0] = s;
            objectArray[1] = i1;
            objectArray[2] = this.nPairs;
            ht.put(key, objectArray);
            if (Logger.debugging) {
                Logger.debug("adding for " + i0 + " ring key " + this.nPairs + ": " + key);
            }
        } else {
            ht.remove(key);
            int nPair = (Integer)o[2];
            this.bsRingKeys.clear(nPair);
            if (this.bsRingKeys.nextSetBit(0) < 0 && (this.nPairsMax == 2 || this.nPairsMax == 99)) {
                this.nPairs = this.nPairsMax == 99 ? 10 : 0;
                this.nPairsMax = this.nPairs;
            }
            if (Logger.debugging) {
                Logger.debug("using ring key " + key);
            }
        }
        return s;
    }

    private String getRingPointer(int i) {
        return i < 10 ? "" + i : (i < 100 ? "%" + i : "%(" + i + ")");
    }

    private void dumpRingKeys(SB sb, Map<String, Object[]> ht) {
        Logger.info(sb.toString() + "\n\n");
        for (String key : ht.keySet()) {
            Logger.info("unmatched connection: " + key);
        }
    }

    protected static String getRingKey(int i0, int i1) {
        return Math.min(i0, i1) + "_" + Math.max(i0, i1);
    }
}

