/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.utils.Icons;
import jadx.gui.utils.OverlayIcon;
import jadx.gui.utils.UiUtils;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class JMethod
extends JNode {
    private static final long serialVersionUID = 3834526867464663751L;
    private static final ImageIcon ICON_METHOD = UiUtils.openSvgIcon("nodes/method");
    private static final ImageIcon ICON_METHOD_ABSTRACT = UiUtils.openSvgIcon("nodes/abstractMethod");
    private static final ImageIcon ICON_METHOD_PRIVATE = UiUtils.openSvgIcon("nodes/privateMethod");
    private static final ImageIcon ICON_METHOD_PROTECTED = UiUtils.openSvgIcon("nodes/protectedMethod");
    private static final ImageIcon ICON_METHOD_PUBLIC = UiUtils.openSvgIcon("nodes/publicMethod");
    private static final ImageIcon ICON_METHOD_CONSTRUCTOR = UiUtils.openSvgIcon("nodes/constructorMethod");
    private static final ImageIcon ICON_METHOD_SYNC = UiUtils.openSvgIcon("nodes/methodReference");
    private final transient JavaMethod mth;
    private final transient JClass jParent;
    private static final Comparator<JMethod> COMPARATOR = Comparator.comparing(JMethod::getJParent).thenComparing(jMethod -> jMethod.mth.getMethodNode().getMethodInfo().getShortId()).thenComparingInt(JMethod::getPos);

    public JMethod(JavaMethod javaMethod, JClass jClass) {
        this.mth = javaMethod;
        this.jParent = jClass;
    }

    @Override
    public JavaNode getJavaNode() {
        return this.mth;
    }

    public JavaMethod getJavaMethod() {
        return this.mth;
    }

    @Override
    public JClass getJParent() {
        return this.jParent;
    }

    public ArgType getReturnType() {
        return this.mth.getReturnType();
    }

    @Override
    public JClass getRootClass() {
        return this.jParent.getRootClass();
    }

    @Override
    public Icon getIcon() {
        AccessInfo accessFlags = this.mth.getAccessFlags();
        ImageIcon icon = ICON_METHOD;
        if (accessFlags.isAbstract()) {
            icon = ICON_METHOD_ABSTRACT;
        }
        if (accessFlags.isConstructor()) {
            icon = ICON_METHOD_CONSTRUCTOR;
        }
        if (accessFlags.isPublic()) {
            icon = ICON_METHOD_PUBLIC;
        }
        if (accessFlags.isPrivate()) {
            icon = ICON_METHOD_PRIVATE;
        }
        if (accessFlags.isProtected()) {
            icon = ICON_METHOD_PROTECTED;
        }
        if (accessFlags.isSynchronized()) {
            icon = ICON_METHOD_SYNC;
        }
        OverlayIcon overIcon = new OverlayIcon(icon);
        if (accessFlags.isFinal()) {
            overIcon.add(Icons.FINAL);
        }
        if (accessFlags.isStatic()) {
            overIcon.add(Icons.STATIC);
        }
        return overIcon;
    }

    @Override
    public String getSyntaxName() {
        return "text/java";
    }

    @Override
    public boolean canRename() {
        if (this.mth.isClassInit()) {
            return false;
        }
        return !this.mth.getMethodNode().contains(AFlag.DONT_RENAME);
    }

    String makeBaseString() {
        if (this.mth.isClassInit()) {
            return "{...}";
        }
        StringBuilder base = new StringBuilder();
        if (this.mth.isConstructor()) {
            base.append(this.mth.getDeclaringClass().getName());
        } else {
            base.append(this.mth.getName());
        }
        base.append('(');
        Iterator it = this.mth.getArguments().iterator();
        while (it.hasNext()) {
            base.append(UiUtils.typeStr((ArgType)it.next()));
            if (!it.hasNext()) continue;
            base.append(", ");
        }
        base.append(')');
        return base.toString();
    }

    @Override
    public String getName() {
        return this.mth.getName();
    }

    @Override
    public String makeString() {
        return UiUtils.typeFormat(this.makeBaseString(), this.getReturnType());
    }

    @Override
    public String makeStringHtml() {
        return UiUtils.typeFormatHtml(this.makeBaseString(), this.getReturnType());
    }

    @Override
    public String makeLongString() {
        String name = this.mth.getDeclaringClass().getFullName() + '.' + this.makeBaseString();
        return UiUtils.typeFormat(name, this.getReturnType());
    }

    @Override
    public String makeLongStringHtml() {
        String name = this.mth.getDeclaringClass().getFullName() + '.' + this.makeBaseString();
        return UiUtils.typeFormatHtml(name, this.getReturnType());
    }

    @Override
    public String makeDescString() {
        return UiUtils.typeStr(this.getReturnType()) + " " + this.makeBaseString();
    }

    @Override
    public boolean hasDescString() {
        return false;
    }

    @Override
    public int getPos() {
        return this.mth.getDefPos();
    }

    public int hashCode() {
        return this.mth.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof JMethod && this.mth.equals((Object)((JMethod)o).mth);
    }

    public int compareToMth(@NotNull JMethod other) {
        return COMPARATOR.compare(this, other);
    }

    @Override
    public int compareTo(@NotNull JNode other) {
        if (other instanceof JMethod) {
            return this.compareToMth((JMethod)other);
        }
        if (other instanceof JClass) {
            JClass cls = (JClass)other;
            int cmp = this.jParent.compareToCls(cls);
            if (cmp != 0) {
                return cmp;
            }
            return 1;
        }
        return super.compareTo(other);
    }
}

