/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaField;
import jadx.api.JavaNode;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.AccessInfo;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.utils.OverlayIcon;
import jadx.gui.utils.UiUtils;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class JField
extends JNode {
    private static final long serialVersionUID = 1712572192106793359L;
    private static final ImageIcon ICON_FLD_DEF = UiUtils.openSvgIcon("nodes/field");
    private static final ImageIcon ICON_FLD_PRI = UiUtils.openSvgIcon("nodes/privateField");
    private static final ImageIcon ICON_FLD_PRO = UiUtils.openSvgIcon("nodes/protectedField");
    private static final ImageIcon ICON_FLD_PUB = UiUtils.openSvgIcon("nodes/publicField");
    private final transient JavaField field;
    private final transient JClass jParent;
    private static final Comparator<JField> COMPARATOR = Comparator.comparing(JField::getJParent).thenComparing(JNode::getName).thenComparingInt(JNode::getPos);

    public JField(JavaField javaField, JClass jClass) {
        this.field = javaField;
        this.jParent = jClass;
    }

    public JavaField getJavaField() {
        return (JavaField)this.getJavaNode();
    }

    @Override
    public JavaNode getJavaNode() {
        return this.field;
    }

    @Override
    public JClass getJParent() {
        return this.jParent;
    }

    @Override
    public JClass getRootClass() {
        return this.jParent.getRootClass();
    }

    @Override
    public boolean canRename() {
        return !this.field.getFieldNode().contains(AFlag.DONT_RENAME);
    }

    @Override
    public Icon getIcon() {
        AccessInfo af = this.field.getAccessFlags();
        OverlayIcon icon = UiUtils.makeIcon(af, ICON_FLD_PUB, ICON_FLD_PRI, ICON_FLD_PRO, ICON_FLD_DEF);
        return icon;
    }

    @Override
    public String getSyntaxName() {
        return "text/java";
    }

    @Override
    public String makeString() {
        return UiUtils.typeFormat(this.field.getName(), this.field.getType());
    }

    @Override
    public String makeStringHtml() {
        return UiUtils.typeFormatHtml(this.field.getName(), this.field.getType());
    }

    @Override
    public String makeLongString() {
        return UiUtils.typeFormat(this.field.getFullName(), this.field.getType());
    }

    @Override
    public String makeLongStringHtml() {
        return UiUtils.typeFormatHtml(this.field.getFullName(), this.field.getType());
    }

    @Override
    public String getTooltip() {
        String fullType = UiUtils.escapeHtml(this.field.getType().toString());
        return UiUtils.wrapHtml(fullType + ' ' + UiUtils.escapeHtml(this.field.getName()));
    }

    @Override
    public String makeDescString() {
        return UiUtils.typeStr(this.field.getType()) + " " + this.field.getName();
    }

    @Override
    public boolean hasDescString() {
        return false;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof JField && this.field.equals((Object)((JField)o).field);
    }

    public int compareToFld(@NotNull JField other) {
        return COMPARATOR.compare(this, other);
    }

    @Override
    public int compareTo(@NotNull JNode other) {
        if (other instanceof JField) {
            return this.compareToFld((JField)other);
        }
        return super.compareTo(other);
    }
}

