/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings;

import com.beust.jcommander.Parameter;
import jadx.api.CommentsLevel;
import jadx.api.DecompilationMode;
import jadx.api.JadxArgs;
import jadx.api.args.DeobfuscationMapFileMode;
import jadx.api.args.ResourceNameSource;
import jadx.cli.JadxCLIArgs;
import jadx.cli.LogHelper;
import jadx.gui.settings.JadxSettingsAdapter;
import jadx.gui.settings.LineNumbersMode;
import jadx.gui.settings.WindowLocation;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.EditorTheme;
import jadx.gui.utils.FontUtils;
import jadx.gui.utils.LangLocale;
import jadx.gui.utils.NLS;
import jadx.gui.utils.codecache.CodeCacheMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JFrame;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxSettings
extends JadxCLIArgs {
    private static final Logger LOG = LoggerFactory.getLogger(JadxSettings.class);
    private static final Path USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]);
    private static final int RECENT_PROJECTS_COUNT = 15;
    private static final int CURRENT_SETTINGS_VERSION = 18;
    private static final Font DEFAULT_FONT = new RSyntaxTextArea().getFont();
    static final Set<String> SKIP_FIELDS = new HashSet<String>(Arrays.asList("files", "input", "outDir", "outDirSrc", "outDirRes", "outputFormat", "deobfuscationMapFile", "verbose", "quiet", "logLevel", "printVersion", "printHelp"));
    private Path lastSaveProjectPath = USER_HOME;
    private Path lastOpenFilePath = USER_HOME;
    private Path lastSaveFilePath = USER_HOME;
    private boolean flattenPackage = false;
    private boolean checkForUpdates = true;
    private List<Path> recentProjects = new ArrayList<Path>();
    private String fontStr = "";
    private String smaliFontStr = "";
    private String editorThemePath = "";
    private String lafTheme = "FlatLaf Light";
    private LangLocale langLocale = NLS.defaultLocale();
    private boolean autoStartJobs = false;
    private String excludedPackages = "";
    private boolean autoSaveProject = false;
    private boolean showHeapUsageBar = false;
    private boolean alwaysSelectOpened = false;
    private Map<String, WindowLocation> windowPos = new HashMap<String, WindowLocation>();
    private int mainWindowExtendedState = 0;
    private boolean codeAreaLineWrap = false;
    private int srhResourceSkipSize = 1000;
    private String srhResourceFileExt = ".xml|.html|.js|.json|.txt";
    private boolean useAutoSearch = true;
    private boolean keepCommonDialogOpen = false;
    private boolean smaliAreaShowBytecode = false;
    private LineNumbersMode lineNumbersMode = LineNumbersMode.AUTO;
    private int mainWindowVerticalSplitterLoc = 300;
    private int debuggerStackFrameSplitterLoc = 300;
    private int debuggerVarTreeSplitterLoc = 700;
    private String adbDialogPath = "";
    private String adbDialogHost = "localhost";
    private String adbDialogPort = "5037";
    private CodeCacheMode codeCacheMode = CodeCacheMode.DISK_WITH_CACHE;
    private boolean jumpOnDoubleClick = true;
    private int treeWidth = 130;
    private int settingsVersion = 0;
    @JadxSettingsAdapter.GsonExclude
    @Parameter(names={"-sc", "--select-class"}, description="GUI: Open the selected class and show the decompiled code")
    private String cmdSelectClass = null;
    @JadxSettingsAdapter.GsonExclude
    private Font cachedFont = null;

    public static JadxSettings makeDefault() {
        JadxSettings jadxSettings = new JadxSettings();
        jadxSettings.fixOnLoad();
        return jadxSettings;
    }

    public void sync() {
        JadxSettingsAdapter.store(this);
    }

    private void partialSync(Consumer<JadxSettings> updater) {
        JadxSettings settings = JadxSettingsAdapter.load();
        updater.accept(settings);
        JadxSettingsAdapter.store(settings);
    }

    public void fixOnLoad() {
        if (this.threadsCount <= 0) {
            this.threadsCount = JadxArgs.DEFAULT_THREADS_COUNT;
        }
        if (this.deobfuscationMinLength < 0) {
            this.deobfuscationMinLength = 0;
        }
        if (this.deobfuscationMaxLength < 0) {
            this.deobfuscationMaxLength = 0;
        }
        if (this.settingsVersion != 18) {
            this.upgradeSettings(this.settingsVersion);
        }
    }

    public int getSettingsVersion() {
        return this.settingsVersion;
    }

    public void setSettingsVersion(int settingsVersion) {
        this.settingsVersion = settingsVersion;
    }

    public String getCmdSelectClass() {
        return this.cmdSelectClass;
    }

    public Path getLastOpenFilePath() {
        return this.lastOpenFilePath;
    }

    public void setLastOpenFilePath(Path lastOpenFilePath) {
        this.lastOpenFilePath = lastOpenFilePath;
        this.partialSync(settings -> {
            settings.lastOpenFilePath = lastOpenFilePath;
        });
    }

    public Path getLastSaveProjectPath() {
        return this.lastSaveProjectPath;
    }

    public Path getLastSaveFilePath() {
        return this.lastSaveFilePath;
    }

    public void setLastSaveProjectPath(Path lastSaveProjectPath) {
        this.lastSaveProjectPath = lastSaveProjectPath;
        this.partialSync(settings -> {
            settings.lastSaveProjectPath = lastSaveProjectPath;
        });
    }

    public void setLastSaveFilePath(Path lastSaveFilePath) {
        this.lastSaveFilePath = lastSaveFilePath;
        this.partialSync(settings -> {
            settings.lastSaveFilePath = lastSaveFilePath;
        });
    }

    public boolean isFlattenPackage() {
        return this.flattenPackage;
    }

    public void setFlattenPackage(boolean flattenPackage) {
        this.flattenPackage = flattenPackage;
        this.partialSync(settings -> {
            settings.flattenPackage = flattenPackage;
        });
    }

    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    public void setCheckForUpdates(boolean checkForUpdates) {
        this.checkForUpdates = checkForUpdates;
        this.sync();
    }

    public List<Path> getRecentProjects() {
        return Collections.unmodifiableList(this.recentProjects);
    }

    public void addRecentProject(@Nullable Path projectPath) {
        if (projectPath == null) {
            return;
        }
        this.recentProjects.remove(projectPath);
        this.recentProjects.add(0, projectPath);
        int count = this.recentProjects.size();
        if (count > 15) {
            this.recentProjects.subList(15, count).clear();
        }
        this.partialSync(settings -> {
            settings.recentProjects = this.recentProjects;
        });
    }

    public void removeRecentProject(Path projectPath) {
        this.recentProjects.remove(projectPath);
        this.partialSync(settings -> {
            settings.recentProjects = this.recentProjects;
        });
    }

    public void saveWindowPos(Window window) {
        WindowLocation pos = new WindowLocation(window.getClass().getSimpleName(), window.getBounds());
        this.windowPos.put(pos.getWindowId(), pos);
        this.partialSync(settings -> {
            settings.windowPos = this.windowPos;
        });
    }

    public boolean loadWindowPos(Window window) {
        WindowLocation pos = this.windowPos.get(window.getClass().getSimpleName());
        if (pos == null || pos.getBounds() == null) {
            return false;
        }
        if (!JadxSettings.isAccessibleInAnyScreen(pos)) {
            return false;
        }
        window.setBounds(pos.getBounds());
        if (window instanceof MainWindow) {
            ((JFrame)window).setExtendedState(this.getMainWindowExtendedState());
        }
        return true;
    }

    private static boolean isAccessibleInAnyScreen(WindowLocation pos) {
        Rectangle windowBounds = pos.getBounds();
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            Rectangle screenBounds = gd.getDefaultConfiguration().getBounds();
            if (!screenBounds.intersects(windowBounds)) continue;
            return true;
        }
        LOG.debug("Window saved position was ignored: {}", (Object)pos);
        return false;
    }

    public boolean isShowHeapUsageBar() {
        return this.showHeapUsageBar;
    }

    public void setShowHeapUsageBar(boolean showHeapUsageBar) {
        this.showHeapUsageBar = showHeapUsageBar;
        this.partialSync(settings -> {
            settings.showHeapUsageBar = showHeapUsageBar;
        });
    }

    public boolean isAlwaysSelectOpened() {
        return this.alwaysSelectOpened;
    }

    public void setAlwaysSelectOpened(boolean alwaysSelectOpened) {
        this.alwaysSelectOpened = alwaysSelectOpened;
        this.partialSync(settings -> {
            settings.alwaysSelectOpened = alwaysSelectOpened;
        });
    }

    public String getExcludedPackages() {
        return this.excludedPackages;
    }

    public void setExcludedPackages(String excludedPackages) {
        this.excludedPackages = excludedPackages;
    }

    public void setThreadsCount(int threadsCount) {
        this.threadsCount = threadsCount;
    }

    public void setFallbackMode(boolean fallbackMode) {
        this.fallbackMode = fallbackMode;
    }

    public void setUseDx(boolean useDx) {
        this.useDx = useDx;
    }

    public void setSkipResources(boolean skipResources) {
        this.skipResources = skipResources;
    }

    public void setSkipSources(boolean skipSources) {
        this.skipSources = skipSources;
    }

    public void setDecompilationMode(DecompilationMode decompilationMode) {
        this.decompilationMode = decompilationMode;
    }

    public void setShowInconsistentCode(boolean showInconsistentCode) {
        this.showInconsistentCode = showInconsistentCode;
    }

    public LangLocale getLangLocale() {
        return this.langLocale;
    }

    public void setLangLocale(LangLocale langLocale) {
        this.langLocale = langLocale;
    }

    public void setCfgOutput(boolean cfgOutput) {
        this.cfgOutput = cfgOutput;
    }

    public void setRawCfgOutput(boolean rawCfgOutput) {
        this.rawCfgOutput = rawCfgOutput;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDebugInfo(boolean useDebugInfo) {
        this.debugInfo = useDebugInfo;
    }

    public void setDeobfuscationOn(boolean deobfuscationOn) {
        this.deobfuscationOn = deobfuscationOn;
    }

    public void setDeobfuscationMinLength(int deobfuscationMinLength) {
        this.deobfuscationMinLength = deobfuscationMinLength;
    }

    public void setDeobfuscationMaxLength(int deobfuscationMaxLength) {
        this.deobfuscationMaxLength = deobfuscationMaxLength;
    }

    public void setDeobfuscationMapFileMode(DeobfuscationMapFileMode mode) {
        this.deobfuscationMapFileMode = mode;
    }

    public void setDeobfuscationUseSourceNameAsAlias(boolean deobfuscationUseSourceNameAsAlias) {
        this.deobfuscationUseSourceNameAsAlias = deobfuscationUseSourceNameAsAlias;
    }

    public void setDeobfuscationParseKotlinMetadata(boolean deobfuscationParseKotlinMetadata) {
        this.deobfuscationParseKotlinMetadata = deobfuscationParseKotlinMetadata;
    }

    public void setUseKotlinMethodsForVarNames(JadxArgs.UseKotlinMethodsForVarNames useKotlinMethodsForVarNames) {
        this.useKotlinMethodsForVarNames = useKotlinMethodsForVarNames;
    }

    public void setResourceNameSource(ResourceNameSource source) {
        this.resourceNameSource = source;
    }

    public void updateRenameFlag(JadxArgs.RenameEnum flag, boolean enabled) {
        if (enabled) {
            this.renameFlags.add(flag);
        } else {
            this.renameFlags.remove(flag);
        }
    }

    public void setEscapeUnicode(boolean escapeUnicode) {
        this.escapeUnicode = escapeUnicode;
    }

    public void setReplaceConsts(boolean replaceConsts) {
        this.replaceConsts = replaceConsts;
    }

    public void setRespectBytecodeAccessModifiers(boolean respectBytecodeAccessModifiers) {
        this.respectBytecodeAccessModifiers = respectBytecodeAccessModifiers;
    }

    public void setUseImports(boolean useImports) {
        this.useImports = useImports;
    }

    public void setInlineAnonymousClasses(boolean inlineAnonymousClasses) {
        this.inlineAnonymousClasses = inlineAnonymousClasses;
    }

    public void setInlineMethods(boolean inlineMethods) {
        this.inlineMethods = inlineMethods;
    }

    public void setExtractFinally(boolean extractFinally) {
        this.extractFinally = extractFinally;
    }

    public void setFsCaseSensitive(boolean fsCaseSensitive) {
        this.fsCaseSensitive = fsCaseSensitive;
    }

    public boolean isAutoStartJobs() {
        return this.autoStartJobs;
    }

    public void setAutoStartJobs(boolean autoStartJobs) {
        this.autoStartJobs = autoStartJobs;
    }

    public boolean isAutoSaveProject() {
        return this.autoSaveProject;
    }

    public void setAutoSaveProject(boolean autoSaveProject) {
        this.autoSaveProject = autoSaveProject;
    }

    public void setExportAsGradleProject(boolean exportAsGradleProject) {
        this.exportAsGradleProject = exportAsGradleProject;
    }

    public int getTreeWidth() {
        return this.treeWidth;
    }

    public void setTreeWidth(int treeWidth) {
        this.treeWidth = treeWidth;
        this.partialSync(settings -> {
            settings.treeWidth = this.treeWidth;
        });
    }

    public Font getFont() {
        if (this.cachedFont != null) {
            return this.cachedFont;
        }
        if (this.fontStr.isEmpty()) {
            return DEFAULT_FONT;
        }
        try {
            Font font;
            this.cachedFont = font = FontUtils.loadByStr(this.fontStr);
            return font;
        }
        catch (Exception e) {
            LOG.warn("Failed to load font: {}, reset to default", (Object)this.fontStr, (Object)e);
            this.setFont(DEFAULT_FONT);
            return DEFAULT_FONT;
        }
    }

    public void setFont(@Nullable Font font) {
        if (font == null) {
            this.setFontStr("");
        } else {
            this.setFontStr(FontUtils.convertToStr(font));
            this.cachedFont = font;
        }
    }

    public String getFontStr() {
        return this.fontStr;
    }

    public void setFontStr(String fontStr) {
        this.fontStr = fontStr;
        this.cachedFont = null;
    }

    public Font getSmaliFont() {
        if (this.smaliFontStr.isEmpty()) {
            return DEFAULT_FONT;
        }
        try {
            return FontUtils.loadByStr(this.smaliFontStr);
        }
        catch (Exception e) {
            LOG.warn("Failed to load font: {} for smali, reset to default", (Object)this.smaliFontStr, (Object)e);
            this.setSmaliFont(DEFAULT_FONT);
            return DEFAULT_FONT;
        }
    }

    public void setSmaliFont(@Nullable Font font) {
        this.smaliFontStr = font == null ? "" : FontUtils.convertToStr(font);
    }

    public void setLogLevel(LogHelper.LogLevelEnum level) {
        this.logLevel = level;
    }

    public String getEditorThemePath() {
        return this.editorThemePath;
    }

    public void setEditorThemePath(String editorThemePath) {
        this.editorThemePath = editorThemePath;
    }

    public String getLafTheme() {
        return this.lafTheme;
    }

    public void setLafTheme(String lafTheme) {
        this.lafTheme = lafTheme;
    }

    public int getMainWindowExtendedState() {
        return this.mainWindowExtendedState;
    }

    public void setMainWindowExtendedState(int mainWindowExtendedState) {
        this.mainWindowExtendedState = mainWindowExtendedState;
        this.partialSync(settings -> {
            settings.mainWindowExtendedState = mainWindowExtendedState;
        });
    }

    public void setCodeAreaLineWrap(boolean lineWrap) {
        this.codeAreaLineWrap = lineWrap;
    }

    public boolean isCodeAreaLineWrap() {
        return this.codeAreaLineWrap;
    }

    public int getSrhResourceSkipSize() {
        return this.srhResourceSkipSize;
    }

    public void setSrhResourceSkipSize(int size) {
        this.srhResourceSkipSize = size;
    }

    public String getSrhResourceFileExt() {
        return this.srhResourceFileExt;
    }

    public void setSrhResourceFileExt(String all) {
        this.srhResourceFileExt = all.trim();
    }

    public boolean isUseAutoSearch() {
        return this.useAutoSearch;
    }

    public void setUseAutoSearch(boolean useAutoSearch) {
        this.useAutoSearch = useAutoSearch;
        this.partialSync(settings -> {
            settings.useAutoSearch = useAutoSearch;
        });
    }

    public void setKeepCommonDialogOpen(boolean yes) {
        this.keepCommonDialogOpen = yes;
    }

    public boolean getKeepCommonDialogOpen() {
        return this.keepCommonDialogOpen;
    }

    public void setSmaliAreaShowBytecode(boolean yes) {
        this.smaliAreaShowBytecode = yes;
    }

    public boolean getSmaliAreaShowBytecode() {
        return this.smaliAreaShowBytecode;
    }

    public void setMainWindowVerticalSplitterLoc(int location) {
        this.mainWindowVerticalSplitterLoc = location;
        this.partialSync(settings -> {
            settings.mainWindowVerticalSplitterLoc = location;
        });
    }

    public int getMainWindowVerticalSplitterLoc() {
        return this.mainWindowVerticalSplitterLoc;
    }

    public void setDebuggerStackFrameSplitterLoc(int location) {
        this.debuggerStackFrameSplitterLoc = location;
        this.partialSync(settings -> {
            settings.debuggerStackFrameSplitterLoc = location;
        });
    }

    public int getDebuggerStackFrameSplitterLoc() {
        return this.debuggerStackFrameSplitterLoc;
    }

    public void setDebuggerVarTreeSplitterLoc(int location) {
        this.debuggerVarTreeSplitterLoc = location;
        this.partialSync(settings -> {
            this.debuggerVarTreeSplitterLoc = location;
        });
    }

    public int getDebuggerVarTreeSplitterLoc() {
        return this.debuggerVarTreeSplitterLoc;
    }

    public String getAdbDialogPath() {
        return this.adbDialogPath;
    }

    public void setAdbDialogPath(String path) {
        this.adbDialogPath = path;
    }

    public String getAdbDialogHost() {
        return this.adbDialogHost;
    }

    public void setAdbDialogHost(String host) {
        this.adbDialogHost = host;
    }

    public String getAdbDialogPort() {
        return this.adbDialogPort;
    }

    public void setAdbDialogPort(String port) {
        this.adbDialogPort = port;
    }

    public void setCommentsLevel(CommentsLevel level) {
        this.commentsLevel = level;
    }

    public LineNumbersMode getLineNumbersMode() {
        return this.lineNumbersMode;
    }

    public void setLineNumbersMode(LineNumbersMode lineNumbersMode) {
        this.lineNumbersMode = lineNumbersMode;
    }

    public void setPluginOptions(Map<String, String> pluginOptions) {
        this.pluginOptions = pluginOptions;
    }

    public CodeCacheMode getCodeCacheMode() {
        return this.codeCacheMode;
    }

    public void setCodeCacheMode(CodeCacheMode codeCacheMode) {
        this.codeCacheMode = codeCacheMode;
    }

    public boolean isJumpOnDoubleClick() {
        return this.jumpOnDoubleClick;
    }

    public void setJumpOnDoubleClick(boolean jumpOnDoubleClick) {
        this.jumpOnDoubleClick = jumpOnDoubleClick;
    }

    private void upgradeSettings(int fromVersion) {
        LOG.debug("upgrade settings from version: {} to {}", (Object)fromVersion, (Object)18);
        if (fromVersion == 0) {
            this.setDeobfuscationMinLength(3);
            this.setDeobfuscationMaxLength(64);
            this.setDeobfuscationUseSourceNameAsAlias(true);
            this.setDeobfuscationParseKotlinMetadata(true);
            this.setDeobfuscationMapFileMode(DeobfuscationMapFileMode.READ);
            this.setThreadsCount(JadxArgs.DEFAULT_THREADS_COUNT);
            this.setReplaceConsts(true);
            this.setSkipResources(false);
            this.setAutoStartJobs(false);
            this.setAutoSaveProject(true);
            ++fromVersion;
        }
        if (fromVersion == 1) {
            this.setEditorThemePath(EditorTheme.getDefaultTheme().getPath());
            ++fromVersion;
        }
        if (fromVersion == 2) {
            if (this.getDeobfuscationMinLength() == 4) {
                this.setDeobfuscationMinLength(3);
            }
            ++fromVersion;
        }
        if (fromVersion == 3) {
            this.setLangLocale(NLS.defaultLocale());
            ++fromVersion;
        }
        if (fromVersion == 4) {
            this.setUseImports(true);
            ++fromVersion;
        }
        if (fromVersion == 5) {
            this.setRespectBytecodeAccessModifiers(false);
            ++fromVersion;
        }
        if (fromVersion == 6) {
            if (this.getFont().getFontName().equals("Hack Regular")) {
                this.setFont(null);
            }
            ++fromVersion;
        }
        if (fromVersion == 7) {
            this.outDir = null;
            this.outDirSrc = null;
            this.outDirRes = null;
            ++fromVersion;
        }
        if (fromVersion == 8) {
            ++fromVersion;
        }
        if (fromVersion == 9) {
            this.showHeapUsageBar = false;
            ++fromVersion;
        }
        if (fromVersion == 10) {
            this.srhResourceSkipSize = 3;
            this.srhResourceFileExt = ".xml|.html|.js|.json|.txt";
            this.fontStr = this.fontStr.replace('-', '/');
            ++fromVersion;
        }
        if (fromVersion == 11) {
            this.inlineMethods = true;
            ++fromVersion;
        }
        if (fromVersion == 12) {
            this.alwaysSelectOpened = false;
            ++fromVersion;
        }
        if (fromVersion == 13) {
            this.lafTheme = "FlatLaf Light";
            ++fromVersion;
        }
        if (fromVersion == 14) {
            this.useKotlinMethodsForVarNames = JadxArgs.UseKotlinMethodsForVarNames.APPLY;
            ++fromVersion;
        }
        if (fromVersion == 15) {
            this.deobfuscationMapFileMode = DeobfuscationMapFileMode.READ;
            ++fromVersion;
        }
        if (fromVersion == 16) {
            this.decompilationMode = this.fallbackMode ? DecompilationMode.FALLBACK : DecompilationMode.AUTO;
            ++fromVersion;
        }
        if (fromVersion == 17) {
            this.checkForUpdates = true;
            ++fromVersion;
        }
        if (fromVersion != 18) {
            LOG.warn("Incorrect settings upgrade. Expected version: {}, got: {}", (Object)18, (Object)fromVersion);
        }
        this.settingsVersion = 18;
        this.sync();
    }

    protected JadxCLIArgs newInstance() {
        return new JadxSettings();
    }
}

