/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jadx.api.data.ICodeComment;
import jadx.api.data.ICodeRename;
import jadx.api.data.IJavaCodeRef;
import jadx.api.data.IJavaNodeRef;
import jadx.api.data.impl.JadxCodeComment;
import jadx.api.data.impl.JadxCodeData;
import jadx.api.data.impl.JadxCodeRef;
import jadx.api.data.impl.JadxCodeRename;
import jadx.api.data.impl.JadxNodeRef;
import jadx.api.plugins.utils.CommonFileUtils;
import jadx.core.utils.GsonUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.TabStateViewAdapter;
import jadx.gui.settings.data.ProjectData;
import jadx.gui.settings.data.TabViewState;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.EditorViewState;
import jadx.gui.utils.RelativePathTypeAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxProject {
    private static final Logger LOG = LoggerFactory.getLogger(JadxProject.class);
    private static final int CURRENT_PROJECT_VERSION = 1;
    public static final String PROJECT_EXTENSION = "jadx";
    private static final int SEARCH_HISTORY_LIMIT = 30;
    private final transient MainWindow mainWindow;
    private transient String name = "New Project";
    @Nullable
    private transient Path projectPath;
    private transient boolean initial = true;
    private transient boolean saved;
    private ProjectData data = new ProjectData();

    public JadxProject(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    @Nullable
    public Path getWorkingDir() {
        if (this.projectPath != null) {
            return this.projectPath.toAbsolutePath().getParent();
        }
        List<Path> files = this.data.getFiles();
        if (!files.isEmpty()) {
            Path path = files.get(0);
            return path.toAbsolutePath().getParent();
        }
        return null;
    }

    @Nullable
    public Path getProjectPath() {
        return this.projectPath;
    }

    private void setProjectPath(@NotNull Path projectPath) {
        this.projectPath = projectPath;
        this.name = CommonFileUtils.removeFileExtension((String)projectPath.getFileName().toString());
        this.changed();
    }

    public List<Path> getFilePaths() {
        return this.data.getFiles();
    }

    public void setFilePaths(List<Path> files) {
        if (!files.equals(this.getFilePaths())) {
            this.data.setFiles(files);
            String joinedName = files.stream().map(p -> CommonFileUtils.removeFileExtension((String)p.getFileName().toString())).collect(Collectors.joining("_"));
            this.name = StringUtils.abbreviate((String)joinedName, (int)100);
            this.changed();
        }
    }

    public List<String[]> getTreeExpansions() {
        return this.data.getTreeExpansions();
    }

    public void addTreeExpansion(String[] expansion) {
        this.data.getTreeExpansions().add(expansion);
        this.changed();
    }

    public void removeTreeExpansion(String[] expansion) {
        this.data.getTreeExpansions().removeIf(strings -> this.isParentOfExpansion(expansion, (String[])strings));
        this.changed();
    }

    private boolean isParentOfExpansion(String[] parent, String[] child) {
        if (Arrays.equals(parent, child)) {
            return true;
        }
        for (int i = child.length - parent.length; i > 0; --i) {
            Object[] arr = Arrays.copyOfRange(child, i, child.length);
            if (!Arrays.equals(parent, arr)) continue;
            return true;
        }
        return false;
    }

    public JadxCodeData getCodeData() {
        return this.data.getCodeData();
    }

    public void setCodeData(JadxCodeData codeData) {
        this.data.setCodeData(codeData);
        this.changed();
    }

    public void saveOpenTabs(List<EditorViewState> tabs, int activeTab) {
        List<TabViewState> tabStateList = tabs.stream().map(TabStateViewAdapter::build).filter(Objects::nonNull).collect(Collectors.toList());
        if (tabStateList.isEmpty()) {
            return;
        }
        boolean dataChanged = this.data.setOpenTabs(tabStateList);
        if (dataChanged |= this.data.setActiveTab(activeTab)) {
            this.changed();
        }
    }

    public List<EditorViewState> getOpenTabs(MainWindow mw) {
        return this.data.getOpenTabs().stream().map(s -> TabStateViewAdapter.load(mw, s)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public int getActiveTab() {
        return this.data.getActiveTab();
    }

    @NotNull
    public Path getCacheDir() {
        Path cacheDir = this.data.getCacheDir();
        if (cacheDir != null) {
            return cacheDir;
        }
        Path newCacheDir = this.buildCacheDir();
        this.setCacheDir(newCacheDir);
        return newCacheDir;
    }

    public void setCacheDir(Path cacheDir) {
        this.data.setCacheDir(cacheDir);
        this.changed();
    }

    private Path buildCacheDir() {
        if (this.projectPath != null) {
            return this.projectPath.resolveSibling(this.projectPath.getFileName() + ".cache");
        }
        List<Path> files = this.data.getFiles();
        if (!files.isEmpty()) {
            Path path = files.get(0);
            return path.resolveSibling(path.getFileName() + ".cache");
        }
        throw new JadxRuntimeException("Failed to build cache dir");
    }

    public boolean isEnableLiveReload() {
        return this.data.isEnableLiveReload();
    }

    public void setEnableLiveReload(boolean newValue) {
        if (newValue != this.data.isEnableLiveReload()) {
            this.data.setEnableLiveReload(newValue);
            this.changed();
        }
    }

    public List<String> getSearchHistory() {
        return this.data.getSearchHistory();
    }

    public void addToSearchHistory(String str) {
        if (str == null || str.isEmpty()) {
            return;
        }
        List<String> list = this.data.getSearchHistory();
        if (!list.isEmpty() && list.get(0).equals(str)) {
            return;
        }
        list.remove(str);
        list.add(0, str);
        if (list.size() > 30) {
            list.remove(list.size() - 1);
        }
        this.data.setSearchHistory(list);
        this.changed();
    }

    private void changed() {
        JadxSettings settings = this.mainWindow.getSettings();
        if (settings != null && settings.isAutoSaveProject()) {
            this.save();
        } else {
            this.saved = false;
        }
        this.initial = false;
        this.mainWindow.updateProject(this);
    }

    public String getName() {
        return this.name;
    }

    public boolean isSaveFileSelected() {
        return this.projectPath != null;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public void saveAs(Path path) {
        this.setProjectPath(path);
        this.save();
    }

    public void save() {
        Path savePath = this.getProjectPath();
        if (savePath != null) {
            Path basePath = savePath.toAbsolutePath().getParent();
            try (BufferedWriter writer = Files.newBufferedWriter(savePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                JadxProject.buildGson(basePath).toJson((Object)this.data, (Appendable)writer);
                this.saved = true;
            }
            catch (Exception e) {
                throw new RuntimeException("Error saving project", e);
            }
        }
    }

    public static JadxProject load(MainWindow mainWindow, Path path) {
        JadxProject jadxProject;
        block8: {
            Path basePath = path.toAbsolutePath().getParent();
            BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
            try {
                JadxProject project = new JadxProject(mainWindow);
                project.data = (ProjectData)JadxProject.buildGson(basePath).fromJson((Reader)reader, ProjectData.class);
                project.saved = true;
                project.setProjectPath(path);
                project.upgrade();
                jadxProject = project;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("Error loading project", (Throwable)e);
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return jadxProject;
    }

    private static Gson buildGson(Path basePath) {
        return new GsonBuilder().registerTypeHierarchyAdapter(Path.class, (Object)new RelativePathTypeAdapter(basePath)).registerTypeAdapter(ICodeComment.class, (Object)GsonUtils.interfaceReplace(JadxCodeComment.class)).registerTypeAdapter(ICodeRename.class, (Object)GsonUtils.interfaceReplace(JadxCodeRename.class)).registerTypeAdapter(IJavaNodeRef.class, (Object)GsonUtils.interfaceReplace(JadxNodeRef.class)).registerTypeAdapter(IJavaCodeRef.class, (Object)GsonUtils.interfaceReplace(JadxCodeRef.class)).setPrettyPrinting().create();
    }

    private void upgrade() {
        int fromVersion = this.data.getProjectVersion();
        if (fromVersion == 1) {
            return;
        }
        LOG.debug("upgrade project settings from version: {} to {}", (Object)fromVersion, (Object)1);
        if (fromVersion == 0) {
            ++fromVersion;
        }
        if (fromVersion != 1) {
            throw new JadxRuntimeException("Project update failed");
        }
        this.data.setProjectVersion(1);
        this.save();
    }
}

