/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import org.jetbrains.annotations.Nullable;

public class EncodedValueUtils {
    @Nullable
    public static Object convertToConstValue(EncodedValue encodedValue) {
        if (encodedValue == null) {
            return null;
        }
        Object value = encodedValue.getValue();
        switch (encodedValue.getType()) {
            case ENCODED_NULL: {
                return InsnArg.lit(0L, ArgType.OBJECT);
            }
            case ENCODED_BOOLEAN: {
                return Boolean.TRUE.equals(value) ? LiteralArg.litTrue() : LiteralArg.litFalse();
            }
            case ENCODED_BYTE: {
                return InsnArg.lit(((Byte)value).byteValue(), ArgType.BYTE);
            }
            case ENCODED_SHORT: {
                return InsnArg.lit(((Short)value).shortValue(), ArgType.SHORT);
            }
            case ENCODED_CHAR: {
                return InsnArg.lit(((Character)value).charValue(), ArgType.CHAR);
            }
            case ENCODED_INT: {
                return InsnArg.lit(((Integer)value).intValue(), ArgType.INT);
            }
            case ENCODED_LONG: {
                return InsnArg.lit((Long)value, ArgType.LONG);
            }
            case ENCODED_FLOAT: {
                return InsnArg.lit(Float.floatToIntBits(((Float)value).floatValue()), ArgType.FLOAT);
            }
            case ENCODED_DOUBLE: {
                return InsnArg.lit(Double.doubleToLongBits((Double)value), ArgType.DOUBLE);
            }
            case ENCODED_STRING: {
                return (String)value;
            }
            case ENCODED_TYPE: {
                return ArgType.parse((String)value);
            }
        }
        return null;
    }
}

