/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.ide.common.xml.XmlFormatStyle;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.DocumentModel;
import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.Selector;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlNode;
import com.android.sdklib.SdkVersionInfo;
import com.android.utils.Pair;
import com.android.utils.PositionXmlParser;
import com.android.utils.XmlUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlDocument {
    private static final String DEFAULT_SDK_VERSION = "1";
    private final Element mRootElement;
    private final AtomicReference<XmlElement> mRootNode = new AtomicReference<Object>(null);
    private final SourceFile mSourceFile;
    private final KeyResolver<String> mSelectors;
    private final PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> mSystemPropertyResolver;
    private final Type mType;
    private final String mNamespace;
    private final DocumentModel<ManifestModel.NodeTypes> mModel;
    public Map<Element, NodeOperationType> originalNodeOperation = new HashMap<Element, NodeOperationType>();

    public XmlDocument(SourceFile sourceLocation, KeyResolver<String> selectors, PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> systemPropertyResolver, Element element, Type type, String namespace, DocumentModel<ManifestModel.NodeTypes> model) {
        this.mSourceFile = (SourceFile)Preconditions.checkNotNull((Object)sourceLocation);
        this.mRootElement = (Element)Preconditions.checkNotNull((Object)element);
        this.mSelectors = (KeyResolver)Preconditions.checkNotNull(selectors);
        this.mSystemPropertyResolver = (PlaceholderHandler.KeyBasedValueResolver)Preconditions.checkNotNull(systemPropertyResolver);
        this.mType = type;
        this.mNamespace = namespace;
        this.mModel = model;
    }

    public Type getFileType() {
        return this.mType;
    }

    public DocumentModel<ManifestModel.NodeTypes> getModel() {
        return this.mModel;
    }

    public String prettyPrint() {
        return XmlDocument.prettyPrint(this.getXml());
    }

    public static String prettyPrint(Document document) {
        return XmlPrettyPrinter.prettyPrint((Node)document, (XmlFormatPreferences)XmlFormatPreferences.defaults(), (XmlFormatStyle)XmlFormatStyle.get((Node)document), null, (boolean)false);
    }

    public Optional<XmlDocument> merge(XmlDocument lowerPriorityDocument, MergingReport.Builder mergingReportBuilder) {
        return this.merge(lowerPriorityDocument, mergingReportBuilder, true, false);
    }

    public Optional<XmlDocument> merge(XmlDocument lowerPriorityDocument, MergingReport.Builder mergingReportBuilder, boolean addImplicitPermissions, boolean disableMinSdkVersionCheck) {
        if (this.getFileType() == Type.MAIN) {
            mergingReportBuilder.getActionRecorder().recordAddedNodeAction(this.getRootNode(), false);
        }
        this.getRootNode().mergeWithLowerPriorityNode(lowerPriorityDocument.getRootNode(), mergingReportBuilder);
        this.addImplicitElements(lowerPriorityDocument, this.reparse(), mergingReportBuilder, addImplicitPermissions, disableMinSdkVersionCheck);
        return mergingReportBuilder.hasErrors() ? Optional.empty() : Optional.of(this.reparse());
    }

    public XmlDocument reparse() {
        XmlDocument newXmlDocument = new XmlDocument(this.mSourceFile, this.mSelectors, this.mSystemPropertyResolver, this.mRootElement, this.mType, this.mNamespace, this.mModel);
        newXmlDocument.originalNodeOperation = this.originalNodeOperation;
        return newXmlDocument;
    }

    public KeyResolver<String> getSelectors() {
        return this.mSelectors;
    }

    public PlaceholderHandler.KeyBasedValueResolver<ManifestSystemProperty> getSystemPropertyResolver() {
        return this.mSystemPropertyResolver;
    }

    public Optional<String> compareTo(XmlDocument other) {
        return this.getRootNode().compareTo(other.getRootNode());
    }

    static SourcePosition getNodePosition(XmlNode node) {
        return XmlDocument.getNodePosition(node.getXml());
    }

    static SourcePosition getNodePosition(Node xml) {
        return PositionXmlParser.getPosition((Node)xml);
    }

    public SourceFile getSourceFile() {
        return this.mSourceFile;
    }

    public synchronized XmlElement getRootNode() {
        if (this.mRootNode.get() == null) {
            this.mRootNode.set(new XmlElement(this.mRootElement, this));
        }
        return this.mRootNode.get();
    }

    public Optional<XmlElement> getByTypeAndKey(ManifestModel.NodeTypes type, String keyValue) {
        return this.getRootNode().getNodeByTypeAndKey(type, keyValue);
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public String getSplitName() {
        return this.mRootElement.getAttribute("split");
    }

    public Optional<XmlAttribute> getPackage() {
        Optional<XmlAttribute> packageAttribute = this.getRootNode().getAttribute(XmlNode.fromXmlName("package"));
        return packageAttribute.isPresent() ? packageAttribute : this.getRootNode().getAttribute(XmlNode.fromNSName("http://schemas.android.com/apk/res/android", "android", "package"));
    }

    public Document getXml() {
        return this.mRootElement.getOwnerDocument();
    }

    private String getExplicitMinSdkVersionOrDefault() {
        String value = this.getExplicitMinSdkVersion();
        return value != null ? value : DEFAULT_SDK_VERSION;
    }

    public String getMinSdkVersion() {
        String injectedMinSdk = this.mSystemPropertyResolver.getValue(ManifestSystemProperty.MIN_SDK_VERSION);
        if (injectedMinSdk != null) {
            return injectedMinSdk;
        }
        return this.getExplicitMinSdkVersionOrDefault();
    }

    private String getExplicitTargetSdkVersion() {
        return this.getExplicitVersionAttribute("android:targetSdkVersion");
    }

    private String getExplicitMaxSdkVersion() {
        return this.getExplicitVersionAttribute("android:maxSdkVersion");
    }

    private String getExplicitMinSdkVersion() {
        return this.getExplicitVersionAttribute("android:minSdkVersion");
    }

    private String getExplicitVersionAttribute(String attributeName) {
        Optional<XmlAttribute> specifiedVersion;
        Optional<XmlElement> usesSdk = this.getByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
        if (usesSdk.isPresent() && (specifiedVersion = usesSdk.get().getAttribute(XmlNode.fromXmlName(attributeName))).isPresent()) {
            return specifiedVersion.get().getValue();
        }
        return null;
    }

    private String getRawTargetSdkVersion() {
        String explicitTargetSdkVersion = this.getExplicitTargetSdkVersion();
        if (explicitTargetSdkVersion != null) {
            return explicitTargetSdkVersion;
        }
        return this.getExplicitMinSdkVersionOrDefault();
    }

    public String getTargetSdkVersion() {
        String injectedTargetVersion = this.mSystemPropertyResolver.getValue(ManifestSystemProperty.TARGET_SDK_VERSION);
        if (injectedTargetVersion != null) {
            return injectedTargetVersion;
        }
        return this.getRawTargetSdkVersion();
    }

    public String getMaxSdkVersion() {
        String injectedMaxVersion = this.mSystemPropertyResolver.getValue(ManifestSystemProperty.MAX_SDK_VERSION);
        if (injectedMaxVersion != null) {
            return injectedMaxVersion;
        }
        return this.getExplicitMaxSdkVersion();
    }

    boolean checkTopLevelDeclarations(Map<String, Object> placeHolderValues, MergingReport.Builder mergingReportBuilder, Type documentType) {
        Optional<XmlAttribute> mainPackageAttribute = this.getPackage();
        if (!placeHolderValues.containsKey("packageName") && documentType != Type.OVERLAY && !mainPackageAttribute.isPresent()) {
            mergingReportBuilder.addMessage(this.getSourceFile(), MergingReport.Record.Severity.ERROR, String.format("Main AndroidManifest.xml at %1$s manifest:package attribute is not declared", this.getSourceFile().print(true)));
            return false;
        }
        Optional<XmlElement> usesSdk = this.getByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
        if (usesSdk.isPresent()) {
            this.verifyVersion(usesSdk.get(), this::getExplicitMinSdkVersion, this::getMinSdkVersion, "minSdkVersion", mergingReportBuilder);
            this.verifyVersion(usesSdk.get(), this::getExplicitTargetSdkVersion, this::getTargetSdkVersion, "targetSdkVersion", mergingReportBuilder);
            this.verifyVersion(usesSdk.get(), this::getExplicitMaxSdkVersion, this::getMaxSdkVersion, "maxSdkVersion", mergingReportBuilder);
        }
        return true;
    }

    private void verifyVersion(XmlElement usesSdk, Supplier<String> rawValueSupplier, Supplier<String> usedValueSupplier, String propertyName, MergingReport.Builder mergingReportBuilder) {
        String rawValue = rawValueSupplier.get();
        if (rawValue != null && !rawValue.equals(usedValueSupplier.get())) {
            String warning = String.format("uses-sdk:%1$s value (%2$s) specified in the manifest file is ignored. It is overridden by the value declared in the DSL or the variant API, or 1 if not declared/present. Current value is (%3$s).", propertyName, rawValueSupplier.get(), usedValueSupplier.get());
            mergingReportBuilder.addMessage(new SourceFilePosition(this.getSourceFile(), usesSdk.getPosition()), MergingReport.Record.Severity.WARNING, warning);
        }
    }

    private static int getApiLevelFromAttribute(String attributeVersion) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)attributeVersion) ? 1 : 0) != 0);
        if (Character.isDigit(attributeVersion.charAt(0))) {
            return Integer.parseInt(attributeVersion);
        }
        return SdkVersionInfo.getApiByPreviewName((String)attributeVersion, (boolean)true);
    }

    private void addImplicitElements(XmlDocument lowerPriorityDocument, XmlDocument reparsedXmlDocument, MergingReport.Builder mergingReport, boolean addImplicitPermissions, boolean disableMinSdkVersionCheck) {
        XmlElement usesSdkElement;
        Optional<XmlElement> usesSdk = this.getByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
        if (this.mType == Type.OVERLAY && !usesSdk.isPresent()) {
            return;
        }
        if (usesSdk.isPresent() && (usesSdkElement = usesSdk.get()).getOperationType() != NodeOperationType.MERGE) {
            mergingReport.addMessage(new SourceFilePosition(this.getSourceFile(), usesSdkElement.getPosition()), MergingReport.Record.Severity.ERROR, "uses-sdk element cannot have a \"tools:node\" attribute");
            return;
        }
        int thisTargetSdk = XmlDocument.getApiLevelFromAttribute(this.getTargetSdkVersion());
        int libraryTargetSdk = XmlDocument.getApiLevelFromAttribute(lowerPriorityDocument.getFileType() == Type.LIBRARY ? lowerPriorityDocument.getRawTargetSdkVersion() : lowerPriorityDocument.getTargetSdkVersion());
        String libraryTargetSdkVersion = lowerPriorityDocument.getTargetSdkVersion();
        if (!Character.isDigit(libraryTargetSdkVersion.charAt(0)) && !libraryTargetSdkVersion.equals(this.getTargetSdkVersion()) && lowerPriorityDocument.getExplicitTargetSdkVersion() != null) {
            mergingReport.addMessage(this.getSourceFile(), MergingReport.Record.Severity.ERROR, String.format("uses-sdk:targetSdkVersion %1$s cannot be different than version %2$s declared in library %3$s", this.getTargetSdkVersion(), libraryTargetSdkVersion, lowerPriorityDocument.getSourceFile().print(false)));
            return;
        }
        String libraryMinSdkVersion = lowerPriorityDocument.getExplicitMinSdkVersionOrDefault();
        if (!Character.isDigit(libraryMinSdkVersion.charAt(0)) && !libraryMinSdkVersion.equals(this.getMinSdkVersion())) {
            mergingReport.addMessage(this.getSourceFile(), MergingReport.Record.Severity.ERROR, String.format("uses-sdk:minSdkVersion %1$s cannot be different than version %2$s declared in library %3$s", this.getMinSdkVersion(), libraryMinSdkVersion, lowerPriorityDocument.getSourceFile().print(false)));
            return;
        }
        if (!disableMinSdkVersionCheck && !this.checkUsesSdkMinVersion(lowerPriorityDocument)) {
            String error = String.format("uses-sdk:minSdkVersion %1$s cannot be smaller than version %2$s declared in library %3$s as the library might be using APIs not available in %1$s\n\tSuggestion: use a compatible library with a minSdk of at most %1$s,\n\t\tor increase this project's minSdk version to at least %2$s,\n\t\tor use tools:overrideLibrary=\"%4$s\" to force usage (may lead to runtime failures)", this.getMinSdkVersion(), lowerPriorityDocument.getExplicitMinSdkVersionOrDefault(), lowerPriorityDocument.getSourceFile().print(false), lowerPriorityDocument.getNamespace());
            if (usesSdk.isPresent()) {
                mergingReport.addMessage(new SourceFilePosition(this.getSourceFile(), usesSdk.get().getPosition()), MergingReport.Record.Severity.ERROR, error);
            } else {
                mergingReport.addMessage(this.getSourceFile(), MergingReport.Record.Severity.ERROR, error);
            }
            return;
        }
        if (thisTargetSdk <= libraryTargetSdk) {
            return;
        }
        if (thisTargetSdk < 4) {
            return;
        }
        if (!addImplicitPermissions) {
            return;
        }
        boolean hasWriteToExternalStoragePermission = lowerPriorityDocument.getByTypeAndKey(ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("WRITE_EXTERNAL_STORAGE")).isPresent();
        if (libraryTargetSdk < 4) {
            this.addIfAbsent(reparsedXmlDocument, mergingReport.getActionRecorder(), XmlDocument.permission("WRITE_EXTERNAL_STORAGE"), lowerPriorityDocument.getNamespace() + " has a targetSdkVersion < 4", new Pair[0]);
            hasWriteToExternalStoragePermission = true;
            this.addIfAbsent(reparsedXmlDocument, mergingReport.getActionRecorder(), XmlDocument.permission("READ_PHONE_STATE"), lowerPriorityDocument.getNamespace() + " has a targetSdkVersion < 4", new Pair[0]);
        }
        if (hasWriteToExternalStoragePermission) {
            this.addIfAbsent(reparsedXmlDocument, mergingReport.getActionRecorder(), XmlDocument.permission("READ_EXTERNAL_STORAGE"), lowerPriorityDocument.getNamespace() + " requested WRITE_EXTERNAL_STORAGE", new Pair[0]);
        }
        if (thisTargetSdk >= 16 && libraryTargetSdk < 16) {
            if (lowerPriorityDocument.getByTypeAndKey(ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("READ_CONTACTS")).isPresent()) {
                this.addIfAbsent(reparsedXmlDocument, mergingReport.getActionRecorder(), XmlDocument.permission("READ_CALL_LOG"), lowerPriorityDocument.getNamespace() + " has targetSdkVersion < 16 and requested READ_CONTACTS", new Pair[0]);
            }
            if (lowerPriorityDocument.getByTypeAndKey(ManifestModel.NodeTypes.USES_PERMISSION, XmlDocument.permission("WRITE_CONTACTS")).isPresent()) {
                this.addIfAbsent(reparsedXmlDocument, mergingReport.getActionRecorder(), XmlDocument.permission("WRITE_CALL_LOG"), lowerPriorityDocument.getNamespace() + " has targetSdkVersion < 16 and requested WRITE_CONTACTS", new Pair[0]);
            }
        }
    }

    private boolean checkUsesSdkMinVersion(XmlDocument lowerPriorityDocument) {
        int libraryMinSdk;
        int thisMinSdk = XmlDocument.getApiLevelFromAttribute(this.getMinSdkVersion());
        if (thisMinSdk < (libraryMinSdk = XmlDocument.getApiLevelFromAttribute(lowerPriorityDocument.getExplicitMinSdkVersionOrDefault()))) {
            Optional<XmlElement> xmlElementOptional = this.getByTypeAndKey(ManifestModel.NodeTypes.USES_SDK, null);
            if (!xmlElementOptional.isPresent()) {
                return false;
            }
            XmlElement xmlElement = xmlElementOptional.get();
            for (Selector selector : xmlElement.getOverrideUsesSdkLibrarySelectors()) {
                if (!selector.appliesTo(lowerPriorityDocument.getRootNode())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static String permission(String permissionName) {
        return "android.permission." + permissionName;
    }

    @SafeVarargs
    private final void addIfAbsent(XmlDocument reParsedXmlDocument, ActionRecorder actionRecorder, String keyValue, String reason, Pair<String, String> ... attributes) {
        Optional<XmlElement> xmlElementOptional = reParsedXmlDocument.getByTypeAndKey(ManifestModel.NodeTypes.USES_PERMISSION, keyValue);
        if (xmlElementOptional.isPresent()) {
            return;
        }
        Element elementNS = this.getXml().createElement(this.mModel.toXmlName(ManifestModel.NodeTypes.USES_PERMISSION));
        ImmutableList<String> keyAttributesNames = ManifestModel.NodeTypes.USES_PERMISSION.getNodeKeyResolver().getKeyAttributesNames();
        if (keyAttributesNames.size() == 1) {
            elementNS.setAttributeNS("http://schemas.android.com/apk/res/android", "android:" + (String)keyAttributesNames.get(0), keyValue);
        }
        if (attributes != null) {
            for (Pair<String, String> attribute : attributes) {
                elementNS.setAttributeNS("http://schemas.android.com/apk/res/android", "android:" + (String)attribute.getFirst(), (String)attribute.getSecond());
            }
        }
        XmlElement xmlElement = new XmlElement(elementNS, this);
        actionRecorder.recordImpliedNodeAction(xmlElement, reason);
        this.getRootNode().getXml().appendChild(elementNS);
    }

    public void clearNodeNamespaces() {
        this.clearNodeNamespaces(this.getRootNode().getXml());
    }

    private void clearNodeNamespaces(Element element) {
        String prefix;
        String androidPrefix = XmlUtils.lookupNamespacePrefix((Node)element, (String)"http://schemas.android.com/apk/res/android");
        String name = element.getNodeName();
        int colonIdx = name.indexOf(58);
        if (colonIdx != -1 && (prefix = name.substring(0, colonIdx)).equals(androidPrefix)) {
            String newName = name.substring(colonIdx + 1);
            this.getXml().renameNode(element, null, newName);
        }
        NodeList childrenNodeList = element.getChildNodes();
        for (int i = 0; i < childrenNodeList.getLength(); ++i) {
            Node n = childrenNodeList.item(i);
            if (!(n instanceof Element)) continue;
            this.clearNodeNamespaces((Element)n);
        }
    }

    public static enum Type {
        OVERLAY,
        MAIN,
        LIBRARY;

    }
}

