/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.wizard;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.wizard.FormProperty;
import com.intellij.uiDesigner.wizard.FormProperty2BeanProperty;
import com.intellij.uiDesigner.wizard.Generator;
import org.jetbrains.annotations.NotNull;

public final class WizardData {
    private static final Logger LOG = Logger.getInstance(WizardData.class);
    @NotNull
    public final Project myProject;
    @NotNull
    public final VirtualFile myFormFile;
    public boolean myBindToNewBean;
    public String myShortClassName;
    public String myPackageName;
    public PsiClass myBeanClass;
    public final FormProperty2BeanProperty @NotNull [] myBindings;
    public boolean myGenerateIsModified;

    public WizardData(@NotNull Project project, @NotNull VirtualFile formFile) throws Generator.MyException {
        if (project == null) {
            WizardData.$$$reportNull$$$0(0);
        }
        if (formFile == null) {
            WizardData.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFormFile = formFile;
        this.myBindToNewBean = true;
        this.myGenerateIsModified = true;
        LwRootContainer[] rootContainer = new LwRootContainer[1];
        FormProperty[] formProperties = Generator.exposeForm(this.myProject, this.myFormFile, rootContainer);
        this.myBindings = new FormProperty2BeanProperty[formProperties.length];
        for (int i = formProperties.length - 1; i >= 0; --i) {
            this.myBindings[i] = new FormProperty2BeanProperty(formProperties[i]);
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        VirtualFile directory = formFile.getParent();
        LOG.assertTrue(directory.isDirectory());
        PsiDirectory psiDirectory = manager.findDirectory(directory);
        LOG.assertTrue(psiDirectory != null);
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory);
        if (aPackage != null) {
            this.myPackageName = aPackage.getQualifiedName();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "formFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/uiDesigner/wizard/WizardData";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

