/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.AbstractLayout;
import com.intellij.uiDesigner.propertyInspector.properties.AbstractInsetsProperty;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.Insets;
import org.jetbrains.annotations.NotNull;

public final class MarginProperty
extends AbstractInsetsProperty<RadContainer> {
    private static final Insets DEFAULT_INSETS = new Insets(0, 0, 0, 0);

    public static MarginProperty getInstance(Project project) {
        return (MarginProperty)project.getService(MarginProperty.class);
    }

    public MarginProperty() {
        super("margins");
    }

    @Override
    public Insets getValue(RadContainer component) {
        if (component.getLayout() instanceof AbstractLayout) {
            AbstractLayout layoutManager = (AbstractLayout)component.getLayout();
            return layoutManager.getMargin();
        }
        return DEFAULT_INSETS;
    }

    @Override
    protected void setValueImpl(RadContainer component, @NotNull Insets value) throws Exception {
        if (value == null) {
            MarginProperty.$$$reportNull$$$0(0);
        }
        AbstractLayout layoutManager = (AbstractLayout)component.getLayout();
        layoutManager.setMargin(value);
    }

    @Override
    public boolean isModified(RadContainer component) {
        return !this.getValue(component).equals(DEFAULT_INSETS);
    }

    @Override
    public void resetValue(RadContainer component) throws Exception {
        this.setValueImpl(component, DEFAULT_INSETS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/uiDesigner/propertyInspector/properties/MarginProperty", "setValueImpl"));
    }
}

