/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.propertyInspector.properties.AbstractIntProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;

public class IndentProperty
extends AbstractIntProperty<RadComponent> {
    public static IndentProperty getInstance(Project project) {
        return (IndentProperty)project.getService(IndentProperty.class);
    }

    public IndentProperty() {
        super(null, "Indent", 0);
    }

    @Override
    public Integer getValue(RadComponent component) {
        return component.getConstraints().getIndent();
    }

    @Override
    protected void setValueImpl(RadComponent component, Integer value) throws Exception {
        int indent = value;
        GridConstraints constraints = component.getConstraints();
        if (constraints.getIndent() != indent) {
            GridConstraints oldConstraints = (GridConstraints)constraints.clone();
            constraints.setIndent(indent);
            component.fireConstraintsChanged(oldConstraints);
        }
    }
}

