/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.GuiFormFileType;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.ComponentItemDialog;
import com.intellij.uiDesigner.palette.GroupItem;
import com.intellij.uiDesigner.palette.Palette;
import java.awt.Window;
import java.util.HashMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddComponentAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AddComponentAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AddComponentAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        GroupItem groupItem = (GroupItem)e.getData(GroupItem.DATA_KEY);
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        PsiElement elementToAdd = psiFile != null ? AddComponentAction.findElementToAdd(psiFile) : null;
        String className = "";
        if (elementToAdd instanceof PsiClass) {
            className = ((PsiClass)elementToAdd).getQualifiedName();
            assert (className != null);
        } else if (elementToAdd instanceof PsiFile) {
            try {
                className = Utils.getBoundClassName((String)elementToAdd.getText());
            }
            catch (Exception e1) {
                className = "";
            }
        }
        ComponentItem itemToBeAdded = new ComponentItem(project, className, null, null, new GridConstraints(), new HashMap<String, StringDescriptor>(), true, false, false);
        Window parentWindow = WindowManager.getInstance().suggestParentWindow(project);
        ComponentItemDialog dialog = new ComponentItemDialog(project, parentWindow, itemToBeAdded, false);
        dialog.setTitle(UIDesignerBundle.message("title.add.component", new Object[0]));
        dialog.showGroupChooser(groupItem);
        if (!dialog.showAndGet()) {
            return;
        }
        groupItem = dialog.getSelectedGroup();
        if (groupItem.containsItemClass(itemToBeAdded.getClassName())) {
            return;
        }
        AddComponentAction.assignDefaultIcon(project, itemToBeAdded);
        Palette palette = Palette.getInstance(project);
        palette.addItem(groupItem, itemToBeAdded);
        palette.fireGroupsChanged();
    }

    private static void assignDefaultIcon(Project project, ComponentItem itemToBeAdded) {
        Palette palette = Palette.getInstance(project);
        if (itemToBeAdded.getIconPath() == null || itemToBeAdded.getIconPath().length() == 0) {
            for (PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(itemToBeAdded.getClassName().replace('$', '.'), ProjectScope.getAllScope((Project)project)); aClass != null; aClass = aClass.getSuperClass()) {
                String iconPath;
                ComponentItem item;
                String name = aClass.getQualifiedName();
                ComponentItem componentItem = item = name == null ? null : palette.getItem(name);
                if (item == null || (iconPath = item.getIconPath()) == null || iconPath.length() <= 0) continue;
                itemToBeAdded.setIconPath(iconPath);
                return;
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddComponentAction.$$$reportNull$$$0(2);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (e.getData(GroupItem.DATA_KEY) != null || e.getData(ComponentItem.DATA_KEY) != null) {
            e.getPresentation().setVisible(true);
            GroupItem groupItem = (GroupItem)e.getData(GroupItem.DATA_KEY);
            e.getPresentation().setEnabled(project != null && (groupItem == null || !groupItem.isReadOnly()));
        } else {
            PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            e.getPresentation().setVisible(psiFile != null && AddComponentAction.findElementToAdd(psiFile) != null);
        }
    }

    @Nullable
    private static PsiElement findElementToAdd(PsiFile psiFile) {
        if (psiFile.getFileType().equals(GuiFormFileType.INSTANCE)) {
            return psiFile;
        }
        if (psiFile.getFileType().equals(JavaFileType.INSTANCE)) {
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getChildOfType((PsiElement)psiFile, PsiClass.class);
            Project project = psiFile.getProject();
            PsiClass componentClass = JavaPsiFacade.getInstance((Project)project).findClass(JComponent.class.getName(), ProjectScope.getAllScope((Project)project));
            if (psiClass != null && componentClass != null && psiClass.isInheritor(componentClass, true) && psiClass.getQualifiedName() != null) {
                return psiClass;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/palette/AddComponentAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/palette/AddComponentAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

