/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.configuration;

import com.intellij.execution.JUnitBundle;
import com.intellij.execution.MethodBrowser;
import com.intellij.execution.application.ClassEditorField;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.TestMethod;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit2.configuration.JUnitConfigurable;
import com.intellij.execution.junit2.configuration.JUnitConfigurationModel;
import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitTestKindFragment
extends SettingsEditorFragment<JUnitConfiguration, JPanel> {
    private final JUnitConfigurationModel myModel;
    private final ConfigurationModuleSelector myModuleSelector;
    private final ComboBox<Integer> myTypeChooser;
    private final JComponent[] myFields = new JComponent[10];
    private final Map<JComponent, String> myHints = new HashMap<JComponent, String>();
    private final RawCommandLineEditor myUniqueIdField;
    private final RawCommandLineEditor myTagsField;
    private final ComboBox<String> myChangeLists;

    public JUnitTestKindFragment(Project project, ConfigurationModuleSelector moduleSelector) {
        super("junit.test.kind", null, null, (JComponent)new JPanel(new GridBagLayout()), 90, null, null, configuration -> true);
        this.myModel = new JUnitConfigurationModel(project);
        this.myModel.setListener((oldKind, kind) -> this.kindChanged((int)oldKind, (int)kind));
        this.myModuleSelector = moduleSelector;
        this.myTypeChooser = new ComboBox();
        CommandLinePanel.setMinimumWidth((Component)this.component(), (int)500);
        ((JPanel)this.component()).add((Component)this.myTypeChooser, new GridBagConstraints());
        this.myModel.reloadTestKindModel((JComboBox<Integer>)this.myTypeChooser, this.myModuleSelector.getModule());
        this.myTypeChooser.addActionListener(e -> this.myModel.setType((Integer)this.myTypeChooser.getItem()));
        this.myTypeChooser.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", value -> JUnitConfigurationModel.getKindName(value)));
        EditorTextFieldWithBrowseButton packageField = new EditorTextFieldWithBrowseButton(project, false);
        TextFieldWithBrowseButton pattern = new TextFieldWithBrowseButton((JTextField)new ExpandableTextField(text -> Arrays.asList(text.split("\\|\\|")), strings -> StringUtil.join((Collection)strings, (String)"||")));
        pattern.setButtonIcon(IconUtil.getAddIcon());
        EditorTextFieldWithBrowseButton category = new EditorTextFieldWithBrowseButton(project, true, new JavaCodeFragment.VisibilityChecker(){

            public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
                if (declaration instanceof PsiClass) {
                    return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
                }
                return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
            }
        });
        TextFieldWithBrowseButton directoryField = new TextFieldWithBrowseButton();
        FileChooserDescriptor dirFileChooser = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        dirFileChooser.setHideIgnored(false);
        InsertPathAction.addTo((JTextComponent)directoryField.getTextField(), (FileChooserDescriptor)dirFileChooser);
        FileChooserFactory.getInstance().installFileCompletion(directoryField.getTextField(), dirFileChooser, true, null);
        BrowseModuleValueActionListener[] browsers = JUnitConfigurable.createBrowsers(project, moduleSelector, packageField, pattern, category, () -> this.getClassName());
        JavaCodeFragment.VisibilityChecker classVisibilityChecker = JUnitConfigurable.createClassVisibilityChecker((JUnitConfigurable.TestClassBrowser)browsers[1]);
        ClassEditorField classField = ClassEditorField.createClassField((Project)project, () -> moduleSelector.getModule(), (JavaCodeFragment.VisibilityChecker)classVisibilityChecker, (BrowseModuleValueActionListener)browsers[1]);
        EditorTextFieldWithBrowseButton methodField = new EditorTextFieldWithBrowseButton(project, true, JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE, (FileType)PlainTextLanguage.INSTANCE.getAssociatedFileType());
        this.myHints.put((JComponent)this.myTypeChooser, JUnitBundle.message("test.kind.hint", new Object[0]));
        this.setupField(0, (JComponent)packageField, ((EditorTextField)packageField.getChildComponent()).getDocument(), browsers[0], JUnitBundle.message("test.package.hint", new Object[0]));
        this.setupField(1, (JComponent)classField, classField.getDocument(), null, JUnitBundle.message("test.class.hint", new Object[0]));
        ((MethodBrowser)browsers[2]).installCompletion((EditorTextField)methodField.getChildComponent());
        this.setupField(2, (JComponent)methodField, ((EditorTextField)methodField.getChildComponent()).getDocument(), browsers[2], JUnitBundle.message("test.method.hint", new Object[0]));
        this.setupField(3, (JComponent)pattern, pattern.getTextField().getDocument(), browsers[3], JUnitBundle.message("test.pattern.hint", new Object[0]));
        this.setupField(4, (JComponent)directoryField, directoryField.getTextField().getDocument(), browsers[4], null);
        this.setupField(5, (JComponent)category, ((EditorTextField)category.getChildComponent()).getDocument(), browsers[5], null);
        this.myUniqueIdField = new RawCommandLineEditor(text -> Arrays.asList(text.split("\u001b")), strings -> StringUtil.join((Collection)strings, (String)"\u001b"));
        this.setupField(6, (JComponent)this.myUniqueIdField, null, null, null);
        this.myTagsField = new RawCommandLineEditor();
        this.setupField(7, (JComponent)this.myTagsField, null, null, null);
        this.myChangeLists = new ComboBox();
        JUnitConfigurable.setupChangeLists(project, this.myChangeLists);
        this.setupField(9, (JComponent)this.myChangeLists, null, null, null);
        this.setupField(8, new JLabel(), null, null, null);
        this.setValidation(configuration -> {
            JComponent component;
            ArrayList<ValidationInfo> infos = new ArrayList<ValidationInfo>();
            TestObject testObject = configuration.getTestObject();
            JComponent field = this.myFields[this.getTestKind()];
            JComponent jComponent = component = field instanceof ComponentWithBrowseButton ? ((ComponentWithBrowseButton)field).getChildComponent() : field;
            if (testObject instanceof TestMethod) {
                ValidationInfo info = RuntimeConfigurationException.validate((JComponent)this.myFields[1], () -> ((TestMethod)testObject).checkClass());
                infos.add(info);
                if (!info.message.isEmpty()) {
                    infos.add(new ValidationInfo("", component));
                    return infos;
                }
            }
            infos.add(RuntimeConfigurationException.validate((JComponent)component, () -> testObject.checkConfiguration()));
            return infos;
        });
    }

    public JComponent[] getAllComponents() {
        return (JComponent[])ArrayUtil.append((Object[])this.myFields, this.myTypeChooser);
    }

    public int getTestKind() {
        Integer item = (Integer)this.myTypeChooser.getItem();
        return item == null ? 0 : item;
    }

    public boolean disableModuleClasspath(boolean wholeProjectSelected) {
        return this.myModel.disableModuleClasspath(wholeProjectSelected);
    }

    private <T extends JComponent> void setupField(int kind, JComponent field, @Nullable Object document, @Nullable BrowseModuleValueActionListener<T> browser, @Nls String hint) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        ((JPanel)this.component()).add((Component)field, constraints);
        this.myFields[kind] = field;
        this.myHints.put(field, hint);
        if (browser != null) {
            browser.setField((ComponentWithBrowseButton)field);
        }
        if (document != null) {
            this.myModel.setJUnitDocument(kind, document);
        }
    }

    @Nullable
    public String getHint(@Nullable JComponent component) {
        return component == null ? null : this.myHints.get(component);
    }

    private void kindChanged(int oldKind, int kind) {
        this.myTypeChooser.setItem((Object)kind);
        Arrays.stream(this.myFields).forEach(field -> field.setVisible(false));
        this.myFields[kind].setVisible(true);
        if (2 == kind) {
            this.myFields[1].setVisible(true);
        }
        if (3 == kind && (oldKind == 1 || oldKind == 2) && StringUtil.isEmpty((String)((TextAccessor)this.myFields[3]).getText())) {
            ((TextAccessor)this.myFields[3]).setText(this.getClassName());
        }
        this.fireEditorStateChanged();
    }

    private String getClassName() {
        return ((TextAccessor)this.myFields[1]).getText();
    }

    protected void resetEditorFrom(@NotNull JUnitConfiguration s) {
        String[] ids;
        if (s == null) {
            JUnitTestKindFragment.$$$reportNull$$$0(0);
        }
        this.myUniqueIdField.setText((ids = s.getPersistentData().getUniqueIds()) != null ? StringUtil.join((String[])ids, (String)"\u001b") : null);
        this.myTagsField.setText(s.getPersistentData().getTags());
        this.myChangeLists.setSelectedItem((Object)s.getPersistentData().getChangeList());
        this.myModel.reset(s);
    }

    protected void applyEditorTo(@NotNull JUnitConfiguration s) {
        if (s == null) {
            JUnitTestKindFragment.$$$reportNull$$$0(1);
        }
        s.getPersistentData().setUniqueIds(JUnitConfigurable.setArrayFromText(this.myUniqueIdField.getText()));
        s.getPersistentData().setTags(this.myTagsField.getText());
        s.getPersistentData().setChangeList((String)this.myChangeLists.getItem());
        this.myModel.apply(this.myModuleSelector.getModule(), s);
        this.validate((Object)s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "s";
        objectArray2[1] = "com/intellij/execution/junit2/configuration/JUnitTestKindFragment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

