/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.model.DomModel;
import com.intellij.util.xml.model.MultipleDomModelFactory;
import com.intellij.util.xml.model.SimpleModelFactory;
import com.intellij.util.xml.model.impl.DomModelFactoryHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDomModelFactory<S extends UserDataHolder, T extends DomElement, M extends DomModel<T>, C extends PsiElement>
extends DomModelFactoryHelper<T>
implements SimpleModelFactory<T, M>,
MultipleDomModelFactory<S, T, M> {
    private final Project myProject;

    protected BaseDomModelFactory(@NotNull Class<T> aClass, Project project, @NonNls String name) {
        if (aClass == null) {
            BaseDomModelFactory.$$$reportNull$$$0(0);
        }
        super(aClass, DomService.getInstance().createModelMerger());
        this.myProject = project;
    }

    @Nullable
    public M getModel(@NotNull C context) {
        PsiFile psiFile;
        if (context == null) {
            BaseDomModelFactory.$$$reportNull$$$0(1);
        }
        if ((psiFile = context.getContainingFile()) instanceof XmlFile) {
            return this.getModelByConfigFile((XmlFile)psiFile);
        }
        return null;
    }

    @Nullable
    protected M computeModel(@NotNull XmlFile psiFile, @Nullable S scope) {
        if (psiFile == null) {
            BaseDomModelFactory.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            return null;
        }
        List<M> models = this.getAllModels(scope);
        for (DomModel model : models) {
            Set<XmlFile> configFiles = model.getConfigFiles();
            if (!configFiles.contains(psiFile)) continue;
            return (M)model;
        }
        return null;
    }

    @Override
    @Nullable
    public M getModelByConfigFile(@Nullable XmlFile file) {
        if (file == null) {
            return null;
        }
        XmlFile originalFile = (XmlFile)file.getOriginalFile();
        S scope = this.getModelScope(originalFile);
        return this.computeModel(originalFile, scope);
    }

    @Override
    @Nullable
    public DomFileElement<T> createMergedModelRoot(Set<? extends XmlFile> configFiles) {
        ArrayList configs = new ArrayList(configFiles.size());
        for (XmlFile xmlFile : configFiles) {
            ContainerUtil.addIfNotNull(configs, this.getDomRoot(xmlFile));
        }
        return configs.isEmpty() ? null : this.getModelMerger().mergeModels(DomFileElement.class, configs);
    }

    protected abstract S getModelScope(XmlFile var1);

    @Nullable
    protected abstract List<M> computeAllModels(@NotNull S var1);

    protected abstract M createCombinedModel(Set<XmlFile> var1, DomFileElement<T> var2, M var3, S var4);

    @Override
    @NotNull
    public List<M> getAllModels(@NotNull S s) {
        List<M> models;
        if (s == null) {
            BaseDomModelFactory.$$$reportNull$$$0(3);
        }
        List<Object> list = (models = this.computeAllModels(s)) == null ? Collections.emptyList() : models;
        if (list == null) {
            BaseDomModelFactory.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public Set<XmlFile> getAllConfigFiles(@NotNull S scope) {
        if (scope == null) {
            BaseDomModelFactory.$$$reportNull$$$0(5);
        }
        HashSet<XmlFile> xmlFiles = new HashSet<XmlFile>();
        for (DomModel model : this.getAllModels(scope)) {
            xmlFiles.addAll(model.getConfigFiles());
        }
        return xmlFiles;
    }

    @Override
    @Nullable
    public M getCombinedModel(@Nullable S s) {
        if (s == null) {
            return null;
        }
        List<M> models = this.getAllModels(s);
        switch (models.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (M)((DomModel)models.get(0));
            }
        }
        LinkedHashSet<XmlFile> configFiles = new LinkedHashSet<XmlFile>();
        LinkedHashSet list = new LinkedHashSet(models.size());
        for (DomModel model : models) {
            Set<XmlFile> files = model.getConfigFiles();
            for (XmlFile file : files) {
                ContainerUtil.addIfNotNull(list, this.getDomRoot(file));
            }
            configFiles.addAll(files);
        }
        DomFileElement mergedModel = this.getModelMerger().mergeModels(DomFileElement.class, list);
        DomModel firstModel = (DomModel)models.get(0);
        return (M)this.createCombinedModel(configFiles, mergedModel, firstModel, s);
    }

    protected Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/model/impl/BaseDomModelFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/model/impl/BaseDomModelFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllModels";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllConfigFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

