/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils.cxx;

import com.android.utils.cxx.Sections;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\n \u000b*\u0004\u0018\u00010\u00190\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\n \u000b*\u0004\u0018\u00010\u00190\u00192\u0006\u0010)\u001a\u00020\u0005H\u0002J\u0010\u0010*\u001a\n \u000b*\u0004\u0018\u00010\u00190\u0019H\u0002J\b\u0010+\u001a\u00020$H\u0002J\u0010\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020!H\u0002J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0005H\u0002J\b\u00100\u001a\u00020$H\u0002J\u0012\u00101\u001a\u00020\u00052\b\u0010-\u001a\u0004\u0018\u00010!H\u0002J\u0016\u00101\u001a\u00020\u00052\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eH\u0002J<\u00103\u001a\u00020$2\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\f\u00106\u001a\b\u0012\u0004\u0012\u00020!0\u001e2\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020!J\u0010\u0010:\u001a\u00020\b2\u0006\u0010;\u001a\u00020<H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u000b*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u000b*\u0004\u0018\u00010\u00190\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001c\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u001e\u0012\u0004\u0012\u00020\u00050\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00050\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/android/utils/cxx/CompileCommandsEncoder;", "Ljava/lang/AutoCloseable;", "file", "Ljava/io/File;", "initialBufferSize", "", "(Ljava/io/File;I)V", "bufferStartPosition", "", "channel", "Ljava/nio/channels/FileChannel;", "kotlin.jvm.PlatformType", "compileCommandsIndexEntry", "countOfSourceFiles", "countOfSourceMessages", "countOfSourceMessagesOffset", "getFile", "()Ljava/io/File;", "lastCompilerWritten", "lastFlagsWritten", "lastTargetWritten", "lastWorkingDirectoryWritten", "lock", "Ljava/nio/channels/FileLock;", "map", "Ljava/nio/ByteBuffer;", "ras", "Ljava/io/RandomAccessFile;", "stringListTable", "", "", "stringListsIndexEntry", "stringTable", "", "stringTableIndexEntry", "close", "", "encodeByte", "byte", "", "encodeInt", "int", "encodeLongZero", "encodeMagic", "encodeUTF8", "string", "ensureAtLeast", "bytes", "flushBuffer", "intern", "strings", "writeCompileCommand", "sourceFile", "compiler", "flags", "workingDirectory", "outputFile", "target", "writeSectionIndexEntry", "section", "Lcom/android/utils/cxx/Sections;", "android.sdktools.common"})
public final class CompileCommandsEncoder
implements AutoCloseable {
    @NotNull
    private final File file;
    @NotNull
    private final RandomAccessFile ras;
    private final FileChannel channel;
    private final FileLock lock;
    private long bufferStartPosition;
    private ByteBuffer map;
    private final long stringTableIndexEntry;
    private final long stringListsIndexEntry;
    private final long compileCommandsIndexEntry;
    private final long countOfSourceMessagesOffset;
    @NotNull
    private final Map<String, Integer> stringTable;
    @NotNull
    private final Map<List<Integer>, Integer> stringListTable;
    private int countOfSourceMessages;
    private int lastCompilerWritten;
    private int lastFlagsWritten;
    private int lastTargetWritten;
    private int lastWorkingDirectoryWritten;
    private int countOfSourceFiles;

    public CompileCommandsEncoder(@NotNull File file2, int initialBufferSize) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.file = file2;
        this.ras = new RandomAccessFile(this.file, "rw");
        this.channel = this.ras.getChannel();
        this.lock = this.channel.lock();
        this.map = ByteBuffer.allocate(initialBufferSize);
        boolean bl = false;
        this.stringTable = new LinkedHashMap();
        bl = false;
        this.stringListTable = new LinkedHashMap();
        this.lastCompilerWritten = -1;
        this.lastFlagsWritten = -1;
        this.lastTargetWritten = -1;
        this.lastWorkingDirectoryWritten = -1;
        this.encodeMagic();
        this.encodeInt(3);
        this.encodeInt(3);
        this.compileCommandsIndexEntry = this.writeSectionIndexEntry(Sections.CompileCommands);
        this.stringTableIndexEntry = this.writeSectionIndexEntry(Sections.StringTable);
        this.stringListsIndexEntry = this.writeSectionIndexEntry(Sections.StringLists);
        this.countOfSourceMessagesOffset = this.ras.getFilePointer() + (long)this.map.position();
        this.encodeInt(0);
        this.encodeInt(0);
    }

    public /* synthetic */ CompileCommandsEncoder(File file2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 32768;
        }
        this(file2, n);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    private final void encodeMagic() {
        String string = "C/C++ Build Metadata\u001a";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        ByteBuffer map = this.ensureAtLeast(bytes.length);
        map.put(bytes);
    }

    private final void encodeUTF8(String string) {
        String string2 = string;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        ByteBuffer map = this.ensureAtLeast(4 + bytes.length);
        map.putInt(bytes.length);
        map.put(bytes);
    }

    private final ByteBuffer encodeByte(byte by) {
        return this.ensureAtLeast(1).put(by);
    }

    private final ByteBuffer encodeInt(int n) {
        return this.ensureAtLeast(4).putInt(n);
    }

    private final ByteBuffer encodeLongZero() {
        return this.ensureAtLeast(8).putLong(0L);
    }

    private final ByteBuffer ensureAtLeast(int bytes) {
        if (this.map.capacity() < this.map.position() + bytes) {
            this.flushBuffer();
            if (this.map.capacity() < bytes) {
                this.map = ByteBuffer.allocate(bytes);
            }
        }
        ByteBuffer byteBuffer = this.map;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"map");
        return byteBuffer;
    }

    private final void flushBuffer() {
        if (this.map.position() == 0) {
            return;
        }
        this.ras.seek(this.bufferStartPosition);
        this.ras.write(this.map.array(), 0, this.map.position());
        Object object = this;
        ((CompileCommandsEncoder)object).bufferStartPosition += (long)this.map.position();
        object = this.map;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)object).clear();
    }

    private final int intern(String string) {
        Integer n = string == null ? Integer.valueOf(0) : this.stringTable.computeIfAbsent(string, new Function(this){
            final /* synthetic */ CompileCommandsEncoder this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final Integer apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CompileCommandsEncoder.access$getStringTable$p(this.this$0).size() + 1;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"private fun intern(strin\u2026ve 0 for 'null'\n        }");
        return ((Number)n).intValue();
    }

    private final int intern(List<Integer> strings) {
        Integer n = this.stringListTable.computeIfAbsent(strings, new Function(this){
            final /* synthetic */ CompileCommandsEncoder this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final Integer apply(@NotNull List<Integer> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return CompileCommandsEncoder.access$getStringListTable$p(this.this$0).size();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"private fun intern(strin\u2026tringListTable.size\n    }");
        return ((Number)n).intValue();
    }

    private final long writeSectionIndexEntry(Sections section) {
        long result = this.ras.getFilePointer() + (long)this.map.position();
        this.encodeInt(section.ordinal());
        this.encodeLongZero();
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeCompileCommand(@NotNull File sourceFile, @NotNull File compiler, @NotNull List<String> flags, @NotNull File workingDirectory, @NotNull File outputFile, @NotNull String target) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int compilerIndex = this.intern(compiler.getPath());
        Iterable iterable = flags;
        CompileCommandsEncoder compileCommandsEncoder = this;
        boolean $i$f$map = false;
        CompileCommandsEncoder compileCommandsEncoder2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Integer n = this.intern((String)it);
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        int flagsIndex = compileCommandsEncoder.intern((List<Integer>)collection);
        int workingDirectoryIndex = this.intern(workingDirectory.getPath());
        int targetIndex = this.intern(target);
        if (compilerIndex != this.lastCompilerWritten || flagsIndex != this.lastFlagsWritten || workingDirectoryIndex != this.lastWorkingDirectoryWritten || targetIndex != this.lastTargetWritten) {
            this.encodeByte((byte)0);
            this.encodeInt(compilerIndex);
            this.encodeInt(flagsIndex);
            this.encodeInt(workingDirectoryIndex);
            this.encodeInt(targetIndex);
            this.lastCompilerWritten = compilerIndex;
            this.lastFlagsWritten = flagsIndex;
            this.lastWorkingDirectoryWritten = workingDirectoryIndex;
            this.lastTargetWritten = targetIndex;
            compileCommandsEncoder2 = this;
            ++compileCommandsEncoder2.countOfSourceMessages;
            int cfr_ignored_0 = compileCommandsEncoder2.countOfSourceMessages;
        }
        this.encodeByte((byte)1);
        this.encodeInt(this.intern(sourceFile.getPath()));
        this.encodeInt(this.intern(outputFile.getPath()));
        compileCommandsEncoder2 = this;
        ++compileCommandsEncoder2.countOfSourceMessages;
        int cfr_ignored_1 = compileCommandsEncoder2.countOfSourceMessages;
        compileCommandsEncoder2 = this;
        ++compileCommandsEncoder2.countOfSourceFiles;
        int cfr_ignored_2 = compileCommandsEncoder2.countOfSourceFiles;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void $this$forEach$iv;
        Iterable $this$sortedBy$iv;
        long offsetOfStringTable = this.bufferStartPosition + (long)this.map.position();
        this.encodeInt(this.stringTable.size());
        Iterable $this$sortedBy$iv2 = MapsKt.toList(this.stringTable);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Iterable $this$forEach$iv2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair $dstr$_u24__u24$index = (Pair)a;
                boolean bl2 = false;
                int index = ((Number)$dstr$_u24__u24$index.component2()).intValue();
                $dstr$_u24__u24$index = (Pair)b;
                Comparable comparable = Integer.valueOf(index);
                bl2 = false;
                index = ((Number)$dstr$_u24__u24$index.component2()).intValue();
                Integer n = index;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            Pair $dstr$string$_u24__u24 = (Pair)element$iv;
            boolean bl2 = false;
            String string = (String)$dstr$string$_u24__u24.component1();
            this.encodeUTF8(string);
        }
        long offsetOfStringListsTable = this.bufferStartPosition + (long)this.map.position();
        this.encodeInt(this.stringListTable.size());
        Iterable iterable = MapsKt.toList(this.stringListTable);
        boolean $i$f$sortedBy2 = false;
        boolean bl3 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair $dstr$_u24__u24$index = (Pair)a;
                boolean bl2 = false;
                int index = ((Number)$dstr$_u24__u24$index.component2()).intValue();
                $dstr$_u24__u24$index = (Pair)b;
                Comparable comparable = Integer.valueOf(index);
                bl2 = false;
                index = ((Number)$dstr$_u24__u24$index.component2()).intValue();
                Integer n = index;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        });
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair $dstr$strings$_u24__u24 = (Pair)element$iv;
            boolean bl4 = false;
            List strings = (List)$dstr$strings$_u24__u24.component1();
            this.encodeInt(strings.size());
            Iterable $this$forEach$iv3 = strings;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                int id = ((Number)element$iv2).intValue();
                boolean bl5 = false;
                this.encodeInt(id);
            }
        }
        this.flushBuffer();
        this.map = null;
        this.ras.seek(this.countOfSourceMessagesOffset);
        this.ras.writeInt(this.countOfSourceMessages);
        this.ras.writeInt(this.countOfSourceFiles);
        this.ras.seek(this.compileCommandsIndexEntry + (long)4);
        this.ras.writeLong(this.countOfSourceMessagesOffset);
        this.ras.seek(this.stringTableIndexEntry + (long)4);
        this.ras.writeLong(offsetOfStringTable);
        this.ras.seek(this.stringListsIndexEntry + (long)4);
        this.ras.writeLong(offsetOfStringListsTable);
        this.ras.getFD().sync();
        this.lock.close();
        this.channel.close();
        this.ras.close();
    }

    public static final /* synthetic */ Map access$getStringTable$p(CompileCommandsEncoder $this) {
        return $this.stringTable;
    }

    public static final /* synthetic */ Map access$getStringListTable$p(CompileCommandsEncoder $this) {
        return $this.stringListTable;
    }
}

