/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.CharSequenceReader;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CharSequences {
    public static int indexOf(CharSequence sequence, char c) {
        return CharSequences.indexOf(sequence, c, 0);
    }

    public static int indexOf(CharSequence sequence, char c, int start) {
        for (int i = start; i < sequence.length(); ++i) {
            if (sequence.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence haystack, String needle, int start) {
        int length = haystack.length();
        int needleLength = needle.length();
        if (needleLength <= length && start >= 0) {
            if (needleLength > 0) {
                if (start > length - needleLength) {
                    start = length - needleLength;
                }
                char firstChar = needle.charAt(0);
                while (true) {
                    int i;
                    if ((i = CharSequences.lastIndexOf(haystack, firstChar, start)) == -1) {
                        return -1;
                    }
                    int o1 = i;
                    int o2 = 0;
                    while (++o2 < needleLength && haystack.charAt(++o1) == needle.charAt(o2)) {
                    }
                    if (o2 == needleLength) {
                        return i;
                    }
                    start = i - 1;
                }
            }
            return start < length ? start : length;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence sequence, char c) {
        return CharSequences.lastIndexOf(sequence, c, sequence.length());
    }

    public static int lastIndexOf(CharSequence sequence, int c, int start) {
        int length = sequence.length();
        if (start >= 0) {
            if (start >= length) {
                start = length - 1;
            }
            for (int i = start; i >= 0; --i) {
                if (sequence.charAt(i) != c) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence haystack, String needle) {
        return CharSequences.lastIndexOf(haystack, needle, haystack.length());
    }

    public static boolean regionMatches(CharSequence sequence, int thisStart, CharSequence string, int start, int length) {
        if (start < 0 || string.length() - start < length) {
            return false;
        }
        if (thisStart < 0 || sequence.length() - thisStart < length) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (sequence.charAt(thisStart + i) == string.charAt(start + i)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence sequence, boolean ignoreCase, int thisStart, CharSequence string, int start, int length) {
        if (!ignoreCase) {
            return CharSequences.regionMatches(sequence, thisStart, string, start, length);
        }
        if (thisStart < 0 || length > sequence.length() - thisStart) {
            return false;
        }
        if (start < 0 || length > string.length() - start) {
            return false;
        }
        int end = thisStart + length;
        while (thisStart < end) {
            char c2;
            char c1;
            if ((c1 = sequence.charAt(thisStart++)) == (c2 = string.charAt(start++)) || CharSequences.foldCase(c1) == CharSequences.foldCase(c2)) continue;
            return false;
        }
        return true;
    }

    private static char foldCase(char ch) {
        if (ch < '\u0080') {
            if ('A' <= ch && ch <= 'Z') {
                return (char)(ch + 32);
            }
            return ch;
        }
        return Character.toLowerCase(Character.toUpperCase(ch));
    }

    public static boolean startsWith(CharSequence sequence, CharSequence prefix) {
        return CharSequences.startsWith(sequence, prefix, 0);
    }

    public static boolean startsWith(CharSequence sequence, CharSequence prefix, int start) {
        int prefixLength;
        int sequenceLength = sequence.length();
        if (sequenceLength < start + (prefixLength = prefix.length())) {
            return false;
        }
        int i = start;
        for (int j = 0; j < prefixLength; ++j) {
            if (sequence.charAt(i) != prefix.charAt(j)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean endsWith(CharSequence sequence, CharSequence suffix, boolean caseSensitive) {
        if (suffix.length() > sequence.length()) {
            return false;
        }
        int suffixLength = suffix.length();
        int sequenceLength = sequence.length();
        int i = sequenceLength - suffixLength;
        int j = 0;
        while (i < sequenceLength) {
            char c2;
            char c1 = sequence.charAt(i);
            if (c1 != (c2 = suffix.charAt(j))) {
                if (caseSensitive) {
                    return false;
                }
                if (Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean containsUpperCase(CharSequence s) {
        if (s != null) {
            int n = s.length();
            for (int i = 0; i < n; ++i) {
                if (!Character.isUpperCase(s.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static int indexOf(CharSequence haystack, CharSequence needle) {
        return CharSequences.indexOf(haystack, needle, 0);
    }

    public static int indexOf(CharSequence haystack, CharSequence needle, int start) {
        int needleLength = needle.length();
        if (needleLength == 0) {
            return start;
        }
        char first = needle.charAt(0);
        if (needleLength == 1) {
            return CharSequences.indexOf(haystack, first, start);
        }
        int max = haystack.length() - needleLength;
        block0: for (int i = start; i <= max; ++i) {
            if (haystack.charAt(i) != first) continue;
            int h = i + 1;
            for (int n = 1; n < needleLength; ++n) {
                if (haystack.charAt(h) != needle.charAt(n)) continue block0;
                ++h;
            }
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence where, CharSequence what, int fromIndex) {
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!CharSequences.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !CharSequences.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && CharSequences.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    private static boolean charsEqualIgnoreCase(char c1, char c2) {
        return CharSequences.toUpperCase(c1) == CharSequences.toUpperCase(c2) || CharSequences.toLowerCase(c1) == CharSequences.toLowerCase(c2);
    }

    public static char toUpperCase(char c) {
        if (c < 'a') {
            return c;
        }
        if (c <= 'z') {
            return (char)(c + -32);
        }
        return Character.toUpperCase(c);
    }

    public static char toLowerCase(char c) {
        if (c < 'A' || c >= 'a' && c <= 'z') {
            return c;
        }
        if (c <= 'Z') {
            return (char)(c + 32);
        }
        return Character.toLowerCase(c);
    }

    public static CharSequence createSequence(char[] data) {
        return new ArrayBackedCharSequence(data);
    }

    public static CharSequence createSequence(char[] data, int offset, int length) {
        return new ArrayBackedCharSequence(data, offset, length);
    }

    public static char[] getCharArray(CharSequence sequence) {
        if (sequence instanceof ArrayBackedCharSequence) {
            return ((ArrayBackedCharSequence)sequence).getCharArray();
        }
        return sequence.toString().toCharArray();
    }

    public static CharSequenceReader getReader(CharSequence data, boolean stripBom) {
        CharSequenceReader reader = new CharSequenceReader(data);
        if (stripBom && data.length() > 0 && data.charAt(0) == '\ufeff') {
            reader.read();
        }
        return reader;
    }

    public static Document parseDocumentSilently(CharSequence xml, boolean namespaceAware) {
        try {
            CharSequenceReader reader = CharSequences.getReader(xml, true);
            return XmlUtils.parseDocument(reader, namespaceAware);
        }
        catch (IOException | SAXException exception) {
            return null;
        }
    }

    public static InputStream getInputStream(CharSequence text) {
        return new ByteArrayInputStream(text.toString().getBytes(Charsets.UTF_8));
    }

    private static class ArrayBackedCharSequence
    implements CharSequence {
        public final char[] data;
        private final int offset;
        private final int length;

        public ArrayBackedCharSequence(char[] data) {
            this(data, 0, data.length);
        }

        public ArrayBackedCharSequence(char[] data, int offset, int length) {
            this.data = data;
            this.offset = offset;
            this.length = length;
        }

        public char[] getCharArray() {
            if (this.offset == 0 && this.length == this.data.length) {
                return this.data;
            }
            return Arrays.copyOfRange(this.data, this.offset, this.offset + this.length);
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.data[this.offset + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new ArrayBackedCharSequence(this.data, this.offset + start, end - start);
        }

        @Override
        public String toString() {
            return new String(this.data, this.offset, this.length);
        }
    }
}

