/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\t"}, d2={"findGradleBuildFile", "Ljava/io/File;", "dirPath", "findGradleSettingsFile", "isDefaultGradleBuildFile", "", "filePath", "isGradleScript", "isGradleSettingsFile", "android.sdktools.common"})
@JvmName(name="BuildScriptUtil")
public final class BuildScriptUtil {
    @NotNull
    public static final File findGradleBuildFile(@NotNull File dirPath) {
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        File groovyBuildFile = new File(dirPath, "build.gradle");
        if (groovyBuildFile.isFile()) {
            return groovyBuildFile;
        }
        File kotlinBuildFile = new File(dirPath, "build.gradle.kts");
        if (kotlinBuildFile.isFile()) {
            return kotlinBuildFile;
        }
        return groovyBuildFile;
    }

    @NotNull
    public static final File findGradleSettingsFile(@NotNull File dirPath) {
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        File groovySettingsFile = new File(dirPath, "settings.gradle");
        if (groovySettingsFile.isFile()) {
            return groovySettingsFile;
        }
        File kotlinSettingsFile = new File(dirPath, "settings.gradle.kts");
        if (kotlinSettingsFile.isFile()) {
            return kotlinSettingsFile;
        }
        return groovySettingsFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGradleScript(@NotNull File filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (!filePath.isFile()) return false;
        String string = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath.path");
        if (StringsKt.endsWith$default((String)string, (String)"gradle", (boolean)false, (int)2, null)) return true;
        string = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath.path");
        if (!StringsKt.endsWith$default((String)string, (String)"gradle.kts", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDefaultGradleBuildFile(@NotNull File filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (!filePath.isFile()) return false;
        String string = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath.path");
        if (StringsKt.endsWith$default((String)string, (String)"build.gradle", (boolean)false, (int)2, null)) {
            if (Intrinsics.areEqual((Object)filePath.getName(), (Object)"build.gradle")) return true;
        }
        string = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath.path");
        if (!StringsKt.endsWith$default((String)string, (String)"build.gradle.kts", (boolean)false, (int)2, null)) return false;
        if (!Intrinsics.areEqual((Object)filePath.getName(), (Object)"build.gradle.kts")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGradleSettingsFile(@NotNull File filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (!filePath.isFile()) return false;
        String string = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath.path");
        if (StringsKt.endsWith$default((String)string, (String)"settings.gradle", (boolean)false, (int)2, null)) {
            if (Intrinsics.areEqual((Object)filePath.getName(), (Object)"settings.gradle")) return true;
        }
        string = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath.path");
        if (!StringsKt.endsWith$default((String)string, (String)"settings.gradle.kts", (boolean)false, (int)2, null)) return false;
        if (!Intrinsics.areEqual((Object)filePath.getName(), (Object)"settings.gradle.kts")) return false;
        return true;
    }
}

