/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen.generics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TypeAnnotationWriteHelper;
import org.jetbrains.java.decompiler.struct.StructTypePathEntry;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;

public final class GenericMain {
    private static final String[] typeNames = new String[]{"byte", "char", "double", "float", "int", "long", "short", "boolean"};

    public static GenericClassDescriptor parseClassSignature(String signature) {
        String original = signature;
        try {
            GenericClassDescriptor descriptor = new GenericClassDescriptor();
            signature = GenericMain.parseFormalParameters(signature, descriptor.fparameters, descriptor.fbounds);
            String superCl = GenericType.getNextType(signature);
            descriptor.superclass = new GenericType(superCl);
            signature = signature.substring(superCl.length());
            while (signature.length() > 0) {
                String superIf = GenericType.getNextType(signature);
                descriptor.superinterfaces.add(new GenericType(superIf));
                signature = signature.substring(superIf.length());
            }
            return descriptor;
        }
        catch (RuntimeException e) {
            DecompilerContext.getLogger().writeMessage("Invalid signature: " + original, IFernflowerLogger.Severity.WARN);
            return null;
        }
    }

    public static GenericFieldDescriptor parseFieldSignature(String signature) {
        try {
            return new GenericFieldDescriptor(new GenericType(signature));
        }
        catch (RuntimeException e) {
            DecompilerContext.getLogger().writeMessage("Invalid signature: " + signature, IFernflowerLogger.Severity.WARN);
            return null;
        }
    }

    public static GenericMethodDescriptor parseMethodSignature(String signature) {
        String original = signature;
        try {
            ArrayList<String> typeParameters = new ArrayList<String>();
            ArrayList<List<GenericType>> typeParameterBounds = new ArrayList<List<GenericType>>();
            signature = GenericMain.parseFormalParameters(signature, typeParameters, typeParameterBounds);
            int to = signature.indexOf(")");
            String parameters = signature.substring(1, to);
            signature = signature.substring(to + 1);
            ArrayList<GenericType> parameterTypes = new ArrayList<GenericType>();
            while (parameters.length() > 0) {
                String par = GenericType.getNextType(parameters);
                parameterTypes.add(new GenericType(par));
                parameters = parameters.substring(par.length());
            }
            String ret = GenericType.getNextType(signature);
            GenericType returnType = new GenericType(ret);
            signature = signature.substring(ret.length());
            ArrayList<GenericType> exceptionTypes = new ArrayList<GenericType>();
            if (signature.length() > 0) {
                String[] exceptions = signature.split("\\^");
                for (int i = 1; i < exceptions.length; ++i) {
                    exceptionTypes.add(new GenericType(exceptions[i]));
                }
            }
            return new GenericMethodDescriptor(typeParameters, typeParameterBounds, parameterTypes, returnType, exceptionTypes);
        }
        catch (RuntimeException e) {
            DecompilerContext.getLogger().writeMessage("Invalid signature: " + original, IFernflowerLogger.Severity.WARN);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String parseFormalParameters(String signature, List<? super String> parameters, List<? super List<GenericType>> bounds) {
        int index;
        if (signature.charAt(0) != '<') {
            return signature;
        }
        int counter = 1;
        block4: for (index = 1; index < signature.length(); ++index) {
            switch (signature.charAt(index)) {
                case '<': {
                    ++counter;
                    break;
                }
                case '>': {
                    if (--counter == 0) break block4;
                }
            }
        }
        String value = signature.substring(1, index);
        signature = signature.substring(index + 1);
        while (value.length() > 0) {
            int to = value.indexOf(":");
            String param = value.substring(0, to);
            value = value.substring(to + 1);
            ArrayList<GenericType> lstBounds = new ArrayList<GenericType>();
            while (true) {
                if (value.charAt(0) == ':') {
                    value = value.substring(1);
                }
                String bound = GenericType.getNextType(value);
                lstBounds.add(new GenericType(bound));
                value = value.substring(bound.length());
                if (value.length() == 0 || value.charAt(0) != ':') break;
                value = value.substring(1);
            }
            parameters.add(param);
            bounds.add(lstBounds);
        }
        return signature;
    }

    public static String getGenericCastTypeName(GenericType type, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        List<TypeAnnotationWriteHelper> arrayTypeAnnWriteHelpers = ExprProcessor.arrayPath(type, typeAnnWriteHelpers);
        List<TypeAnnotationWriteHelper> nonArrayTypeAnnWriteHelpers = ExprProcessor.nonArrayPath(type, typeAnnWriteHelpers);
        StringBuilder sb = new StringBuilder(GenericMain.getTypeName(type, nonArrayTypeAnnWriteHelpers));
        ExprProcessor.writeArray(sb, type.getArrayDim(), arrayTypeAnnWriteHelpers);
        return sb.toString();
    }

    private static String getTypeName(GenericType type, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        int tp = type.getType();
        if (tp <= 7) {
            return typeNames[tp];
        }
        if (tp == 10) {
            return "void";
        }
        if (tp == 18) {
            StringBuilder sb = new StringBuilder();
            ExprProcessor.writeTypeAnnotationBeforeType(type, sb, typeAnnWriteHelpers);
            sb.append(type.getValue());
            return sb.toString();
        }
        if (tp == 8) {
            StringBuilder sb = new StringBuilder();
            GenericMain.appendClassName(type, sb, typeAnnWriteHelpers);
            return sb.toString();
        }
        throw new RuntimeException("Invalid type: " + type);
    }

    private static void appendClassName(GenericType type, StringBuilder sb, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        List<GenericType> enclosingTypes = type.getEnclosingClasses();
        typeAnnWriteHelpers = ExprProcessor.writeTypeAnnotationBeforeType(type, sb, typeAnnWriteHelpers);
        if (enclosingTypes.isEmpty()) {
            List<String> nestedTypes = Arrays.asList(DecompilerContext.getImportCollector().getNestedName(type.getValue().replace('/', '.')).split("\\."));
            ExprProcessor.writeNestedClass(sb, type, nestedTypes, typeAnnWriteHelpers);
            ExprProcessor.popNestedTypeAnnotation(typeAnnWriteHelpers);
        } else {
            for (GenericType tp : enclosingTypes) {
                List<String> nestedTypes = Arrays.asList(DecompilerContext.getImportCollector().getNestedName(tp.getValue().replace('/', '.')).split("\\."));
                typeAnnWriteHelpers = ExprProcessor.writeNestedClass(sb, type, nestedTypes, typeAnnWriteHelpers);
                typeAnnWriteHelpers = GenericMain.appendTypeArguments(tp, sb, typeAnnWriteHelpers);
                ExprProcessor.popNestedTypeAnnotation(typeAnnWriteHelpers);
                sb.append('.');
            }
            typeAnnWriteHelpers = ExprProcessor.writeNestedTypeAnnotations(sb, typeAnnWriteHelpers);
            ExprProcessor.popNestedTypeAnnotation(typeAnnWriteHelpers);
            sb.append(type.getValue());
        }
        GenericMain.appendTypeArguments(type, sb, typeAnnWriteHelpers);
    }

    private static List<TypeAnnotationWriteHelper> appendTypeArguments(GenericType type, StringBuilder sb, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        if (!type.getArguments().isEmpty()) {
            sb.append('<');
            for (int i = 0; i < type.getArguments().size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                GenericType genPar = type.getArguments().get(i);
                int wildcard = type.getWildcards().get(i);
                List<TypeAnnotationWriteHelper> locTypeAnnWriteHelpers = GenericMain.getGenericTypeAnnotations(i, typeAnnWriteHelpers);
                typeAnnWriteHelpers.removeAll(locTypeAnnWriteHelpers);
                locTypeAnnWriteHelpers = GenericMain.writeTypeAnnotationBeforeWildCard(sb, genPar, wildcard, locTypeAnnWriteHelpers);
                switch (wildcard) {
                    case 3: {
                        sb.append('?');
                        break;
                    }
                    case 1: {
                        sb.append("? extends ");
                        break;
                    }
                    case 2: {
                        sb.append("? super ");
                    }
                }
                locTypeAnnWriteHelpers = GenericMain.writeTypeAnnotationAfterWildCard(sb, genPar, locTypeAnnWriteHelpers);
                if (genPar == null) continue;
                sb.append(GenericMain.getGenericCastTypeName(genPar, locTypeAnnWriteHelpers));
            }
            sb.append(">");
        }
        return typeAnnWriteHelpers;
    }

    private static List<TypeAnnotationWriteHelper> getGenericTypeAnnotations(int argIndex, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        return typeAnnWriteHelpers.stream().filter(typeAnnWriteHelper -> {
            boolean inGeneric;
            StructTypePathEntry entry = typeAnnWriteHelper.getPaths().peek();
            boolean bl = inGeneric = entry != null && entry.getTypeArgumentIndex() == argIndex && entry.getTypePathEntryKind() == StructTypePathEntry.Kind.TYPE.getId();
            if (inGeneric) {
                typeAnnWriteHelper.getPaths().pop();
            }
            return inGeneric;
        }).collect(Collectors.toList());
    }

    private static List<TypeAnnotationWriteHelper> writeTypeAnnotationBeforeWildCard(StringBuilder sb, GenericType type, int wildcard, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        return typeAnnWriteHelpers.stream().filter(typeAnnWriteHelper -> {
            StructTypePathEntry path = typeAnnWriteHelper.getPaths().peek();
            if (wildcard != 4 && path == null) {
                typeAnnWriteHelper.writeTo(sb);
                return false;
            }
            if (type.getArrayDim() == typeAnnWriteHelper.getPaths().size() && type.getArrayDim() == typeAnnWriteHelper.arrayPathCount()) {
                typeAnnWriteHelper.writeTo(sb);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private static List<TypeAnnotationWriteHelper> writeTypeAnnotationAfterWildCard(StringBuilder sb, GenericType type, List<TypeAnnotationWriteHelper> typeAnnWriteHelpers) {
        typeAnnWriteHelpers.forEach(typeAnnWriteHelper -> {
            boolean isWildCard;
            StructTypePathEntry path = typeAnnWriteHelper.getPaths().peek();
            boolean bl = isWildCard = path != null && path.getTypePathEntryKind() == StructTypePathEntry.Kind.TYPE_WILDCARD.getId();
            if (isWildCard) {
                typeAnnWriteHelper.getPaths().pop();
            }
        });
        return typeAnnWriteHelpers.stream().filter(typeAnnWriteHelper -> {
            StructTypePathEntry path = typeAnnWriteHelper.getPaths().peek();
            if (type.getArrayDim() == 0 && path == null) {
                typeAnnWriteHelper.writeTo(sb);
                return false;
            }
            if (type.getArrayDim() == typeAnnWriteHelper.getPaths().size() && type.getArrayDim() == typeAnnWriteHelper.arrayPathCount()) {
                typeAnnWriteHelper.writeTo(sb);
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }
}

