/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.consts;

import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;

public class LinkConstant
extends PooledConstant {
    public int index1;
    public int index2;
    public String classname;
    public String elementname;
    public String descriptor;

    public LinkConstant(int type, String classname, String elementname, String descriptor) {
        super(type);
        this.classname = classname;
        this.elementname = elementname;
        this.descriptor = descriptor;
        this.initConstant();
    }

    public LinkConstant(int type, int index1, int index2) {
        super(type);
        this.index1 = index1;
        this.index2 = index2;
    }

    private void initConstant() {
        if (this.type == 10 || this.type == 11 || this.type == 18 || this.type == 15 && this.index1 != 1 && this.index1 != 3) {
            int parenth = this.descriptor.indexOf(41);
            if (this.descriptor.length() < 2 || parenth < 0 || this.descriptor.charAt(0) != '(') {
                throw new IllegalArgumentException("Invalid descriptor: " + this.descriptor + "; type = " + this.type + "; classname = " + this.classname + "; elementname = " + this.elementname);
            }
        }
    }

    @Override
    public void resolveConstant(ConstantPool pool) {
        if (this.type == 12) {
            this.elementname = pool.getPrimitiveConstant(this.index1).getString();
            this.descriptor = pool.getPrimitiveConstant(this.index2).getString();
        } else if (this.type == 15) {
            LinkConstant ref_info = pool.getLinkConstant(this.index2);
            this.classname = ref_info.classname;
            this.elementname = ref_info.elementname;
            this.descriptor = ref_info.descriptor;
        } else {
            if (this.type != 18 && this.type != 17) {
                this.classname = pool.getPrimitiveConstant(this.index1).getString();
            }
            LinkConstant nametype = pool.getLinkConstant(this.index2);
            this.elementname = nametype.elementname;
            this.descriptor = nametype.descriptor;
        }
        this.initConstant();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkConstant)) {
            return false;
        }
        LinkConstant cn = (LinkConstant)o;
        return this.type == cn.type && this.elementname.equals(cn.elementname) && this.descriptor.equals(cn.descriptor) && (this.type != 12 || this.classname.equals(cn.classname));
    }
}

