/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.testing.compute;

import com.google.api.client.googleapis.auth.oauth2.OAuth2Utils;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.Beta;
import java.io.IOException;

@Beta
public class MockMetadataServerTransport
extends MockHttpTransport {
    private static final String METADATA_SERVER_URL = OAuth2Utils.getMetadataServerUrl();
    private static final String METADATA_TOKEN_SERVER_URL = METADATA_SERVER_URL + "/computeMetadata/v1/instance/service-accounts/default/token";
    static final JsonFactory JSON_FACTORY = new GsonFactory();
    String accessToken;
    Integer tokenRequestStatusCode;

    public MockMetadataServerTransport(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setTokenRequestStatusCode(Integer tokenRequestStatusCode) {
        this.tokenRequestStatusCode = tokenRequestStatusCode;
    }

    @Override
    public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
        if (url.equals(METADATA_TOKEN_SERVER_URL)) {
            MockLowLevelHttpRequest request = new MockLowLevelHttpRequest(url){

                @Override
                public LowLevelHttpResponse execute() throws IOException {
                    if (MockMetadataServerTransport.this.tokenRequestStatusCode != null) {
                        MockLowLevelHttpResponse response = new MockLowLevelHttpResponse().setStatusCode(MockMetadataServerTransport.this.tokenRequestStatusCode).setContent("Token Fetch Error");
                        return response;
                    }
                    String metadataRequestHeader = this.getFirstHeaderValue("Metadata-Flavor");
                    if (!"Google".equals(metadataRequestHeader)) {
                        throw new IOException("Metadata request header not found.");
                    }
                    GenericJson refreshContents = new GenericJson();
                    refreshContents.setFactory(JSON_FACTORY);
                    refreshContents.put("access_token", (Object)MockMetadataServerTransport.this.accessToken);
                    refreshContents.put("expires_in", (Object)3600000);
                    refreshContents.put("token_type", (Object)"Bearer");
                    String refreshText = refreshContents.toPrettyString();
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(refreshText);
                    return response;
                }
            };
            return request;
        }
        if (url.equals(METADATA_SERVER_URL)) {
            MockLowLevelHttpRequest request = new MockLowLevelHttpRequest(url){

                @Override
                public LowLevelHttpResponse execute() {
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                    response.addHeader("Metadata-Flavor", "Google");
                    return response;
                }
            };
            return request;
        }
        return super.buildRequest(method, url);
    }
}

