/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class StudioPathManager {
    private static final String ROOT_FROM_BUNDLED_SDK = "../../";
    private static final String ROOT_FROM_UNBUNDLED_SDK = "../../../../../../";

    public static boolean isRunningFromSources() {
        if (PluginManagerCore.isRunningFromSources()) {
            return true;
        }
        if (StudioPathManager.isRunningInBazelTest()) {
            return true;
        }
        return StudioPathManager.isRunningFromStudioSources();
    }

    @Deprecated
    public static String getSourcesRoot() {
        assert (StudioPathManager.isRunningFromSources());
        if (PluginManagerCore.isRunningFromSources()) {
            return StudioPathManager.getSourcesRootBundled();
        }
        if (StudioPathManager.isRunningInBazelTest()) {
            if (PathManager.getHomePath().contains("/prebuilts/studio/intellij-sdk/") || PathManager.getHomePath().contains("\\prebuilts\\studio\\intellij-sdk\\")) {
                return StudioPathManager.getSourcesRootUnbundled();
            }
            return StudioPathManager.getSourcesRootBundled();
        }
        return StudioPathManager.getSourcesRootUnbundled();
    }

    @Deprecated
    public static String getBinariesRoot() {
        return StudioPathManager.resolveDevPath(StudioPathManager.isRunningInBazelTest() ? "" : "/bazel-bin");
    }

    private static boolean isRunningInBazelTest() {
        return System.getenv().containsKey("TEST_WORKSPACE");
    }

    private static boolean isRunningFromStudioSources() {
        return PathUtil.toSystemIndependentName((String)PathManager.getHomePath()).contains("/prebuilts/studio/intellij-sdk/");
    }

    private static String getSourcesRootBundled() {
        return Paths.get(PathManager.getHomePath(), ROOT_FROM_BUNDLED_SDK).normalize().toString();
    }

    private static String getSourcesRootUnbundled() {
        Object relative = ROOT_FROM_UNBUNDLED_SDK;
        if (SystemInfo.isMac) {
            relative = (String)relative + "../";
        }
        return Paths.get(PathManager.getHomePath(), new String[]{relative}).normalize().toString();
    }

    public static String resolveDevPath(String relativePath) {
        assert (StudioPathManager.isRunningFromSources());
        Path resolved = Paths.get(StudioPathManager.getSourcesRoot(), relativePath);
        if (Files.exists(resolved, new LinkOption[0])) {
            return resolved.toString();
        }
        return StudioPathManager.resolveIjPath(relativePath, resolved.toString());
    }

    private static String resolveIjPath(String relativePath, String defaultPath) {
        relativePath = FileUtil.normalize((String)relativePath);
        HashMap<String, CallSite> pathMappings = new HashMap<String, CallSite>();
        pathMappings.put("tools/adt/idea", (CallSite)((Object)(PathManager.getCommunityHomePath() + "/android")));
        pathMappings.put("prebuilts/tools/common/kotlin-plugin/Kotlin", (CallSite)((Object)(PathManager.getHomePath() + "/out/artifacts/KotlinPlugin")));
        for (Map.Entry entry : pathMappings.entrySet()) {
            String aospPathPrefix = (String)entry.getKey();
            String ijPathPrefix = (String)entry.getValue();
            if (!relativePath.startsWith(aospPathPrefix)) continue;
            String ijFile = ijPathPrefix + relativePath.substring(aospPathPrefix.length());
            return Paths.get(ijFile, new String[0]).toString();
        }
        return defaultPath;
    }
}

