/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.io;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilePaths {
    private FilePaths() {
    }

    @NotNull
    public static String pathToIdeaUrl(@NotNull File path) {
        String name;
        if (path == null) {
            FilePaths.$$$reportNull$$$0(0);
        }
        boolean isJarFile = FileUtil.extensionEquals((String)(name = path.getName()), (String)"jar") || FileUtil.extensionEquals((String)name, (String)"zip");
        String protocol = isJarFile ? "jar" : "file";
        Object url = VirtualFileManager.constructUrl((String)protocol, (String)FileUtil.toSystemIndependentName((String)path.getPath()));
        if (isJarFile) {
            url = (String)url + "!/";
        }
        String string = url;
        if (string == null) {
            FilePaths.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static Path getJarFromJarUrl(@NotNull String url) {
        if (url == null) {
            FilePaths.$$$reportNull$$$0(2);
        }
        if (!url.startsWith("jar://")) {
            return null;
        }
        String path = url.substring("jar://".length());
        int index = path.lastIndexOf("!/");
        if (index != -1) {
            path = path.substring(0, index);
        }
        return FilePaths.toSystemDependentPath(path);
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static Path toSystemDependentPath(@Nullable String path) {
        return path == null ? null : Paths.get(path, new String[0]);
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static File stringToFile(@Nullable String path) {
        return path == null ? null : new File(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/io/FilePaths";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/io/FilePaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToIdeaUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pathToIdeaUrl";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJarFromJarUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

