/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.flags.Flag;
import com.android.flags.FlagGroup;
import com.android.flags.FlagOverrides;
import com.android.flags.Flags;
import com.android.flags.ImmutableFlagOverrides;
import com.android.flags.overrides.DefaultFlagOverrides;
import com.android.flags.overrides.PropertyOverrides;
import com.android.tools.idea.flags.StudioFlagSettings;
import com.android.tools.idea.flags.overrides.ServerFlagOverrides;
import com.android.tools.idea.util.StudioPathManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import org.jetbrains.annotations.NotNull;

public final class StudioFlags {
    private static final Flags FLAGS = StudioFlags.createFlags();
    private static final FlagGroup NPW = new FlagGroup(FLAGS, "npw", "New Project Wizard");
    public static final Flag<Boolean> NPW_FIRST_RUN_WIZARD = Flag.create((FlagGroup)NPW, (String)"first.run.wizard", (String)"Show new Welcome Wizard", (String)"Show new version of the Welcome Wizard when Studio starts", (boolean)false);
    public static final Flag<Boolean> NPW_FIRST_RUN_SHOW = Flag.create((FlagGroup)NPW, (String)"first.run.wizard.show", (String)"Show Welcome Wizard always", (String)"Show the Welcome Wizard when Studio starts", (boolean)false);
    public static final Flag<Boolean> NPW_SHOW_JDK_STEP = Flag.create((FlagGroup)NPW, (String)"first.run.jdk.step", (String)"Show JDK setup step", (String)"Show JDK Setup Step in Welcome Wizard", (boolean)true);
    public static final Flag<Boolean> NPW_SHOW_FRAGMENT_GALLERY = Flag.create((FlagGroup)NPW, (String)"show.fragment.gallery", (String)"Show fragment gallery", (String)"Show fragment gallery which contains fragment based templates", (boolean)true);
    public static final Flag<Boolean> NPW_SHOW_GRADLE_KTS_OPTION = Flag.create((FlagGroup)NPW, (String)"show.gradle.kts.option", (String)"Show gradle kts option", (String)"Shows an option on new Project/Module to allow the use of Kotlin script", (boolean)false);
    public static final Flag<Boolean> NPW_NEW_NATIVE_MODULE = Flag.create((FlagGroup)NPW, (String)"new.native.module", (String)"New Android Native Module", (String)"Show template to create a new Android Native module in the new module wizard.", (boolean)true);
    public static final Flag<Boolean> NPW_NEW_MACRO_BENCHMARK_MODULE = Flag.create((FlagGroup)NPW, (String)"new.macro.benchmark.module", (String)"New Macro Benchmark Module", (String)"Show template to create a new Macro Benchmark module in the new module wizard.", (boolean)true);
    public static final Flag<Boolean> NPW_MATERIAL3_ENABLED = Flag.create((FlagGroup)NPW, (String)"new.material3.templates", (String)"New Material3 Templates", (String)"Enable the new material 3 templates.", (boolean)true);
    private static final FlagGroup PROFILER = new FlagGroup(FLAGS, "profiler", "Android Profiler");
    public static final Flag<Boolean> PROFILER_CPU_CAPTURE_STAGE = Flag.create((FlagGroup)PROFILER, (String)"cpu.capture.stage", (String)"Enable new capture stage", (String)"With the new System Trace design we have a cpu capture stage. This flag uses that flow instead of the legacy CpuProfilerStageView flow.", (boolean)true);
    public static final Flag<Boolean> PROFILER_UNIFIED_PIPELINE = Flag.create((FlagGroup)PROFILER, (String)"unified.pipeline", (String)"Enables new event pipeline to be used for core components.", (String)"Toggles usage of gRPC apis to fetch data from perfd and the datastore.", (boolean)true);
    public static final Flag<Boolean> PROFILER_ENERGY_PROFILER_ENABLED = Flag.create((FlagGroup)PROFILER, (String)"energy", (String)"Enable Energy profiling", (String)"Enable the new energy profiler. It monitors battery usage of the selected app.", (boolean)true);
    public static final Flag<Boolean> PROFILER_STARTUP_CPU_PROFILING = Flag.create((FlagGroup)PROFILER, (String)"startup.cpu.profiling", (String)"Enable startup CPU Profiling", (String)"Record a method trace on startup by enabling it in the Profiler tab of Run/Debug configuration.", (boolean)true);
    public static final Flag<Boolean> PROFILER_MEMORY_CSV_EXPORT = Flag.create((FlagGroup)PROFILER, (String)"memory.csv", (String)"Allow exporting entries in memory profiler", (String)"Allow exporting entries in the views for heap dump and native/JVM recordings in CSV format.", (boolean)false);
    public static final Flag<Boolean> PROFILER_TRACK_JNI_REFS = Flag.create((FlagGroup)PROFILER, (String)"jni", (String)"Enable JVMTI-based JNI reference tracking.", (String)"For Android O or newer, JNI references are tracked in Memory Profiler and shown in JNI heap.", (boolean)true);
    public static final Flag<Boolean> PROFILER_PERFORMANCE_MONITORING = Flag.create((FlagGroup)PROFILER, (String)"performance.monitoring", (String)"Enable Profiler Performance Monitoring Options", (String)"Toggles if profiler performance metrics options are enabled.", (boolean)false);
    public static final Flag<Boolean> PROFILER_CPU_NEW_RECORDING_WORKFLOW = Flag.create((FlagGroup)PROFILER, (String)"cpu.new.recording.workflow", (String)"Enable new CPU recording workflow", (String)"Shows recording options and status of the ongoing recording in the method trace pane.", (boolean)true);
    public static final Flag<Boolean> PROFILER_JANK_DETECTION_UI = Flag.create((FlagGroup)PROFILER, (String)"jank.ui", (String)"Enable jank detection UI", (String)"Add a track in the display group showing frame janks.", (boolean)true);
    public static final Flag<Boolean> PROFILER_CUSTOM_EVENT_VISUALIZATION = Flag.create((FlagGroup)PROFILER, (String)"custom.event.visualization", (String)"Enable Profiler Custom Event Visualization", (String)"When enabled, profiler will track and display events defined through developer APIs", (boolean)false);
    public static final Flag<Boolean> PROFILER_USE_TRACEPROCESSOR = Flag.create((FlagGroup)PROFILER, (String)"perfetto.traceprocessor", (String)"Enable TraceProcessorDaemon", (String)"Use TraceProcessor to parse Perfetto captures instead of Trebuchet/Atrace backend.", (boolean)true);
    public static final Flag<Boolean> PROFILEABLE = Flag.create((FlagGroup)PROFILER, (String)"profileable", (String)"Support profileable processes on S+", (String)"Show profileable processes on S and later", (boolean)true);
    public static final Flag<Boolean> PROFILER_MIGRATION_TO_APPINSPECTION = Flag.create((FlagGroup)PROFILER, (String)"profiler.migration.to.appinspection", (String)"Enable migration support for network and system events profiling.", (String)"Show migration messaging to guide users to the App Inspection tool window", (boolean)true);
    public static final Flag<Boolean> PROFILEABLE_IN_QR = Flag.create((FlagGroup)PROFILER, (String)"profileable.qr", (String)"Support profileable processes on Q & R", (String)"Show profileable processes on Q and R", ((Boolean)PROFILEABLE.get() != false ? 1 : 0) != 0);
    private static final FlagGroup ML = new FlagGroup(FLAGS, "ml", "ML");
    public static final Flag<Boolean> ML_MODEL_BINDING = Flag.create((FlagGroup)ML, (String)"modelbinding", (String)"Enable ML model binding", (String)"When enabled, TFLite model file will be recognized and indexed. Please invalidates file caches after enabling (File -> Invalidate Caches...) in order to reindex model files.", (boolean)true);
    private static final FlagGroup ASSET = new FlagGroup(FLAGS, "asset", "Asset Studio");
    public static final Flag<Boolean> ASSET_COPY_MATERIAL_ICONS = Flag.create((FlagGroup)ASSET, (String)"copy.material.icons", (String)"Allow copying icons to Sdk folder", (String)"Allow the IconPickerDialog in Asset Studio to copy bundled material icons in to the Android/Sdk folder", (boolean)true);
    public static final Flag<Boolean> ASSET_DOWNLOAD_MATERIAL_ICONS = Flag.create((FlagGroup)ASSET, (String)"download.material.icons", (String)"Allow downloading icons to Sdk folder", (String)"Allow the IconPickerDialog in Asset Studio to download any new material icons in to the Android/Sdk folder", (boolean)true);
    private static final FlagGroup DESIGN_TOOLS = new FlagGroup(FLAGS, "design.tools", "Design Tools");
    public static final Flag<Boolean> DESIGN_TOOLS_POWER_SAVE_MODE_SUPPORT = Flag.create((FlagGroup)DESIGN_TOOLS, (String)"power.save.support", (String)"Enable previews support for PowerSave mode", (String)"If enabled, the the Layout Editor and Compose Preview will respect the Power Save mode and avoid auto-refresh, reduce FPS, etc.", (boolean)true);
    private static final FlagGroup NELE = new FlagGroup(FLAGS, "nele", "Layout Editor");
    public static final Flag<Boolean> NELE_ANIMATIONS_PREVIEW = Flag.create((FlagGroup)NELE, (String)"animated.preview", (String)"Show preview animations toolbar", (String)"Show an animations bar that allows playback of vector drawable animations.", (boolean)true);
    public static final Flag<Boolean> NELE_ANIMATED_SELECTOR_PREVIEW = Flag.create((FlagGroup)NELE, (String)"animated.selector.preview", (String)"Show preview animations toolbar for animated selector", (String)"Show an animations bar that allows playback of transitions in animated selector.", (boolean)true);
    public static final Flag<Boolean> NELE_ANIMATIONS_LIST_PREVIEW = Flag.create((FlagGroup)NELE, (String)"animated.list.preview", (String)"Show preview animations toolbar for animation list", (String)"Show an animations bar that allows playback of animation list files.", (boolean)true);
    public static final Flag<Boolean> NELE_MOTION_LAYOUT_ANIMATIONS = Flag.create((FlagGroup)NELE, (String)"animated.motion.layout", (String)"Show preview animations toolbar for MotionLayout", (String)"Show an animations bar that allows playback of MotionLayout animations.", (boolean)false);
    public static final Flag<Boolean> NELE_MOTION_LAYOUT_EDITOR = Flag.create((FlagGroup)NELE, (String)"animated.motion.editor", (String)"Show motion editor for MotionLayout", (String)"Show the motion editor UI for MotionLayout.", (boolean)true);
    public static final Flag<Boolean> NELE_MOTION_AREA_GRAPH = Flag.create((FlagGroup)NELE, (String)"motion.area.graph", (String)"Show area graph in Timeline panel", (String)"Show area graph in Timeline panel for Motion Editor.", (boolean)true);
    public static final Flag<Boolean> NELE_CONSTRAINT_SELECTOR = Flag.create((FlagGroup)NELE, (String)"constraint.selection", (String)"Allow selection of Constraints", (String)"Allow the selection of constraints.", (boolean)true);
    public static final Flag<Boolean> NELE_MOTION_HORIZONTAL = Flag.create((FlagGroup)NELE, (String)"animated.motion.horizontal", (String)"Display motion editor horizontally", (String)"Controls the placement of the motion editor (horizontal versus vertical).", (boolean)false);
    public static final Flag<Boolean> NELE_MOCKUP_EDITOR = Flag.create((FlagGroup)NELE, (String)"mockup.editor", (String)"Enable the Mockup Editor", (String)"Enable the Mockup Editor to ease the creation of Layouts from a design file.", (boolean)false);
    public static final Flag<Boolean> NELE_CONVERT_VIEW = Flag.create((FlagGroup)NELE, (String)"convert.view", (String)"Enable the Convert View action", (String)"Enable the Convert View Action when right clicking on a component", (boolean)true);
    public static final Flag<Boolean> NELE_RENDER_DIAGNOSTICS = Flag.create((FlagGroup)NELE, (String)"diagnostics", (String)"Enable rendering on-screen stats", (String)"If enabled, the surface displays some debug information to diagnose performance", (boolean)false);
    public static final Flag<Boolean> NELE_COLOR_RESOURCE_PICKER_FOR_FILE_EDITORS = Flag.create((FlagGroup)NELE, (String)"editor.color.picker", (String)"Enable popup color resource picker for java and kotlin files.", (String)"Show the popup color resource picker when clicking the gutter icon of color resource in java and kotlin files.", (boolean)true);
    public static final Flag<Boolean> NELE_DRAWABLE_POPUP_PICKER = Flag.create((FlagGroup)NELE, (String)"show.drawable.popup.picker", (String)"Enable drawable popup picker in Xml Editor.", (String)"Show the resource popup picker for picking drawable resources from the Editor's gutter icon.", (boolean)true);
    public static final Flag<Boolean> NELE_DRAWABLE_BACKGROUND_MENU = Flag.create((FlagGroup)NELE, (String)"show.drawable.background.menu", (String)"Enable background option menu in drawable preview panel.", (String)"Show the background option menu to switch the background when previewing drawable resources.", (boolean)true);
    public static final Flag<Boolean> NELE_WEAR_DEVICE_FIXED_ORIENTATION = Flag.create((FlagGroup)NELE, (String)"wear.fixed.orientation", (String)"Fixes the orientation of wear os devices.", (String)"For wear device, force using the portrait for square and round devices and landscape for chin devices.", (boolean)true);
    public static final Flag<Boolean> NELE_LOG_ANDROID_FRAMEWORK = Flag.create((FlagGroup)NELE, (String)"log.android.framework", (String)"Log messages coming from Layoutlib Native.", (String)"Log in the IDEA log the messages coming from Java and native code of Layoutlib Native.", (boolean)false);
    public static final Flag<Boolean> NELE_SCENEVIEW_TOP_TOOLBAR = Flag.create((FlagGroup)NELE, (String)"sceneview.top.toolbar", (String)"Enable the per SceneView top toolbar.", (String)"Enable the per SceneView top toolbar that displays the SceneView contextual actions.", (boolean)true);
    public static final Flag<Boolean> NELE_SCENEVIEW_BOTTOM_BAR = Flag.create((FlagGroup)NELE, (String)"sceneview.bottom.bar", (String)"Enable the per SceneView bottom bar.", (String)"Enable the per SceneView bottom bar that displays the SceneView contextual actions.", (boolean)false);
    public static final Flag<Boolean> NELE_SCENEVIEW_LEFT_BAR = Flag.create((FlagGroup)NELE, (String)"sceneview.left.bar", (String)"Enable SceneView left bar for overlay actions.", (String)"Enable the SceneView left bar that displays the overlay actions.", (boolean)true);
    private static final FlagGroup ASSISTANT = new FlagGroup(FLAGS, "assistant", "Assistants");
    public static final Flag<Boolean> CONNECTION_ASSISTANT_ENABLED = Flag.create((FlagGroup)ASSISTANT, (String)"connection.enabled", (String)"Enable the connection assistant", (String)"If enabled, user can access the Connection Assistant under \"Tools\" and \"Deploy Target Dialog\"", (boolean)true);
    public static final Flag<Boolean> NELE_CONSTRAINT_LAYOUT_ASSISTANT = Flag.create((FlagGroup)ASSISTANT, (String)"layout.editor.help.constraintlayout", (String)"Display Help for Constraint Layout", (String)"If enabled, the assistant panel will display helpful guide on using Constraint Layout.", (boolean)true);
    public static final Flag<Boolean> NELE_MOTION_LAYOUT_ASSISTANT = Flag.create((FlagGroup)ASSISTANT, (String)"layout.editor.help.motionlayout", (String)"Display Help for Motion Layout", (String)"If enabled, the assistant panel will display helpful guide on using Motion Layout.", (boolean)true);
    public static final Flag<Boolean> NELE_NAV_EDITOR_ASSISTANT = Flag.create((FlagGroup)ASSISTANT, (String)"layout.editor.help.naveditor", (String)"Display Help for Navigation Editor", (String)"If enabled, the assistant panel will display helpful guide on using the Navigation Editor.", (boolean)true);
    public static final Flag<Boolean> NELE_DRAG_PLACEHOLDER = Flag.create((FlagGroup)NELE, (String)"drag.placeholder", (String)"Dragging widgets with Placeholders", (String)"New architecture for dragging widgets in Layout Editor", (boolean)true);
    public static final Flag<Boolean> NELE_PROPERTY_PANEL_ACTIONBAR = Flag.create((FlagGroup)NELE, (String)"property.panel.actionbar", (String)"Property Panel Actionbar", (String)"Support Actionbar in property panel", (boolean)false);
    public static final Flag<Boolean> NELE_NEW_DEVICE_MENU = Flag.create((FlagGroup)NELE, (String)"new.device.menu", (String)"New Device Menu in Layout Editor", (String)"Use the new designed device menu to support device classes", (boolean)true);
    public static final Flag<Boolean> NELE_VISUALIZATION_WINDOW_SIZE_MODE = Flag.create((FlagGroup)NELE, (String)"visualization.window.sizes", (String)"Use Window Sizes Category in Layout Validation Tool", (String)"Use Window Sizes as default group and replace the pixel devices category with it in Layout Validation Tool", (boolean)true);
    public static final Flag<Boolean> NELE_VISUALIZATION_LOCALE_MODE = Flag.create((FlagGroup)NELE, (String)"visualization.locale", (String)"Locale Mode in Layout Validation Tool", (String)"Enable locale mode in Layout Validation Tool to preview layout in project's locales", (boolean)true);
    public static final Flag<Boolean> NELE_VISUALIZATION_APPLY_CONFIG_TO_LAYOUT_EDITOR = Flag.create((FlagGroup)NELE, (String)"visualization.apply.config", (String)"Apply Selected Configuration in Validation Tool to Layout Editor", (String)"Apply the configuration to Layout Editor by double clicking the preview in Validation Tool", (boolean)true);
    public static final Flag<Boolean> NELE_VISUALIZATION_MULTIPLE_CUSTOM = Flag.create((FlagGroup)NELE, (String)"visualization.multiple.custom", (String)"Multiple Custom Categories in Layout Validation Tool", (String)"Allow to create or delete multiple custom categories in Layout Validation Tool", (boolean)false);
    public static final Flag<Boolean> NELE_SOURCE_CODE_EDITOR = Flag.create((FlagGroup)NELE, (String)"show.source.code.editor", (String)"New Source Code Editor", (String)"Enable new source code editor with preview(s) coming as a substitute to Compose and Custom View editors.", (boolean)true);
    public static final Flag<Boolean> NELE_TOGGLE_TOOLS_ATTRIBUTES_IN_PREVIEW = Flag.create((FlagGroup)NELE, (String)"toggle.tools.attributes.preview", (String)"New Toggle for Tools namespaces attributes", (String)"Enable the new toggle in the Layout Editor. Allows toggling tools attributes in the Layout preview.", (boolean)true);
    public static final Flag<Boolean> NELE_SHOW_RECYCLER_VIEW_SETUP_WIZARD = Flag.create((FlagGroup)NELE, (String)"recyclerview.setup.wizard", (String)"Show setup wizard for recycler view", (String)"When you right click recycler view in layout editor, you can now see \"Generate Adapter\" that takes you through setup wizard", (boolean)false);
    public static final Flag<Boolean> NELE_CUSTOM_SHORTCUT_KEYMAP = Flag.create((FlagGroup)NELE, (String)"custom.shortcut.keymap", (String)"Design Tool Custom Shortcut", (String)"Make the shortcuts of design tools configurable. The shortcut keymap can be changed in Preferences -> Keymap -> Android Design Tools", (boolean)true);
    public static final Flag<Boolean> NELE_LAYOUT_SCANNER_IN_EDITOR = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.validator.a11y", (String)"Toggle layout validator for layout editor.", (String)"When the model changes, layout editor will run the series of layout validations and update lint output", (boolean)true);
    public static final Flag<Boolean> NELE_LAYOUT_SCANNER_ADD_INCLUDE = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.validator.a11y.include", (String)"Toggle whether to show included layout or not.", (String)"If the layout contains <include>, turning this flag on will run the scanner in the included layout.", (boolean)false);
    public static final Flag<Boolean> NELE_LAYOUT_SCANNER_COMMON_ERROR_PANEL = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.validator.a11y.common.panel", (String)"Enable common error panel to display scanner results.", (String)"If the xml layout contains atf results, it will be shown in the common error panel as well as issue panel.", (boolean)false);
    public static final Flag<Boolean> NELE_SHOW_VISUAL_LINT_ISSUE_IN_COMMON_PROBLEMS_PANEL = Flag.create((FlagGroup)NELE, (String)"show.issue.in.common.panel", (String)"Enable showing issues in common problems panel.", (String)"If the xml layout contains any visual lint issues, it will be shown in the common error panel as well as in laytout validation issue panel.", (boolean)false);
    public static final Flag<Boolean> NELE_VISUAL_LINT_ALWAYS_RUN = Flag.create((FlagGroup)NELE, (String)"visual.lint.always.run", (String)"Run visual lint always", (String)"Enable so that visual lint always runs for select configurations.", (boolean)false);
    public static final Flag<Boolean> NELE_SHOW_ISSUE_PANEL_IN_PROBLEMS = Flag.create((FlagGroup)NELE, (String)"show.issue.panel.in.problems", (String)"Show the Issue Panel in IJ's Problem Panel", (String)"Move the Issue Panel from Design Tools into the Problems Panel as an additional tab.", (boolean)false);
    public static final Flag<Boolean> NELE_TRANSFORM_PANEL = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.transform.panel", (String)"Toggle transform panel in layout editor and motion editor.", (String)"Enable the new transform panel in the layout editor and motion editor", (boolean)true);
    public static final Flag<Boolean> NELE_TRANSITION_PANEL = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.transition.panel", (String)"Toggle transition panel in motion editor.", (String)"Enable the new transition panel in the motion editor", (boolean)true);
    public static final Flag<Boolean> NELE_ON_SWIPE_PANEL = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.on.swipe.panel", (String)"Toggle on swipe panel in motion editor.", (String)"Enable the new on swipe panel in the motion editor", (boolean)true);
    public static final Flag<Boolean> NELE_OVERLAY_PROVIDER = Flag.create((FlagGroup)NELE, (String)"toggle.overlay.provider.extension.point", (String)"Toggle overlay provider extension point.", (String)"Enable the overlay provider extension point", (boolean)true);
    public static final Flag<Boolean> NELE_CLASS_BINARY_CACHE = Flag.create((FlagGroup)NELE, (String)"toggle.layout.editor.class.binary.cache", (String)"Enable binary cache", (String)"Enable binary cache of classes used in preview", (boolean)true);
    public static final Flag<Boolean> NELE_STATE_LIST_PICKER = Flag.create((FlagGroup)NELE, (String)"state.list.picker", (String)"Enable State List Picker", (String)"Enable state list picker for selector drawable.", (boolean)true);
    public static final Flag<Boolean> NELE_ASSET_REPOSITORY_INCLUDE_AARS_THROUGH_PROJECT_SYSTEM = Flag.create((FlagGroup)NELE, (String)"asset.repository.include.aars.through.project.system", (String)"Include AARs through project system", (String)"Include resource directories from AARs found through project system.", (boolean)false);
    public static final Flag<Boolean> NELE_VISUAL_LINT = Flag.create((FlagGroup)NELE, (String)"visual.lint", (String)"Enable visual linting for layouts", (String)"Enable all the various tools related to visual linting of layouts.", (boolean)false);
    public static final Flag<Boolean> NELE_VISUAL_LINT_TOGGLE_ISSUE_LAYOUTS = Flag.create((FlagGroup)NELE, (String)"visual.lint.toggle.issue.layouts", (String)"Checkbox to show the the layouts with issue only.", (String)"Provide a checkbox in Layout Validation Tool to allow user only show the layouts with issue detected by visual lint.", (boolean)false);
    public static final Flag<Boolean> NELE_ATF_IN_VISUAL_LINT = Flag.create((FlagGroup)NELE, (String)"visual.lint.atf", (String)"Enable ATF integration in visual linting for layouts", (String)"Enable ATF integration in visual linting of layouts.", (boolean)false);
    public static final Flag<Boolean> NELE_WARN_NEW_THREADS = Flag.create((FlagGroup)NELE, (String)"preview.warn.new.threads", (String)"Enable new threads warning", (String)"Display a warning if user code creates new threads in the preview", (boolean)true);
    public static final Flag<Boolean> NELE_CLASS_PRELOADING_DIAGNOSTICS = Flag.create((FlagGroup)NELE, (String)"preview.class.preloading.diagnostics", (String)"Enable class preloading overlay", (String)"If enabled, the surface displays background class preloading progress", (boolean)false);
    private static final FlagGroup NAV_EDITOR = new FlagGroup(FLAGS, "nav", "Navigation Editor");
    public static final Flag<Boolean> NAV_SAFE_ARGS_SUPPORT = Flag.create((FlagGroup)NAV_EDITOR, (String)"safe.args.enabled", (String)"Enable support for Safe Args", (String)"Generate in-memory Safe Args classes if the current module is using the feature.", (boolean)true);
    private static final FlagGroup RES_MANAGER = new FlagGroup(FLAGS, "res.manager", "Resource Manager");
    public static final Flag<Boolean> EXTENDED_TYPE_FILTERS = Flag.create((FlagGroup)RES_MANAGER, (String)"extended.filters", (String)"Enable extended filters for resources", (String)"Adds more filter options for resources based on the selected ResourceType. Includes options to filter by resource XML tag or File extension.", (boolean)true);
    public static final Flag<Boolean> NAVIGATION_PREVIEW = Flag.create((FlagGroup)RES_MANAGER, (String)"nav.preview", (String)"Enable previews for Navigation resources", (String)"Adds a visual preview to the Navigation resources in the Resource Manager. The preview corresponds to the start destination of the graph.", (boolean)true);
    private static final FlagGroup RESOURCE_REPOSITORY = new FlagGroup(FLAGS, "resource.repository", "Resource Repository");
    public static final Flag<Boolean> RESOURCE_REPOSITORY_TRACE_UPDATES = Flag.create((FlagGroup)RESOURCE_REPOSITORY, (String)"trace.updates", (String)"Enable Tracing of Resource Repository Updates", (String)"Enables tracing of resource repository updates", (boolean)false);
    public static final Flag<Integer> RESOURCE_REPOSITORY_TRACE_SIZE = Flag.create((FlagGroup)RESOURCE_REPOSITORY, (String)"trace.size", (String)"Maximum Size of Resource Repository Update Trace", (String)"Size of the in-memory cyclic buffer used for tracing of resource repository updates", (int)10000);
    private static final FlagGroup RUNDEBUG = new FlagGroup(FLAGS, "rundebug", "Run/Debug");
    public static final Flag<Boolean> RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"logcat.console.output.enabled", (String)"Show logcat process output in Run/Debug console window", (String)"When running or debugging an Android process, output the logcat output of the process in the console window.", (boolean)true);
    public static final Flag<Boolean> RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"android.bundle.build.enabled", (String)"Enable the Build Bundle action", (String)("If enabled, the \"Build Bundle(s)\" menu item is enabled. Changing the value of this flag requires restarting " + ApplicationNamesInfo.getInstance().getFullProductName() + "."), (boolean)true);
    public static final Flag<Boolean> DELTA_INSTALL = Flag.create((FlagGroup)RUNDEBUG, (String)"deltainstall", (String)"Delta install", (String)"Upon installing, if application is already on device, only send parts of the apks which have changed (the delta).", (boolean)true);
    public static final Flag<Boolean> APPLY_CHANGES_OPTIMISTIC_SWAP = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.optimisticswap", (String)"Use the 'Apply Changes 2.0' deployment pipeline", (String)"Supports Install-without-Install, Speculative Diff and Structural Redefinition", (boolean)true);
    public static final Flag<Boolean> APPLY_CHANGES_OPTIMISTIC_RESOURCE_SWAP = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.optimisticresourceswap", (String)"Use the 'Apply Changes 2.0' deployment pipeline for full Apply Changes", (String)"Requires applychanges.optimisticswap to be true.", (boolean)true);
    public static final Flag<Boolean> NEW_EXECUTION_FLOW_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"android.new.execution.flow.enabled", (String)"Enable new Execution flow", (String)"If enabled, AS executes Run Configuration via new.AndroidRunProfileState", (boolean)false);
    public static final Flag<OptimisticInstallSupportLevel> OPTIMISTIC_INSTALL_SUPPORT_LEVEL = Flag.create((FlagGroup)RUNDEBUG, (String)"optimisticinstall.supportlevel", (String)"The amount of support for using the 'Apply Changes 2.0' pipeline on Run.", (String)"This can be \"DISABLED\" to always use a package manager installation; \"DEX\" to use the pipeline for dex-only changes; \"DEX_AND_NATIVE\" to use the pipeline for dex and native library-only changes; or \"DEX_AND_NATIVE_AND_RESOURCES\" to use the pipeline for changes to dex, native libraries, and/or resource/asset files. Deploying changes that exceed the level of support configured here will cause the deployment to install via the package manager.", (Enum)OptimisticInstallSupportLevel.DEX);
    public static final Flag<Boolean> APPLY_CHANGES_STRUCTURAL_DEFINITION = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.structuralredefinition", (String)"Use ART's new structural redefinition extension for Apply Changes.", (String)"Requires applychanges.optimisticswap to be true.", (boolean)true);
    public static final Flag<Boolean> APPLY_CHANGES_VARIABLE_REINITIALIZATION = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.variablereinitialization", (String)"Use ART's new variable reinitializaiton extension for Apply Changes.", (String)"Requires applychanges.structuralredefinition to be true.", (boolean)true);
    public static final Flag<Boolean> APPLY_CHANGES_FAST_RESTART_ON_SWAP_FAIL = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.swap.fastrestartonswapfail", (String)"Allow fast restart on swap failure.", (String)"Eliminate the need to build again when auto re-run checkbox is turned on.", (boolean)true);
    public static final Flag<Boolean> APPLY_CHANGES_KEEP_CONNECTION_ALIVE = Flag.create((FlagGroup)RUNDEBUG, (String)"applychanges.connection.keepalive", (String)"Keep connection to device alive.", (String)"Eliminate the cost of opening a connection and spawning a process when using Apply Changes.", (boolean)true);
    public static final Flag<Boolean> SELECT_DEVICE_SNAPSHOT_COMBO_BOX_SNAPSHOTS_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"select.device.snapshot.combo.box.snapshots.enabled", (String)"Enable Select Device/Snapshot combo box snapshots", (String)"So the new Instant Run can use the combo box", (boolean)true);
    public static final Flag<Boolean> ADB_CONNECTION_STATUS_WIDGET_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"adb.connection.status.widget.enabled", (String)"Enable and Show ADB Connection Widget", (String)"Enables and shows the ADB connection status widget in the status bar", (boolean)false);
    public static final Flag<Boolean> ADB_WIRELESS_PAIRING_ENABLED = Flag.create((FlagGroup)RUNDEBUG, (String)"adb.wireless.enabled", (String)"Enable pairing devices through ADB wireless", (String)"Allow pairing new physical device through QR Code pairing via ADB wireless", (boolean)true);
    public static final Flag<Boolean> ADB_SERVER_MANAGEMENT_MODE_SETTINGS_VISIBLE = Flag.create((FlagGroup)RUNDEBUG, (String)"adb.server.management.mode.settings.visible", (String)"Show ADB server management mode settings", (String)"To allow toggling between automatic or user managed ADB server mode.", (boolean)false);
    public static final Flag<Boolean> ADBLIB_MIGRATION_DEVICE_EXPLORER = Flag.create((FlagGroup)RUNDEBUG, (String)"adblib.migration.device.explorer", (String)"Use adblib in Device Explorer", (String)"Use adblib instead of ddmlib for Device Explorer", (boolean)false);
    public static final Flag<Boolean> ADBLIB_MIGRATION_WIFI_PAIRING = Flag.create((FlagGroup)RUNDEBUG, (String)"adblib.migration.wifi.pairing", (String)"Use adblib in Pair Device over Wi-Fi", (String)"Use adblib instead of ddmlib for Pair Device over Wi-Fi", (boolean)true);
    public static final Flag<Boolean> SUPPORT_FEATURE_ON_FEATURE_DEPS = Flag.create((FlagGroup)RUNDEBUG, (String)"feature.on.feature", (String)"Enable feature-on-feature dependencies", (String)"Enables Studio to understand feature-on-feature dependencies when launching dynamic apps.", (boolean)false);
    public static final Flag<Boolean> COROUTINE_DEBUGGER_ENABLE = Flag.create((FlagGroup)RUNDEBUG, (String)"coroutine.debugger.enable", (String)"Enable Coroutine Debugger", (String)"Enables the Coroutine Debugger, that shows up as a panel in the debugger when debugging an app that uses coroutines", (boolean)false);
    public static final Flag<Boolean> LOGCAT_EXPRESSION_FILTER_ENABLE = Flag.create((FlagGroup)RUNDEBUG, (String)"logcat.expression.filter.enable", (String)"Enable expression filter in Logcat", (String)"Enables the expression filter in Logcat", (boolean)false);
    public static final Flag<Boolean> LOGCAT_SUPPRESSED_TAGS_ENABLE = Flag.create((FlagGroup)RUNDEBUG, (String)"logcat.suppressed.tags.enable", (String)"Enable Suppressed Tags Dialog in Logcat", (String)"Enables a dialog that allows the user to maintain a global set of tags to be suppressed in Logcat", (boolean)false);
    public static final Flag<Boolean> LOGCAT_V2_ENABLE = Flag.create((FlagGroup)RUNDEBUG, (String)"logcat.v2.enable", (String)"Enable Logcat V2", (String)"Enables version 2 of the Logcat tool window", (boolean)false);
    private static final FlagGroup GRADLE_IDE = new FlagGroup(FLAGS, "gradle.ide", "Gradle Project System");
    public static final Flag<Boolean> FIX_ANDROID_RUN_CONFIGURATIONS_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.run.configuration.fix.enabled", (String)"Check Android Run Configurations contains the \"Gradle-aware Make\" task and fix them", (String)"When a project is loaded, automatically add a \"Gradle-aware Make\" task to each Run Configuration if the task is missing", (boolean)true);
    public static final Flag<Boolean> NEW_PSD_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"new.psd", (String)"Enable new \"Project Structure\" dialog", (String)"Turns on the new \"Project Structure\" dialog.", (boolean)true);
    public static final Flag<Boolean> USE_DEVELOPMENT_OFFLINE_REPOS = Flag.create((FlagGroup)GRADLE_IDE, (String)"development.offline.repos", (String)"Enable development offline repositories", (String)"Makes Gradle use development offline repositories such as /out/repo", (boolean)StudioPathManager.isRunningFromSources());
    public static final Flag<Boolean> BUILD_ATTRIBUTION_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"build.attribution", (String)"Enable build attribution", (String)"Enable build attribution.", (boolean)true);
    public static final Flag<Boolean> BUILD_ANALYZER_JETIFIER_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"build.analyzer.jetifier.warning", (String)"Enable Jetifier usage analyzis", (String)"Enable Jetifier usage analyzis is Build Analyzer.", (boolean)true);
    public static final Flag<Boolean> DISABLE_FORCED_UPGRADES = Flag.create((FlagGroup)GRADLE_IDE, (String)"forced.agp.update", (String)"Disable forced Android Gradle plugin upgrades", (String)("This option is only respected when running " + ApplicationNamesInfo.getInstance().getFullProductName() + " internally."), (boolean)false);
    public static final Flag<Boolean> USE_MODULE_PER_SOURCE_SET = Flag.create((FlagGroup)GRADLE_IDE, (String)"module.per.source.set", (String)"Enables creating multiple modules per Gradle project", (String)"This allows the IDE to more closely represent how the project is configured in Gradle.", (boolean)true);
    public static final Flag<Boolean> GRADLE_SYNC_PARALLEL_SYNC_ENABLED = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.parallel.sync.enabled", (String)"Enables parallel sync", (String)"This allows the IDE to fetch models in parallel (if supported by Gralde and enabled via org.gradle.parallel=true).", (boolean)false);
    public static final Flag<Boolean> GRADLE_SYNC_PARALLEL_SYNC_PREFETCH_VARIANTS = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.parallel.sync.prefetch.variants", (String)"Enables speculative syncing of current variants", (String)"This allows the IDE to pre-fetch models for the currently selected variants in parallel before resolving the new variant selection (which is less parallelizable process).", (boolean)false);
    public static final Flag<Boolean> GRADLE_SYNC_ENABLE_CACHED_VARIANTS = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.enable.cached.variants", (String)"Enables caching of build variants", (String)"Enables caching of build variant data so that the IDE does not always run Gradle when switching between build variants. While faster this mode may be incompatible with some plugins.", (boolean)true);
    public static final Flag<Boolean> ALLOW_DIFFERENT_JDK_VERSION = Flag.create((FlagGroup)GRADLE_IDE, (String)"jdk.allow.different", (String)"Allow different Gradle JDK", (String)"Allow usage of a different JDK version when running Gradle.", (boolean)true);
    public static final Flag<Boolean> GRADLE_SYNC_USE_V2_MODEL = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.use.v2", (String)"Use V2 Builder models", (String)"Enable fetching V2 builder models from AGP when syncing.", (boolean)true);
    public static final Flag<Boolean> GRADLE_SYNC_RECREATE_JDK = Flag.create((FlagGroup)GRADLE_IDE, (String)"gradle.sync.recreate.jdk", (String)"Recreate JDK on sync", (String)"Recreate Gradle JDK when syncing if there are changed roots.", (boolean)true);
    private static final FlagGroup DATABASE_INSPECTOR = new FlagGroup(FLAGS, "database.inspector", "Database Inspector");
    public static final Flag<Boolean> DATABASE_INSPECTOR_ENABLED = Flag.create((FlagGroup)DATABASE_INSPECTOR, (String)"enabled", (String)"Enable Database Inspector", (String)"If enabled the Database Inspector tool window will appear.SQLite files opened from the Device Explorer will be opened in the inspector.", (boolean)true);
    public static final Flag<Boolean> DATABASE_INSPECTOR_OPEN_FILES_ENABLED = Flag.create((FlagGroup)DATABASE_INSPECTOR, (String)"open.files.enabled", (String)"Enable support for opening SQLite files in Database Inspector", (String)"If enabled, the Database Inspector tool will be able to open SQLite files.eg. SQLite files opened from the Device Explorer will open in the inspector.", (boolean)false);
    public static final Flag<Boolean> DATABASE_INSPECTOR_OFFLINE_MODE_ENABLED = Flag.create((FlagGroup)DATABASE_INSPECTOR, (String)"offline.enabled", (String)"Enable offline mode in Database Inspector", (String)"If enabled, Database Inspector will download a copy of open databases when the connection to the device is lost.", (boolean)true);
    public static final Flag<Boolean> DATABASE_INSPECTOR_EXPORT_TO_FILE_ENABLED = Flag.create((FlagGroup)DATABASE_INSPECTOR, (String)"export.to.file.enabled", (String)"Enable Export to File feature in Database Inspector", (String)"If enabled, Database Inspector will expose an ability for the user to export a table, query results, or the whole database to a local file.", (boolean)true);
    private static final FlagGroup LAYOUT_INSPECTOR = new FlagGroup(FLAGS, "layout.inspector", "Layout Inspector");
    public static final Flag<Boolean> LAYOUT_INSPECTOR_LOAD_OVERLAY_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"load.overlay", (String)"Enable the Load Overlay feature", (String)"If enabled, show actions to let user choose overlay image on preview.", (boolean)true);
    public static final Flag<Boolean> LAYOUT_INSPECTOR_SUB_VIEW_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"sub.view", (String)"Enable the sub view feature", (String)"If enabled, changes the preview to focus on a component.", (boolean)true);
    public static final Flag<Boolean> LAYOUT_INSPECTOR_V2_PROTOCOL_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"capture.v2", (String)"Enable using V2 protocol to capture view data", (String)"If enabled, uses V2 protocol to capture view information from device.", (boolean)false);
    public static final Flag<Boolean> LAYOUT_INSPECTOR_EDITING_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"ui.editing", (String)"Enable editing ViewNode properties in the properties table.", (String)"If enabled, users can edit properties in the properties table.", (boolean)false);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector", (String)"Enable dynamic layout inspector", (String)"Turns on the dynamic layout inspector.", (boolean)true);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_EDITING_ENABLED = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.editor", (String)"Enable dynamic layout editor", (String)"If enabled, users can edit layout properties with live updates on a device while the dynamic layout inspector is running.", (boolean)false);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_USE_DEVBUILD_SKIA_SERVER = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.devbuild.skia", (String)"Use the locally-built skia rendering server", (String)"If enabled and this is a locally-built studio instance, use the locally-built skia server instead of one from the SDK.", (boolean)false);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_SHOW_SEMANTICS = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.show.semantics", (String)"Show semantics", (String)"If enabled, display semantic information found in the agent.", (boolean)true);
    public static final Flag<Boolean> DYNAMIC_LAYOUT_INSPECTOR_ENABLE_SNAPSHOTS = Flag.create((FlagGroup)LAYOUT_INSPECTOR, (String)"dynamic.layout.inspector.enable.snapshots", (String)"Enable snapshots", (String)"Enable saving and loading snapshots in the layout inspector.", (boolean)true);
    private static final FlagGroup EMBEDDED_EMULATOR = new FlagGroup(FLAGS, "embedded.emulator", "Embedded Emulator");
    public static final Flag<Boolean> EMBEDDED_EMULATOR_SCREENSHOT_STATISTICS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"screenshot.statistics", (String)"Enable Collection of Screenshot Statistics", (String)"Captures statistics of received Emulator screenshots", (boolean)false);
    public static final Flag<Integer> EMBEDDED_EMULATOR_STATISTICS_INTERVAL_SECONDS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"screenshot.statistics.interval", (String)"Aggregation Interval for Screenshot Statistics", (String)"Aggregation interval in seconds for statistics of received Emulator screenshots", (int)120);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_GRPC_CALLS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.grpc.calls", (String)"Enable Emulator gRPC Tracing", (String)"Enables tracing of most Emulator gRPC calls", (boolean)false);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_HIGH_VOLUME_GRPC_CALLS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.high.volume.grpc.calls", (String)"Enable High Volume Emulator gRPC Tracing", (String)"Enables tracing of high volume Emulator gRPC calls", (boolean)false);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_SCREENSHOTS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.screenshots", (String)"Enable Emulator Screenshot Tracing", (String)"Enables tracing of received Emulator screenshots", (boolean)false);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_NOTIFICATIONS = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.notifications", (String)"Enable Emulator Notification Tracing", (String)"Enables tracing of received Emulator notifications", (boolean)false);
    public static final Flag<Boolean> EMBEDDED_EMULATOR_TRACE_DISCOVERY = Flag.create((FlagGroup)EMBEDDED_EMULATOR, (String)"trace.discovery", (String)"Enable Tracing of Emulator Discovery", (String)"Enables tracing of Emulator discovery", (boolean)false);
    private static final FlagGroup REFACTORINGS = new FlagGroup(FLAGS, "refactor", "Refactor menu");
    public static final Flag<Boolean> MIGRATE_TO_RESOURCE_NAMESPACES_REFACTORING_ENABLED = Flag.create((FlagGroup)REFACTORINGS, (String)"migrateto.resourcenamespaces.enabled", (String)"Enable the Migrate to Resource Namespaces refactoring", (String)"If enabled, show the action in the refactoring menu", (boolean)false);
    public static final Flag<Boolean> MIGRATE_TO_NON_TRANSITIVE_R_CLASSES_REFACTORING_ENABLED = Flag.create((FlagGroup)REFACTORINGS, (String)"migrateto.nontransitiverclasses.enabled", (String)"Enable the Migrate to non-transitive R classes refactoring", (String)"If enabled, show the action in the refactoring menu", (boolean)true);
    private static final FlagGroup NDK = new FlagGroup(FLAGS, "ndk", "Native code features");
    public static final Flag<Boolean> CMAKE_ENABLE_FEATURES_FROM_CLION = Flag.create((FlagGroup)NDK, (String)"cmakeclionfeatures", (String)"Enable CMake language support from CLion", (String)"If enabled, language support features (e.g. syntax highlighting) currently present in CLion will be turned on.", (boolean)true);
    public static final Flag<Boolean> APK_DEBUG_BUILD_ID_CHECK = Flag.create((FlagGroup)NDK, (String)"apkdebugbuildidcheck", (String)"Enable build ID check in APK debugging", (String)"If enabled, the build ID of user-provided symbol files are compared against the binaries inside the APK.", (boolean)true);
    public static final Flag<Boolean> APK_DEBUG_RELOAD = Flag.create((FlagGroup)NDK, (String)"apkdebugreload", (String)"Enable APK reloading feature", (String)"If enabled, the user will be provided with an option to reload the APK inside an APK debugging project", (boolean)true);
    private static final FlagGroup NDK_SIDE_BY_SIDE = new FlagGroup(FLAGS, "ndk.sxs", "NDK Side by Side");
    public static final Flag<Boolean> NDK_SIDE_BY_SIDE_ENABLED = Flag.create((FlagGroup)NDK_SIDE_BY_SIDE, (String)"ndk.sxs.enabled", (String)"Enable side by side NDK support", (String)"If enabled, C/C++ projects will have NDK side by side support", (boolean)true);
    public static final Flag<Boolean> USE_CONTENT_ROOTS_FOR_NATIVE_PROJECT_VIEW = Flag.create((FlagGroup)NDK, (String)"use.content.roots.for.native.project.view", (String)"Use content roots for native project view", (String)"If enabled, the C/C++ content roots are displayed in Android View and Project View. Otherwise, each individual native target is displayed.", (boolean)true);
    public static final Flag<Boolean> ENABLE_SHOW_FILES_UNKNOWN_TO_CMAKE = Flag.create((FlagGroup)NDK, (String)"ndk.projectview.showfilessunknowntocmake", (String)"Enable option to show files unknown to CMake", (String)"If enabled, for projects using CMake, Android project view menu would show an option to `Show Files Unknown To CMake`.", (boolean)true);
    public static final Flag<Boolean> ENABLE_LLDB_NATVIS = Flag.create((FlagGroup)NDK, (String)"lldb.natvis", (String)"Use NatVis visualizers in native debugger", (String)"If enabled, native debugger formats variables using NatVis files found in the project.", (boolean)false);
    private static final FlagGroup EDITOR = new FlagGroup(FLAGS, "editor", "Editor features");
    public static final Flag<Boolean> COLLAPSE_ANDROID_NAMESPACE = Flag.create((FlagGroup)EDITOR, (String)"collapse.android.namespace", (String)"Collapse the android namespace in XML code completion", (String)"If enabled, XML code completion doesn't include resources from the android namespace. Instead a fake completion item is used to offer just the namespace prefix.", (boolean)true);
    public static final Flag<Boolean> ADVANCED_JNI_ASSISTANCE = Flag.create((FlagGroup)EDITOR, (String)"advanced.jni.assistance", (String)"Enable advanced JNI assistance", (String)"If enabled, additional inspection, completion, and refactoring supports are provided related to JNI. If disabled, some inspections related to JNI may stop working.", (boolean)true);
    public static final Flag<Boolean> CUSTOM_JAVA_NEW_CLASS_DIALOG = Flag.create((FlagGroup)EDITOR, (String)"custom.new.class.dialog", (String)"Enable custom New Class dialog", (String)"If enabled, our custom UI for creating a new Java class is used. Otherwise the platform default is used.", (boolean)false);
    public static final Flag<Boolean> INCREMENTAL_RESOURCE_REPOSITORIES = Flag.create((FlagGroup)EDITOR, (String)"incremental.resource.repositories", (String)"Handle PSI events incrementally in ResourceFolderRepository", (String)"If enabled, ResourceFolderRepository will handle PSI events synchronously, rather than rescanning the whole file.", (boolean)true);
    public static final Flag<Boolean> TWEAK_COLOR_SCHEME = Flag.create((FlagGroup)EDITOR, (String)"tweak.color.scheme", (String)"Change the default color scheme", (String)"If enabled, we modify the default color scheme slightly.", (boolean)true);
    public static final Flag<Boolean> SAMPLES_SUPPORT_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"samples.support.enabled", (String)"Enable supports of samples (tag inside KDoc) that are used in quick documentation", (String)"Enable supports of samples (tag inside KDoc) that are used in quick documentation", (boolean)false);
    public static final Flag<Boolean> DAGGER_SUPPORT_ENABLED = Flag.create((FlagGroup)EDITOR, (String)"dagger.support.enabled", (String)"Enable editor support for Dagger", (String)"If enabled adds Dagger specific find usages, gutter icons and new parsing for Dagger errors", (boolean)true);
    private static final FlagGroup UAB = new FlagGroup(FLAGS, "uab", "Unified App Bundle");
    public static final Flag<Boolean> UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS = Flag.create((FlagGroup)UAB, (String)"enable.ia.run.configs", (String)"Enable new instant app run configuration options", (String)"If enabled, shows the new instant app deploy checkbox in the run configuration dialog and allows new instant app deploy workflow.", (boolean)true);
    private static final FlagGroup TESTING = new FlagGroup(FLAGS, "testing", "Testing support");
    public static final Flag<Boolean> PRINT_INSTRUMENTATION_STATUS = Flag.create((FlagGroup)TESTING, (String)"print.instrumentation.status", (String)"Print instrumentation status information when testing", (String)"If enabled, instrumentation output keys (from calling Instrumentation#sendStatus) that begin with 'android.studio.display.' will have their values printed after a test has finished running.", (boolean)true);
    public static final Flag<Boolean> UTP_TEST_RESULT_SUPPORT = Flag.create((FlagGroup)TESTING, (String)"utp.instrumentation.tests", (String)"Allow importing UTP test results.", (String)"If enabled, you can import UTP test results and display them in test result panel.", (boolean)true);
    public static final Flag<Boolean> UTP_INSTRUMENTATION_TESTING = Flag.create((FlagGroup)TESTING, (String)"utp.instrumentation.testing", (String)"Run instrumentation tests via UTP", (String)"If enabled, a checkbox to opt-in to running instrumentation tests via UTP feature is displayed in the settings.", (boolean)true);
    private static final FlagGroup MEMORY_SETTINGS = new FlagGroup(FLAGS, "memory.settings", "Memory Settings");
    public static final Flag<Boolean> LOW_IDE_XMX_CAP = Flag.create((FlagGroup)MEMORY_SETTINGS, (String)"low.ide.xmx.cap", (String)"Set low IDE Xmx cap in memory settings", (String)"If set, IDE Xmx is capped at 4GB in the configuration dialog. Otherwise, the cap is 8GB", (boolean)true);
    private static final FlagGroup SYSTEM_HEALTH = new FlagGroup(FLAGS, "system.health", "System Health");
    public static final Flag<Boolean> WINDOWS_UCRT_CHECK_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"windows.ucrt.check.enabled", (String)"Enable Universal C Runtime system health check", (String)"If enabled, a notification will be shown if the Universal C Runtime in Windows is not installed", (boolean)false);
    public static final Flag<Boolean> ANTIVIRUS_NOTIFICATION_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.notification.enabled", (String)"Enable antivirus system health check", (String)"If enabled, a notification will be shown if antivirus realtime scanning is enabled and directories relevant to build performance aren't excluded", (boolean)true);
    public static final Flag<Boolean> ANTIVIRUS_METRICS_ENABLED = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.metrics.enabled", (String)"Enable antivirus metrics collection", (String)"If enabled, metrics about the status of antivirus realtime scanning and excluded directories will be collected", (boolean)true);
    public static final Flag<Boolean> ANTIVIRUS_CHECK_USE_REGISTRY = Flag.create((FlagGroup)SYSTEM_HEALTH, (String)"antivirus.check.registry", (String)"Use registry instead of PowerShell for checking antivirus status", (String)"If enabled, the antivirus status checker will use the Windows registry instead of PowerShell commands", (boolean)true);
    private static final FlagGroup COMPOSE = new FlagGroup(FLAGS, "compose", "Compose");
    public static final Flag<Boolean> COMPOSE_PREVIEW_ONLY_KOTLIN_BUILD = Flag.create((FlagGroup)COMPOSE, (String)"preview.fast.build.enabled", (String)"Enable the use of \"compileDebugKotlin\" for the preview refresh", (String)"If enabled, the refresh button will only trigger the \"compileDebugKotlin\" task as opposed to others like\"generateDebugSources\" or \"compileJava\".", (boolean)true);
    public static final Flag<Boolean> COMPOSE_PREVIEW_RUN_CONFIGURATION = Flag.create((FlagGroup)COMPOSE, (String)"preview.run.configuration", (String)"Enable running Compose Previews on device/emulator", (String)"If enabled, it will be possible to create run configurations that launch a Compose Preview directly to the device/emulator.", (boolean)true);
    public static final Flag<Boolean> COMPOSE_PREVIEW_DOUBLE_RENDER = Flag.create((FlagGroup)COMPOSE, (String)"preview.double.render", (String)"Enable the Compose double render mode", (String)"If enabled, preview components will be rendered twice so components depending on a recompose (like tableDecoration) render correctly.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_PREVIEW_SCROLL_ON_CARET_MOVE = Flag.create((FlagGroup)COMPOSE, (String)"preview.scroll.on.caret.move", (String)"Enable the Compose Preview scrolling when the caret moves", (String)"If enabled, when moving the caret in the text editor, the Preview will show the preview currently under the cursor.", (boolean)true);
    public static final Flag<Boolean> COMPOSE_PREVIEW_INTERRUPTIBLE = Flag.create((FlagGroup)COMPOSE, (String)"preview.interruptible", (String)"Allows the Compose Preview to interrupt rendering calls", (String)"If enabled, if a render takes too long, the preview will be able to interrupt the execution.", (boolean)true);
    public static final Flag<Boolean> COMPOSE_EDITOR_SUPPORT = Flag.create((FlagGroup)COMPOSE, (String)"editor", (String)"Compose-specific support in the code editor", (String)"Controls whether Compose-specific editor features, like completion tweaks, are enabled. This flag has priority over all flags in the `compose.editor.*` namespace.", (boolean)true);
    public static final Flag<Boolean> COMPOSE_COMPLETION_PRESENTATION = Flag.create((FlagGroup)COMPOSE, (String)"editor.completion.presentation", (String)"Custom presentation for code completion items for composable functions", (String)"If enabled, code completion items for composable functions use a custom presentation (icon, text).", (boolean)true);
    public static final Flag<Boolean> COMPOSE_COMPLETION_WEIGHER = Flag.create((FlagGroup)COMPOSE, (String)"editor.completion.weigher", (String)"Custom weigher for Compose", (String)"If enabled, code completion puts composable functions above other completion suggestions.", (boolean)true);
    public static final Flag<Boolean> COMPOSE_COMPLETION_INSERT_HANDLER = Flag.create((FlagGroup)COMPOSE, (String)"editor.completion.insert.handler", (String)"Custom insert handler for composable functions", (String)"If enabled, code completion for composable functions uses a custom InsertHandler that inserts required parameter names.", (boolean)true);
    public static final Flag<Boolean> COMPOSE_AUTO_DOCUMENTATION = Flag.create((FlagGroup)COMPOSE, (String)"editor.auto.documentation", (String)"Show quick documentation automatically for Compose", (String)"If enabled, during code completion popup with documentation shows automatically", (boolean)true);
    public static final Flag<Boolean> COMPOSE_RENDER_SAMPLE_IN_DOCUMENTATION = Flag.create((FlagGroup)COMPOSE, (String)"editor.render.sample", (String)"Render samples of compose elements inside documentation", (String)"If enabled, adds rendered image of sample for compose element if such exists", (boolean)false);
    public static final Flag<Boolean> COMPOSE_RENDER_SAMPLE_IN_DOCUMENTATION_SLOW = Flag.create((FlagGroup)COMPOSE, (String)"editor.render.sample.slow", (String)"Slow down rendering of samples of compose elements inside documentation", (String)"If enabled, slow down rendering of samples of compose elements inside documentation, this flag is used for demonstration of non-blocking behavior", (boolean)false);
    public static final Flag<Boolean> COMPOSE_FUNCTION_EXTRACTION = Flag.create((FlagGroup)COMPOSE, (String)"editor.function.extraction", (String)"Enables extracting @Composable function from other composables", (String)"If enabled, function extracted from @Composable function will annotated @Composable", (boolean)true);
    public static final Flag<Boolean> COMPOSE_WIZARD_TEMPLATES = Flag.create((FlagGroup)COMPOSE, (String)"wizard.templates", (String)"Show Compose Wizards", (String)"If enabled, allows adding new Compose Projects/Modules/Activities through the wizards", (boolean)true);
    public static final Flag<Boolean> COMPOSE_ANIMATED_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.animated.enable", (String)"Enable animated compose preview", (String)"If enabled, a user can switch compose preview to be animated", (boolean)true);
    public static final Flag<Boolean> COMPOSE_ANIMATED_PREVIEW_SHOW_CLICK = Flag.create((FlagGroup)COMPOSE, (String)"preview.animated.click.enable", (String)"Enable displaying clicks on the animated preview", (String)"If enabled, clicking on the animated preview will generate a ripple", (boolean)true);
    public static final Flag<Boolean> COMPOSE_ANIMATION_INSPECTOR = Flag.create((FlagGroup)COMPOSE, (String)"preview.animation.inspector", (String)"Enable compose preview animation inspection", (String)"If enabled, users can inspect animations in compose previews, e.g. play/pause and jump to specific frame", (boolean)true);
    public static final Flag<Boolean> COMPOSE_ANIMATION_PREVIEW_LABEL_INSPECTION = Flag.create((FlagGroup)COMPOSE, (String)"preview.animation.label.inspection", (String)"Enable 'label' parameter inspection of Compose animations PropKeys", (String)"If enabled, show a warning when the 'label' parameter of Compose animations PropKeys are not set.", (boolean)true);
    public static final Flag<Boolean> COMPOSE_LIVE_LITERALS = Flag.create((FlagGroup)COMPOSE, (String)"preview.live.literals", (String)"Enable the live literals", (String)"If enabled, the live literals feature is enabled", (boolean)true);
    public static final Flag<Boolean> COMPOSE_DEPLOY_LIVE_LITERALS = Flag.create((FlagGroup)COMPOSE, (String)"deploy.live.literals.deploy", (String)"Enable live literals deploy", (String)"If enabled, literals within Composable functions are instantly deployed to device", (boolean)true);
    public static final Flag<Boolean> COMPOSE_DEPLOY_LIVE_EDIT = Flag.create((FlagGroup)COMPOSE, (String)"deploy.live.edit.deploy", (String)"Enable live edits deploy", (String)"If enabled, edits within Kotlin and Composable functions are instantly deployed to device", (boolean)false);
    public static final Flag<Boolean> COMPOSE_DEPLOY_LIVE_EDIT_USE_EMBEDDED_COMPILER = Flag.create((FlagGroup)COMPOSE, (String)"deploy.live.edit.deploy.embeddedcompiler", (String)"Enable embedded compose compiler in live edits deploy", (String)"If enabled, live edit will use embedded compose compiler. For now if this is disabled, @Composable with not be updated.", (boolean)true);
    public static final Flag<Integer> COMPOSE_LIVE_LITERALS_UPDATE_RATE = Flag.create((FlagGroup)COMPOSE, (String)"deploy.live.literals.updaterate", (String)"Update rate of live literals edits", (String)"The rate of which live literals are updated in milliseconds", (int)50);
    public static final Flag<Boolean> COMPOSE_DEBUG_BOUNDS = Flag.create((FlagGroup)COMPOSE, (String)"preview.debug.bounds", (String)"Enable the debug bounds switch controls", (String)"If enabled, the user can enable/disable the painting of debug bounds", (boolean)false);
    public static final Flag<Boolean> COMPOSE_PREVIEW_ELEMENT_PICKER = Flag.create((FlagGroup)COMPOSE, (String)"preview.element.picker.enable", (String)"Enable @Preview picker", (String)"If enabled, the picker for @Preview elements will be available", (boolean)false);
    public static final Flag<Boolean> COMPOSE_BLUEPRINT_MODE = Flag.create((FlagGroup)COMPOSE, (String)"preview.blueprint", (String)"Enable the blueprint mode for Compose previews", (String)"If enabled, the user can change the mode of Compose previews, between design and blueprint mode", (boolean)false);
    public static final Flag<Boolean> COMPOSE_QUICK_ANIMATED_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.animated.quick", (String)"Speed up transition between static and animated compose previews", (String)"If enabled, a transition between static and animated compose preview is almost instant", (boolean)true);
    public static final Flag<Boolean> COMPOSE_COLORBLIND_MODE = Flag.create((FlagGroup)COMPOSE, (String)"preview.colorblind", (String)"Enable the colorblind mode for Compose previews", (String)"If enabled, the user can change the mode of Compose previews, between different types of colorblind modes", (boolean)true);
    public static final Flag<Boolean> COMPOSE_PIN_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.pin.enable", (String)"Enable pinning compose previews", (String)"If enabled, a user can pin a preview", (boolean)false);
    public static final Flag<Boolean> COMPOSE_CONSTRAINT_VISUALIZATION = Flag.create((FlagGroup)COMPOSE, (String)"constraint.visualization", (String)"Enable ConstraintLayout visualization in Compose previews", (String)"If enabled, constraints from a ConstraintLayout composable will be shown in the preview", (boolean)true);
    public static final Flag<Boolean> COMPOSE_INDIVIDUAL_PIN_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.individual.pin.enable", (String)"Enable pinning of individual compose previews", (String)"If enabled, a user can pin a single preview within a file", (boolean)false);
    public static final Flag<Integer> COMPOSE_INTERACTIVE_FPS_LIMIT = Flag.create((FlagGroup)COMPOSE, (String)"preview.interactive.fps.limit", (String)"Interactive Preview FPS limit", (String)"Controls the maximum number of frames per second in Compose Interactive Preview", (int)30);
    public static final Flag<Boolean> COMPOSE_CLASSLOADERS_PRELOADING = Flag.create((FlagGroup)COMPOSE, (String)"preview.classloaders.preloading", (String)"Enable background classes preloading", (String)"If enabled, a background classes preloading will happen to speed-up preview ClassLoader warm-up", (boolean)true);
    public static final Flag<Boolean> COMPOSE_STATE_OBJECT_CUSTOM_RENDERER = Flag.create((FlagGroup)COMPOSE, (String)"custom.renderer.for.compose.state.objects", (String)"Enable custom renderers for compose state objects", (String)"If enabled, a given compose 'StateObject' type object will be rendered by the corresponding custom renderer", (boolean)true);
    public static final Flag<Boolean> COMPOSE_INTERACTIVE_ANIMATION_CURVES = Flag.create((FlagGroup)COMPOSE, (String)"preview.animation.curves", (String)"Enable animation curves in Animation Inspector", (String)"If enabled, animation curves will be rendered in Animation Inspector timeline.", (boolean)true);
    public static final Flag<Boolean> COMPOSE_LIVE_EDIT_PREVIEW = Flag.create((FlagGroup)COMPOSE, (String)"preview.fast.reload.enabled", (String)"Enable the Compose fast-reload preview", (String)"If enabled, the preview enabled the fast-reload feature.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_LIVE_EDIT_DEBUG_DAEMON = Flag.create((FlagGroup)COMPOSE, (String)"preview.fast.reload.debug.daemon", (String)"Starts the Live Edit daemon in debug mode", (String)"If enabled, the compiler daemon will wait for a debugger to be attached.", (boolean)false);
    private static final FlagGroup APP_INSPECTION = new FlagGroup(FLAGS, "appinspection", "App Inspection");
    public static final Flag<Boolean> ENABLE_APP_INSPECTION_TOOL_WINDOW = Flag.create((FlagGroup)APP_INSPECTION, (String)"enable.tool.window", (String)"Enable App Inspection Tool Window", (String)"Enables the top-level App Inspection tool window, which will contain tabs to various feature inspectors", (boolean)true);
    public static final Flag<Boolean> APP_INSPECTION_USE_DEV_JAR = Flag.create((FlagGroup)APP_INSPECTION, (String)"use.dev.jar", (String)"Use a precompiled, prebuilt inspector jar", (String)"If enabled, grab inspector jars from prebuilt locations, skipping over version checking and dynamic resolving of inspector artifacts from maven. This is useful for devs who want to load locally built inspectors.", (boolean)false);
    public static final Flag<Boolean> APP_INSPECTION_USE_SNAPSHOT_JAR = Flag.create((FlagGroup)APP_INSPECTION, (String)"use.snapshot.jar", (String)"Always extract latest inspector jar from library", (String)"If enabled, override normal inspector resolution logic, instead searching the IDE cache directly. This allows finding inspectors bundled in local, snapshot builds of Android libraries, as opposed to those released through the normal process on maven.", (boolean)false);
    public static final Flag<Boolean> COMPOSE_USE_LOADER_WITH_AFFINITY = Flag.create((FlagGroup)COMPOSE, (String)"preview.loader.affinity", (String)"Enable the class loading affinity.", (String)"If enabled, the class loading will cache which class loaders are more likely to have the class.", (boolean)true);
    private static final FlagGroup WORK_MANAGER_INSPECTOR = new FlagGroup(FLAGS, "work.inspector", "WorkManager Inspector");
    public static final Flag<Boolean> ENABLE_WORK_MANAGER_INSPECTOR_TAB = Flag.create((FlagGroup)WORK_MANAGER_INSPECTOR, (String)"enable.tab", (String)"Enable WorkManager Inspector Tab", (String)"Enables a WorkManager Inspector Tab in the App Inspection tool window", (boolean)true);
    public static final Flag<Boolean> ENABLE_WORK_MANAGER_GRAPH_VIEW = Flag.create((FlagGroup)WORK_MANAGER_INSPECTOR, (String)"enable.graph.view", (String)"Enable WorkManager Graph View", (String)"Enables a Graph View for visualizing work dependencies in the WorkManager Inspector Tab", (boolean)true);
    private static final FlagGroup NETWORK_INSPECTOR = new FlagGroup(FLAGS, "network.inspector", "Network Inspector");
    public static final Flag<Boolean> ENABLE_NETWORK_MANAGER_INSPECTOR_TAB = Flag.create((FlagGroup)NETWORK_INSPECTOR, (String)"enable.network.inspector.tab", (String)"Enable Network Inspector Tab", (String)"Enables a Network Inspector Tab in the App Inspection tool window", (boolean)true);
    private static final FlagGroup BACKGROUND_TASK_INSPECTOR = new FlagGroup(FLAGS, "backgroundtask.inspector", "BackgroundTask Inspector");
    public static final Flag<Boolean> ENABLE_BACKGROUND_TASK_INSPECTOR_TAB = Flag.create((FlagGroup)BACKGROUND_TASK_INSPECTOR, (String)"enable.backgroundtask.inspector.tab", (String)"Enable BackgroundTask Inspector Tab", (String)"Enables a BackgroundTask Inspector Tab in the App Inspection tool window", (boolean)true);
    private static final FlagGroup DEVICE_MANAGER = new FlagGroup(FLAGS, "device.manager", "Device Manager");
    public static final Flag<Boolean> ENABLE_NEW_DEVICE_MANAGER_PANEL = Flag.create((FlagGroup)DEVICE_MANAGER, (String)"enable.device.manager", (String)"Enable new Device Manager panel", (String)"Enables the new Device Manager panel. It replaces AVD Manager with additional functionality.", (boolean)true);
    public static final Flag<Boolean> ENABLE_DEVICE_MANAGER_HALF_BAKED_FEATURES = Flag.create((FlagGroup)DEVICE_MANAGER, (String)"enable.device.manager.half.baked.features", (String)"Enable half baked Device Manager features", (String)"Enables some features that could be unpolished or unready in the new Device Manager", (boolean)false);
    public static final Flag<Boolean> WEAR_OS_VIRTUAL_DEVICE_PAIRING_ASSISTANT_ENABLED = Flag.create((FlagGroup)DEVICE_MANAGER, (String)"wear.os.virtual.device.pairing.assistant.enabled", (String)"Enable the Wear OS virtual device pairing assistant", (String)"Enable the Wear OS virtual device pairing assistant", (boolean)false);
    public static final Flag<Boolean> PAIRED_DEVICES_TAB_ENABLED = Flag.create((FlagGroup)DEVICE_MANAGER, (String)"paired.devices.tab.enabled", (String)"Enable the Paired devices tab", (String)"Enable the Paired devices tab in the details panel", (boolean)false);
    private static final FlagGroup DDMLIB = new FlagGroup(FLAGS, "ddmlib", "DDMLIB");
    public static final Flag<Boolean> ENABLE_JDWP_PROXY_SERVICE = Flag.create((FlagGroup)DDMLIB, (String)"enable.jdwp.proxy.service", (String)"Enable jdwp proxy service", (String)"Creates a proxy service within DDMLIB to allow shared device client connections.", (boolean)false);
    public static final Flag<Boolean> ENABLE_DDMLIB_COMMAND_SERVICE = Flag.create((FlagGroup)DDMLIB, (String)"enable.ddmlib.command.service", (String)"Enable ddmlib command service", (String)"Creates a service within DDMLIB to allow external processes to issue commands to ddmlib.", (boolean)false);
    private static final FlagGroup SERVER_FLAGS = new FlagGroup(FLAGS, "serverflags", "Server Flags");
    public static final Flag<Boolean> TEST_SERVER_FLAG = Flag.create((FlagGroup)SERVER_FLAGS, (String)"test", (String)"Test Server Enabled Flag", (String)"Creates a sample studio flag that can be set using a server flag", (boolean)false);
    private static final FlagGroup METRICS = new FlagGroup(FLAGS, "metrics", "Metrics");
    public static final Flag<Boolean> NEW_CONSENT_DIALOG = Flag.create((FlagGroup)METRICS, (String)"new.consent.dialog", (String)"New consent dialog", (String)"Enable the new consent dialog for opting into metrics", (boolean)true);

    @NotNull
    private static Flags createFlags() {
        Application app = ApplicationManager.getApplication();
        Object userOverrides = app != null && !app.isUnitTestMode() ? StudioFlagSettings.getInstance() : new DefaultFlagOverrides();
        return new Flags((FlagOverrides)userOverrides, new ImmutableFlagOverrides[]{new PropertyOverrides(), new ServerFlagOverrides()});
    }

    private StudioFlags() {
    }

    public static enum OptimisticInstallSupportLevel {
        DISABLED,
        DEX,
        DEX_AND_NATIVE,
        DEX_AND_NATIVE_AND_RESOURCES;

    }
}

