/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.inspectors.common.ui.dataviewer;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.inspectors.common.ui.dataviewer.DataViewer;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import java.awt.Font;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijDataViewer
implements DataViewer {
    private static final int RAW_VIEWER_MAX_STRING_LENGTH = 500;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final DataViewer.Style myStyle;

    public static IntellijDataViewer createRawTextViewer(@NotNull byte[] content) {
        if (content == null) {
            IntellijDataViewer.$$$reportNull$$$0(0);
        }
        JTextArea textArea = new JTextArea(new String(content, 0, Math.min(content.length, 500), StandardCharsets.UTF_8));
        textArea.setLineWrap(true);
        textArea.setFont((Font)AdtUiUtils.DEFAULT_FONT.biggerOn(3.0f));
        textArea.setEditable(false);
        textArea.setBackground(null);
        return new IntellijDataViewer(textArea, DataViewer.Style.RAW);
    }

    @NotNull
    public static IntellijDataViewer createPrettyViewerIfPossible(@NotNull Project project, byte[] content, @Nullable FileType fileType) {
        if (project == null) {
            IntellijDataViewer.$$$reportNull$$$0(1);
        }
        try {
            PsiFile psiFile;
            Language language;
            EditorFactory editorFactory = EditorFactory.getInstance();
            String contentStr = new String(content, StandardCharsets.UTF_8).replace("\r\n", "\n");
            DataViewer.Style style = DataViewer.Style.RAW;
            Document document = null;
            if (fileType instanceof LanguageFileType && !(language = ((LanguageFileType)fileType).getLanguage()).is((Language)PlainTextLanguage.INSTANCE) && (psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(language, (CharSequence)contentStr)) != null) {
                ReformatCodeProcessor processor = new ReformatCodeProcessor(psiFile, false);
                processor.run();
                document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
                if (document != null) {
                    style = DataViewer.Style.PRETTY;
                }
            }
            if (document == null) {
                document = editorFactory.createDocument(contentStr.toCharArray());
            }
            EditorEx editor = (EditorEx)editorFactory.createViewer(document);
            editor.setCaretVisible(false);
            EditorSettings settings = editor.getSettings();
            settings.setLineNumbersShown(false);
            settings.setLineMarkerAreaShown(false);
            settings.setUseSoftWraps(true);
            settings.setSoftMargins(Collections.emptyList());
            settings.setRightMarginShown(false);
            settings.setFoldingOutlineShown(true);
            CodeFoldingManager.getInstance((Project)project).updateFoldRegions((Editor)editor);
            if (fileType != null) {
                editor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, fileType));
            }
            Disposer.register((Disposable)project, () -> editorFactory.releaseEditor((Editor)editor));
            return new IntellijDataViewer(editor.getComponent(), style);
        }
        catch (AssertionError | Exception e) {
            return IntellijDataViewer.createInvalidViewer();
        }
    }

    @NotNull
    public static IntellijDataViewer createInvalidViewer() {
        JLabel component = new JLabel("No preview available", 0);
        component.setFont(component.getFont().deriveFont(14.0f));
        return new IntellijDataViewer(component, DataViewer.Style.INVALID);
    }

    private IntellijDataViewer(@NotNull JComponent component, @NotNull DataViewer.Style style) {
        if (component == null) {
            IntellijDataViewer.$$$reportNull$$$0(2);
        }
        if (style == null) {
            IntellijDataViewer.$$$reportNull$$$0(3);
        }
        this.myComponent = component;
        this.myStyle = style;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            IntellijDataViewer.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public DataViewer.Style getStyle() {
        DataViewer.Style style = this.myStyle;
        if (style == null) {
            IntellijDataViewer.$$$reportNull$$$0(5);
        }
        return style;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/inspectors/common/ui/dataviewer/IntellijDataViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/inspectors/common/ui/dataviewer/IntellijDataViewer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRawTextViewer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPrettyViewerIfPossible";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

