/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.inspectors.common.api.ide.stacktrace;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.inspectors.common.api.stacktrace.CodeElement;
import com.google.common.base.Strings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntelliJCodeElement
implements CodeElement {
    private static final VirtualFile UNRESOLVED_CLASS_FILE = new StubVirtualFile();
    @NotNull
    private final Project myProject;
    @NotNull
    private final CodeLocation myCodeLocation;
    @NotNull
    private String myPackageName;
    @NotNull
    private String mySimpleClassName;
    @Nullable
    private VirtualFile myCachedClassFile;

    public IntelliJCodeElement(@NotNull Project project, @NotNull CodeLocation codeLocation) {
        if (project == null) {
            IntelliJCodeElement.$$$reportNull$$$0(0);
        }
        if (codeLocation == null) {
            IntelliJCodeElement.$$$reportNull$$$0(1);
        }
        this.myCachedClassFile = UNRESOLVED_CLASS_FILE;
        this.myProject = project;
        this.myCodeLocation = codeLocation;
        String className = this.myCodeLocation.getClassName();
        if (className == null) {
            this.myPackageName = "<unknown package>";
            this.mySimpleClassName = "<unkonwn class>";
        } else {
            int dot = className.lastIndexOf(46);
            this.myPackageName = dot <= 0 ? "<no package>" : className.substring(0, dot);
            this.mySimpleClassName = dot + 1 < className.length() ? className.substring(dot + 1) : "<unkonwn class>";
        }
    }

    @Override
    @NotNull
    public CodeLocation getCodeLocation() {
        CodeLocation codeLocation = this.myCodeLocation;
        if (codeLocation == null) {
            IntelliJCodeElement.$$$reportNull$$$0(2);
        }
        return codeLocation;
    }

    @Override
    @NotNull
    public String getPackageName() {
        String string = this.myPackageName;
        if (string == null) {
            IntelliJCodeElement.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getSimpleClassName() {
        String string = this.mySimpleClassName;
        if (string == null) {
            IntelliJCodeElement.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getMethodName() {
        String string = this.myCodeLocation.getMethodName() == null ? "<unknown method>" : this.myCodeLocation.getMethodName();
        if (string == null) {
            IntelliJCodeElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean isInUserCode() {
        if (IdeInfo.isGameTool()) {
            return false;
        }
        VirtualFile sourceFile = this.myCodeLocation.isNativeCode() ? this.findSourceFile() : this.findClassFile();
        return sourceFile != null && ProjectFileIndex.getInstance((Project)this.myProject).isInSource(sourceFile);
    }

    @Nullable
    private VirtualFile findSourceFile() {
        String sourceFileName = this.myCodeLocation.getFileName();
        if (Strings.isNullOrEmpty((String)sourceFileName)) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(sourceFileName);
    }

    @Nullable
    private VirtualFile findClassFile() {
        PsiClass psiClass;
        if (this.myCachedClassFile != UNRESOLVED_CLASS_FILE) {
            return this.myCachedClassFile;
        }
        String className = this.myCodeLocation.getClassName();
        if (className == null) {
            this.myCachedClassFile = null;
            return null;
        }
        int innerClassSymboldIndex = className.indexOf(36);
        if (innerClassSymboldIndex > 0) {
            className = className.substring(0, innerClassSymboldIndex);
        }
        if ((psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(className, GlobalSearchScope.allScope((Project)this.myProject))) == null) {
            this.myCachedClassFile = null;
            return null;
        }
        this.myCachedClassFile = psiClass.getContainingFile().getVirtualFile();
        return this.myCachedClassFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeLocation";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/inspectors/common/api/ide/stacktrace/IntelliJCodeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/inspectors/common/api/ide/stacktrace/IntelliJCodeElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeLocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleClassName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

