/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.renderers;

import com.intellij.icons.AllIcons;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.JBLabel;
import com.jetbrains.packagesearch.intellij.plugin.ui.PackageSearchUI;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageOperations;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.UiPackageModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.versions.NormalizedPackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.TableColorsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.renderers.PackageVersionTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/renderers/PackageVersionTableCellRenderer;", "Ljavax/swing/table/TableCellRenderer;", "()V", "onlyStable", "", "getTableCellRendererComponent", "Ljavax/swing/JPanel;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "hasFocus", "row", "", "column", "updateData", "", "versionMessage", "", "packageModel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageModel$Installed;", "packageOperations", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageOperations;", "intellij.packageSearch"})
public final class PackageVersionTableCellRenderer
implements TableCellRenderer {
    private boolean onlyStable;

    public final void updateData(boolean onlyStable) {
        this.onlyStable = onlyStable;
    }

    @Override
    @NotNull
    public JPanel getTableCellRendererComponent(@NotNull JTable table, @NotNull Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JBComboBoxLabel labelComponent;
        JBComboBoxLabel jBComboBoxLabel;
        JBComboBoxLabel $this$apply;
        JBComboBoxLabel jBComboBoxLabel2;
        boolean hasVersionsToChooseFrom;
        String string;
        UiPackageModel uiPackageModel;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JPanel $this$apply2 = jPanel = new JPanel((LayoutManager)new MigLayout("al left center, insets 0 8 0 0"));
        boolean bl = false;
        TableColorsKt.getColors(table).applyTo($this$apply2, isSelected);
        Color bgColor = !isSelected && value instanceof UiPackageModel.SearchResult ? (Color)PackageSearchUI.INSTANCE.getListRowHighlightBackground$intellij_packageSearch() : $this$apply2.getBackground();
        $this$apply2.setBackground(bgColor);
        Object object = value;
        if (!(object instanceof UiPackageModel)) {
            object = null;
        }
        UiPackageModel uiPackageModel2 = uiPackageModel = (UiPackageModel)object;
        if (uiPackageModel2 == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        UiPackageModel viewModel = uiPackageModel2;
        UiPackageModel uiPackageModel3 = viewModel;
        if (uiPackageModel3 instanceof UiPackageModel.Installed) {
            string = this.versionMessage(((UiPackageModel.Installed)viewModel).getPackageModel(), viewModel.getPackageOperations());
        } else if (uiPackageModel3 instanceof UiPackageModel.SearchResult) {
            string = viewModel.getSelectedVersion().getDisplayName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String labelText = string;
        Collection collection = viewModel.getSortedVersions();
        boolean bl2 = hasVersionsToChooseFrom = !collection.isEmpty();
        if (hasVersionsToChooseFrom) {
            $this$apply = jBComboBoxLabel2 = new JBComboBoxLabel();
            boolean bl3 = false;
            $this$apply.setIcon(AllIcons.General.LinkDropTriangle);
            $this$apply.setText(labelText);
            jBComboBoxLabel = jBComboBoxLabel2;
        } else {
            $this$apply = jBComboBoxLabel2 = new JBLabel();
            boolean bl4 = false;
            $this$apply.setText(labelText);
            jBComboBoxLabel = jBComboBoxLabel2;
        }
        $this$apply = jBComboBoxLabel2 = (labelComponent = jBComboBoxLabel);
        JPanel jPanel2 = $this$apply2;
        boolean bl5 = false;
        TableColorsKt.getColors(table).applyTo((JComponent)$this$apply, isSelected);
        ((JComponent)$this$apply).setBackground(bgColor);
        Unit unit = Unit.INSTANCE;
        jPanel2.add((Component)jBComboBoxLabel2);
        return jPanel;
    }

    @Nls
    private final String versionMessage(PackageModel.Installed packageModel, PackageOperations packageOperations) {
        StringBuilder stringBuilder;
        boolean bl;
        String installedVersions2 = SequencesKt.joinToString$default((Sequence)SequencesKt.sorted((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)packageModel.getUsageInfo()), (Function1)versionMessage.installedVersions.1.INSTANCE))), null, null, null, (int)0, null, (Function1)versionMessage.installedVersions.2.INSTANCE, (int)31, null);
        CharSequence charSequence = installedVersions2;
        boolean bl2 = bl = !StringsKt.isBlank((CharSequence)charSequence);
        if (!bl) {
            boolean $i$a$-require-PackageVersionTableCellRenderer$versionMessage$22 = false;
            String $i$a$-require-PackageVersionTableCellRenderer$versionMessage$22 = "An installed package cannot produce an empty installed versions list";
            throw new IllegalArgumentException($i$a$-require-PackageVersionTableCellRenderer$versionMessage$22.toString());
        }
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl3 = false;
        $this$buildString.append(installedVersions2);
        if (packageOperations.getCanUpgradePackage()) {
            NormalizedPackageVersion<?> normalizedPackageVersion = packageOperations.getTargetVersion();
            if (normalizedPackageVersion == null) {
            } else {
                NormalizedPackageVersion<?> upgradeVersion = normalizedPackageVersion;
                $this$buildString.append(" \u2192 ");
                $this$buildString.append(upgradeVersion.getDisplayName());
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

