/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.renderers;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.JBColor;
import com.jetbrains.packagesearch.api.v2.ApiStandardPackage;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.UtilsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.PackageSearchUI;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.PackagesTableItem;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.TagComponent;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.TableColorsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.IntScalingExtensionsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.MigLayoutExtensionsKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.UnitValue;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00062\b\b\u0002\u0010\u0013\u001a\u00020\u00062\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0015J6\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J8\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/renderers/PackageNameCellRenderer;", "Ljavax/swing/table/TableCellRenderer;", "()V", "columnConstraints", "Lnet/miginfocom/layout/AC;", "componentGapX", "", "layoutConstraints", "Lnet/miginfocom/layout/LC;", "kotlin.jvm.PlatformType", "tagBackground", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "tagBackgroundSelected", "tagForeground", "tagForegroundSelected", "componentConstraint", "Lnet/miginfocom/layout/CC;", "x", "y", "gapAfter", "(IILjava/lang/Integer;)Lnet/miginfocom/layout/CC;", "createNamePanel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/renderers/PackageNameCellRenderer$TagPaintingJPanel;", "columnWidth", "name", "", "identifier", "isKotlinMultiplatform", "", "isSelected", "getTableCellRendererComponent", "Ljavax/swing/JPanel;", "table", "Ljavax/swing/JTable;", "value", "", "hasFocus", "row", "column", "TagPaintingJPanel", "intellij.packageSearch"})
public final class PackageNameCellRenderer
implements TableCellRenderer {
    private static final LC layoutConstraints;
    private static final int componentGapX;
    private static final AC columnConstraints;
    private static final JBColor tagForeground;
    private static final JBColor tagBackground;
    private static final JBColor tagForegroundSelected;
    private static final JBColor tagBackgroundSelected;
    @NotNull
    public static final PackageNameCellRenderer INSTANCE;

    private final CC componentConstraint(int x, int y, Integer gapAfter) {
        CC cC;
        CC $this$apply = cC = new CC();
        boolean bl = false;
        $this$apply.setCellX(x);
        $this$apply.setCellY(y);
        if (gapAfter != null) {
            $this$apply.gapAfter(String.valueOf(gapAfter));
        }
        return cC;
    }

    static /* synthetic */ CC componentConstraint$default(PackageNameCellRenderer packageNameCellRenderer, int n, int n2, Integer n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = null;
        }
        return packageNameCellRenderer.componentConstraint(n, n2, n3);
    }

    @Override
    @NotNull
    public JPanel getTableCellRendererComponent(@NotNull JTable table, @NotNull Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JTableHeader jTableHeader = table.getTableHeader();
        Intrinsics.checkNotNullExpressionValue((Object)jTableHeader, (String)"table.tableHeader");
        TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(0);
        Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"table.tableHeader.columnModel.getColumn(0)");
        int columnWidth = tableColumn.getWidth();
        PackagesTableItem packagesTableItem = (PackagesTableItem)value;
        if (packagesTableItem instanceof PackagesTableItem.InstalledPackage) {
            TagPaintingJPanel tagPaintingJPanel;
            Object packageModel = ((PackagesTableItem)value).getPackageModel();
            ApiStandardPackage apiStandardPackage = ((PackageModel)packageModel).getRemoteInfo();
            String name = UtilsKt.normalizeWhitespace(apiStandardPackage != null ? apiStandardPackage.getName() : null);
            String rawIdentifier = ((PackageModel)packageModel).getIdentifier-f1q_7Ec();
            TagPaintingJPanel $this$apply = tagPaintingJPanel = this.createNamePanel(columnWidth, name, rawIdentifier, ((PackageModel)packageModel).isKotlinMultiplatform(), isSelected);
            boolean bl = false;
            TableColorsKt.getColors(table).applyTo($this$apply, isSelected);
            jPanel = tagPaintingJPanel;
        } else if (packagesTableItem instanceof PackagesTableItem.InstallablePackage) {
            TagPaintingJPanel tagPaintingJPanel;
            Object packageModel = ((PackagesTableItem)value).getPackageModel();
            ApiStandardPackage apiStandardPackage = ((PackageModel)packageModel).getRemoteInfo();
            String name = UtilsKt.normalizeWhitespace(apiStandardPackage != null ? apiStandardPackage.getName() : null);
            String rawIdentifier = ((PackageModel)packageModel).getIdentifier-f1q_7Ec();
            TagPaintingJPanel $this$apply = tagPaintingJPanel = this.createNamePanel(columnWidth, name, rawIdentifier, ((PackageModel)packageModel).isKotlinMultiplatform(), isSelected);
            boolean bl = false;
            TableColorsKt.getColors(table).applyTo($this$apply, isSelected);
            if (!isSelected) {
                $this$apply.setBackground((Color)PackageSearchUI.INSTANCE.getListRowHighlightBackground$intellij_packageSearch());
            }
            jPanel = tagPaintingJPanel;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jPanel;
    }

    private final TagPaintingJPanel createNamePanel(int columnWidth, @NlsSafe String name, @NlsSafe String identifier, boolean isKotlinMultiplatform, boolean isSelected) {
        Unit unit;
        Object $this$apply;
        TagPaintingJPanel tagPaintingJPanel;
        TagPaintingJPanel tagPaintingJPanel2;
        TagPaintingJPanel $this$apply2 = tagPaintingJPanel2 = new TagPaintingJPanel(columnWidth, isSelected);
        boolean bl = false;
        Object object = name;
        if (!(object == null || StringsKt.isBlank((CharSequence)object)) && Intrinsics.areEqual((Object)name, (Object)identifier) ^ true) {
            Object object2 = object = new JLabel(name);
            tagPaintingJPanel = $this$apply2;
            boolean bl2 = false;
            ((JComponent)$this$apply).setForeground(PackageSearchUI.INSTANCE.getTextColorPrimary$intellij_packageSearch(isSelected));
            unit = Unit.INSTANCE;
            tagPaintingJPanel.add((Component)object, PackageNameCellRenderer.componentConstraint$default(INSTANCE, 0, 0, componentGapX, 3, null));
            $this$apply = object = new JLabel(identifier);
            tagPaintingJPanel = $this$apply2;
            boolean bl3 = false;
            ((JComponent)$this$apply).setForeground(PackageSearchUI.INSTANCE.getTextColorSecondary$intellij_packageSearch(isSelected));
            unit = Unit.INSTANCE;
            tagPaintingJPanel.add((Component)object, PackageNameCellRenderer.componentConstraint$default(INSTANCE, 0, 0, null, 7, null).gapAfter("0:push"));
        } else {
            $this$apply = object = new JLabel(identifier);
            tagPaintingJPanel = $this$apply2;
            boolean bl4 = false;
            ((JComponent)$this$apply).setForeground(PackageSearchUI.INSTANCE.getTextColorPrimary$intellij_packageSearch(isSelected));
            unit = Unit.INSTANCE;
            tagPaintingJPanel.add((Component)object, PackageNameCellRenderer.componentConstraint$default(INSTANCE, 0, 0, null, 7, null));
        }
        if (isKotlinMultiplatform) {
            $this$apply = object = new TagComponent(PackageSearchBundle.INSTANCE.message("packagesearch.terminology.kotlinMultiplatform", new Object[0]));
            tagPaintingJPanel = $this$apply2;
            boolean bl5 = false;
            ((JComponent)$this$apply).setVisible(false);
            unit = Unit.INSTANCE;
            tagPaintingJPanel.add((Component)object, PackageNameCellRenderer.componentConstraint$default(INSTANCE, 1, 0, null, 4, null));
        }
        return tagPaintingJPanel2;
    }

    private PackageNameCellRenderer() {
    }

    static {
        DimConstraint $this$apply;
        DimConstraint[] dimConstraintArray;
        DimConstraint dimConstraint;
        AC aC;
        PackageNameCellRenderer packageNameCellRenderer;
        INSTANCE = packageNameCellRenderer = new PackageNameCellRenderer();
        LC lC = new LC().align("left", "center");
        Intrinsics.checkNotNullExpressionValue((Object)lC, (String)"LC().align(\"left\", \"center\")");
        layoutConstraints = MigLayoutExtensionsKt.scaledInsets$default(lC, 0, 8, 0, 0, 5, null);
        componentGapX = IntScalingExtensionsKt.scaled(4);
        AC $this$apply2 = aC = new AC();
        boolean bl = false;
        $this$apply2.gap(String.valueOf(componentGapX));
        DimConstraint dimConstraint2 = dimConstraint = new DimConstraint();
        int n = 0;
        DimConstraint[] dimConstraintArray2 = dimConstraintArray = new DimConstraint[2];
        AC aC2 = $this$apply2;
        boolean bl2 = false;
        $this$apply2.gap(String.valueOf(componentGapX));
        $this$apply.setSize(new BoundSize(new UnitValue(150.0f, 0, ""), ""));
        Unit unit = Unit.INSTANCE;
        dimConstraintArray[n] = dimConstraint;
        $this$apply = dimConstraint = new DimConstraint();
        n = 1;
        dimConstraintArray = dimConstraintArray2;
        boolean bl3 = false;
        $this$apply.setGapBefore(new BoundSize(new UnitValue((float)componentGapX / 2.0f), ""));
        unit = Unit.INSTANCE;
        dimConstraintArray[n] = dimConstraint;
        aC2.setConstaints(dimConstraintArray2);
        columnConstraints = aC;
        JBColor jBColor = JBColor.namedColor((String)"PackageSearch.PackageTag.foreground", (int)0x808080, (int)0x9C9C9C);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.namedColor(\"Pack\u2026und\", 0x808080, 0x9C9C9C)");
        tagForeground = jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"PackageSearch.PackageTag.background", (int)0xE5E5E5, (int)0x666B6E);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"JBColor.namedColor(\"Pack\u2026und\", 0xE5E5E5, 0x666B6E)");
        tagBackground = jBColor2;
        JBColor jBColor3 = JBColor.namedColor((String)"PackageSearch.PackageTagSelected.foreground", (int)0xFFFFFF, (int)0xFFFFFF);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor3, (String)"JBColor.namedColor(\"Pack\u2026und\", 0xFFFFFF, 0xFFFFFF)");
        tagForegroundSelected = jBColor3;
        JBColor jBColor4 = JBColor.namedColor((String)"PackageSearch.PackageTagSelected.background", (int)4429282, (int)7908834);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor4, (String)"JBColor.namedColor(\"Pack\u2026und\", 0x4395E2, 0x78ADE2)");
        tagBackgroundSelected = jBColor4;
    }

    public static final /* synthetic */ int access$getComponentGapX$p(PackageNameCellRenderer $this) {
        PackageNameCellRenderer packageNameCellRenderer = $this;
        return componentGapX;
    }

    public static final /* synthetic */ JBColor access$getTagForegroundSelected$p(PackageNameCellRenderer $this) {
        PackageNameCellRenderer packageNameCellRenderer = $this;
        return tagForegroundSelected;
    }

    public static final /* synthetic */ JBColor access$getTagForeground$p(PackageNameCellRenderer $this) {
        PackageNameCellRenderer packageNameCellRenderer = $this;
        return tagForeground;
    }

    public static final /* synthetic */ JBColor access$getTagBackgroundSelected$p(PackageNameCellRenderer $this) {
        PackageNameCellRenderer packageNameCellRenderer = $this;
        return tagBackgroundSelected;
    }

    public static final /* synthetic */ JBColor access$getTagBackground$p(PackageNameCellRenderer $this) {
        PackageNameCellRenderer packageNameCellRenderer = $this;
        return tagBackground;
    }

    public static final /* synthetic */ LC access$getLayoutConstraints$p(PackageNameCellRenderer $this) {
        PackageNameCellRenderer packageNameCellRenderer = $this;
        return layoutConstraints;
    }

    public static final /* synthetic */ AC access$getColumnConstraints$p(PackageNameCellRenderer $this) {
        PackageNameCellRenderer packageNameCellRenderer = $this;
        return columnConstraints;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/renderers/PackageNameCellRenderer$TagPaintingJPanel;", "Ljavax/swing/JPanel;", "columnWidth", "", "isSelected", "", "(IZ)V", "paintChildren", "", "g", "Ljava/awt/Graphics;", "intellij.packageSearch"})
    private static final class TagPaintingJPanel
    extends JPanel {
        private final int columnWidth;
        private final boolean isSelected;

        @Override
        protected void paintChildren(@NotNull Graphics g) {
            TagComponent tagComponent;
            Graphics graphics;
            Component component;
            Component component2;
            block3: {
                Component[] componentArray;
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paintChildren(g);
                Component[] componentArray2 = this.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray2, (String)"components");
                Component[] componentArray3 = componentArray = componentArray2;
                int n = componentArray3.length;
                for (int i = 0; i < n; ++i) {
                    Component component3;
                    Component it = component3 = componentArray3[i];
                    boolean bl = false;
                    if (!(it instanceof TagComponent)) continue;
                    component2 = component3;
                    break block3;
                }
                component2 = component = null;
            }
            if (!(component2 instanceof TagComponent)) {
                component = null;
            }
            TagComponent tagComponent2 = (TagComponent)component;
            if (tagComponent2 == null) {
                return;
            }
            TagComponent tagComponent3 = tagComponent2;
            int tagX = this.columnWidth - tagComponent3.getWidth();
            int tagY = this.getHeight() / 2 - tagComponent3.getHeight() / 2;
            Graphics $this$apply = graphics = g;
            boolean bl = false;
            $this$apply.setColor(this.getBackground());
            $this$apply.fillRect(tagX - PackageNameCellRenderer.access$getComponentGapX$p(INSTANCE), 0, this.columnWidth - tagX, this.getHeight());
            $this$apply.translate(tagX, tagY);
            TagComponent $this$apply2 = tagComponent = tagComponent3;
            boolean bl2 = false;
            $this$apply2.setVisible(true);
            $this$apply2.setForeground((Color)JBColor.namedColor((String)"Plugins.tagForeground", (Color)((Color)(this.isSelected ? PackageNameCellRenderer.access$getTagForegroundSelected$p(INSTANCE) : PackageNameCellRenderer.access$getTagForeground$p(INSTANCE)))));
            $this$apply2.setBackground((Color)JBColor.namedColor((String)"Plugins.tagBackground", (Color)((Color)(this.isSelected ? PackageNameCellRenderer.access$getTagBackgroundSelected$p(INSTANCE) : PackageNameCellRenderer.access$getTagBackground$p(INSTANCE)))));
            $this$apply2.paint(g);
        }

        public TagPaintingJPanel(int columnWidth, boolean isSelected) {
            super((LayoutManager)new MigLayout(PackageNameCellRenderer.access$getLayoutConstraints$p(INSTANCE).width(columnWidth + "px!"), PackageNameCellRenderer.access$getColumnConstraints$p(INSTANCE)));
            this.columnWidth = columnWidth;
            this.isSelected = isSelected;
            this.setSize(new Dimension(this.columnWidth, this.getHeight()));
            this.setMaximumSize(new Dimension(this.columnWidth, Integer.MAX_VALUE));
        }
    }
}

