/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.other.watchFaceService.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"myDigitalWatchFaceServiceJava", "", "isInteractive", "", "packageName", "serviceClass", "useAndroidX", "intellij.android.wizardTemplate.impl"})
public final class MyDigitalWatchFaceServiceJavaKt {
    @NotNull
    public static final String myDigitalWatchFaceServiceJava(boolean isInteractive, @NotNull String packageName, @NotNull String serviceClass, boolean useAndroidX) {
        String string;
        String string2;
        boolean bl;
        String it$iv;
        boolean bl2;
        String string3;
        boolean bl3;
        String string4;
        String string5;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)serviceClass, (String)"serviceClass");
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = stringBuilder2.append("\npackage ").append(packageName).append(";\n\nimport android.content.BroadcastReceiver;\nimport android.content.Context;\nimport android.content.Intent;\nimport android.content.IntentFilter;\nimport android.content.res.Resources;\nimport android.graphics.Canvas;\nimport android.graphics.Color;\nimport android.graphics.Paint;\nimport android.graphics.Rect;\nimport android.graphics.Typeface;\nimport android.os.Bundle;\nimport android.os.Handler;\nimport android.os.Message;\nimport ").append(TemplateHelpersKt.getMaterialComponentName("android.support.v4.content.ContextCompat", useAndroidX)).append(";\nimport android.support.wearable.watchface.CanvasWatchFaceService;\nimport android.support.wearable.watchface.WatchFaceStyle;\nimport android.view.SurfaceHolder;\nimport android.view.WindowInsets;\n");
        boolean trim$iv = true;
        boolean skipLine$iv = true;
        boolean $i$f$renderIf = false;
        if (isInteractive) {
            stringBuilder = stringBuilder3;
            boolean bl4 = false;
            string5 = "import android.widget.Toast;";
            stringBuilder3 = stringBuilder;
            string4 = string5;
            bl3 = false;
            string3 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string4 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            bl3 = false;
            bl2 = false;
            it$iv = string4;
            bl = false;
            bl3 = false;
            string3 = string4;
            if (string3 == null) {
                string3 = "";
            }
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nimport java.lang.ref.WeakReference;\nimport java.util.Calendar;\nimport java.util.TimeZone;\nimport java.util.concurrent.TimeUnit;\n\n/**\n * Digital watch face with seconds. In ambient mode, the seconds aren\"t displayed. On devices with\n * low-bit ambient mode, the text is drawn without anti-aliasing in ambient mode.\n *\n * Important Note: Because watch face apps do not have a default Activity in\n * their project, you will need to set your Configurations to\n * \"Do not launch Activity\" for both the Wear and/or Application modules. If you\n * are unsure how to do this, please review the \"Run Starter project\" section\n * in the Google Watch Face Code Lab:\n * https://codelabs.developers.google.com/codelabs/watchface/index.html#0\n */\npublic class ").append(serviceClass).append(" extends CanvasWatchFaceService {\n    private static final Typeface NORMAL_TYPEFACE =\n            Typeface.create(Typeface.SANS_SERIF, Typeface.NORMAL);\n\n    /**\n     * Update rate in milliseconds for interactive mode. Defaults to one second\n     * because the watch face needs to update seconds in interactive mode.\n     */\n    private static final long INTERACTIVE_UPDATE_RATE_MS = TimeUnit.SECONDS.toMillis(1);\n\n    /**\n     * Handler message id for updating the time periodically in interactive mode.\n     */\n    private static final int MSG_UPDATE_TIME = 0;\n\n    @Override\n    public Engine onCreateEngine() {\n        return new Engine();\n    }\n\n    private class Engine extends CanvasWatchFaceService.Engine {\n\n        private Calendar mCalendar;\n\n        private boolean mRegisteredTimeZoneReceiver = false;\n\n        private float mXOffset;\n        private float mYOffset;\n\n        private Paint mBackgroundPaint;\n        private Paint mTextPaint;\n\n        /**\n         * Whether the display supports fewer bits for each color in ambient mode. When true, we\n         * disable anti-aliasing in ambient mode.\n         */\n        private boolean mLowBitAmbient;\n        private boolean mBurnInProtection;\n        private boolean mAmbient;\n\n        private final Handler mUpdateTimeHandler = new EngineHandler(this);\n\n        private final BroadcastReceiver mTimeZoneReceiver = new BroadcastReceiver() {\n            @Override\n            public void onReceive(Context context, Intent intent) {\n                mCalendar.setTimeZone(TimeZone.getDefault());\n                invalidate();\n            }\n        };\n\n        @Override\n        public void onCreate(SurfaceHolder holder) {\n            super.onCreate(holder);\n\n            setWatchFaceStyle(new WatchFaceStyle.Builder(").append(serviceClass).append(".this)\n                    ");
        trim$iv = true;
        skipLine$iv = true;
        $i$f$renderIf = false;
        if (isInteractive) {
            stringBuilder = stringBuilder4;
            boolean bl5 = false;
            string5 = ".setAcceptsTapEvents(true)";
            stringBuilder4 = stringBuilder;
            string4 = string5;
            bl3 = false;
            string2 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string4 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            bl3 = false;
            bl2 = false;
            it$iv = string4;
            bl = false;
            bl3 = false;
            string2 = string4;
            if (string2 == null) {
                string2 = "";
            }
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string2).append("\n                    .build());\n\n            mCalendar = Calendar.getInstance();\n\n            Resources resources = ").append(serviceClass).append(".this.getResources();\n            mYOffset = resources.getDimension(R.dimen.digital_y_offset);\n\n            // Initializes background.\n            mBackgroundPaint = new Paint();\n            mBackgroundPaint.setColor(\n                    ContextCompat.getColor(getApplicationContext(), R.color.background));\n\n\n            // Initializes Watch Face.\n            mTextPaint = new Paint();\n            mTextPaint.setTypeface(NORMAL_TYPEFACE);\n            mTextPaint.setAntiAlias(true);\n            mTextPaint.setColor(\n                    ContextCompat.getColor(getApplicationContext(), R.color.digital_text));\n        }\n\n        @Override\n        public void onDestroy() {\n            mUpdateTimeHandler.removeMessages(MSG_UPDATE_TIME);\n            super.onDestroy();\n        }\n\n        @Override\n        public void onVisibilityChanged(boolean visible) {\n            super.onVisibilityChanged(visible);\n\n            if (visible) {\n                registerReceiver();\n\n                // Update time zone in case it changed while we weren\"t visible.\n                mCalendar.setTimeZone(TimeZone.getDefault());\n                invalidate();\n            } else {\n                unregisterReceiver();\n            }\n\n            // Whether the timer should be running depends on whether we\"re visible (as well as\n            // whether we\"re in ambient mode), so we may need to start or stop the timer.\n            updateTimer();\n        }\n\n        private void registerReceiver() {\n            if (mRegisteredTimeZoneReceiver) {\n                return;\n            }\n            mRegisteredTimeZoneReceiver = true;\n            IntentFilter filter = new IntentFilter(Intent.ACTION_TIMEZONE_CHANGED);\n            ").append(serviceClass).append(".this.registerReceiver(mTimeZoneReceiver, filter);\n        }\n\n        private void unregisterReceiver() {\n            if (!mRegisteredTimeZoneReceiver) {\n                return;\n            }\n            mRegisteredTimeZoneReceiver = false;\n            ").append(serviceClass).append(".this.unregisterReceiver(mTimeZoneReceiver);\n        }\n\n        @Override\n        public void onApplyWindowInsets(WindowInsets insets) {\n            super.onApplyWindowInsets(insets);\n\n            // Load resources that have alternate values for round watches.\n            Resources resources = ").append(serviceClass).append(".this.getResources();\n            boolean isRound = insets.isRound();\n            mXOffset = resources.getDimension(isRound\n                    ? R.dimen.digital_x_offset_round : R.dimen.digital_x_offset);\n            float textSize = resources.getDimension(isRound\n                    ? R.dimen.digital_text_size_round : R.dimen.digital_text_size);\n\n            mTextPaint.setTextSize(textSize);\n        }\n\n        @Override\n        public void onPropertiesChanged(Bundle properties) {\n            super.onPropertiesChanged(properties);\n            mLowBitAmbient = properties.getBoolean(PROPERTY_LOW_BIT_AMBIENT, false);\n            mBurnInProtection = properties.getBoolean(PROPERTY_BURN_IN_PROTECTION, false);\n        }\n\n        @Override\n        public void onTimeTick() {\n            super.onTimeTick();\n            invalidate();\n        }\n\n        @Override\n        public void onAmbientModeChanged(boolean inAmbientMode) {\n            super.onAmbientModeChanged(inAmbientMode);\n\n            mAmbient = inAmbientMode;\n            if (mLowBitAmbient) {\n                mTextPaint.setAntiAlias(!inAmbientMode);\n            }\n\n            // Whether the timer should be running depends on whether we\"re visible (as well as\n            // whether we\"re in ambient mode), so we may need to start or stop the timer.\n            updateTimer();\n        }\n\n");
        trim$iv = true;
        skipLine$iv = true;
        $i$f$renderIf = false;
        if (isInteractive) {
            stringBuilder = stringBuilder5;
            boolean bl6 = false;
            string5 = "\n        /**\n         * Captures tap event (and tap type) and toggles the background color if the user finishes\n         * a tap.\n         */\n        @Override\n        public void onTapCommand(int tapType, int x, int y, long eventTime) {\n            switch (tapType) {\n                case TAP_TYPE_TOUCH:\n                    // The user has started touching the screen.\n                    break;\n                case TAP_TYPE_TOUCH_CANCEL:\n                    // The user has started a different gesture or otherwise cancelled the tap.\n                    break;\n                case TAP_TYPE_TAP:\n                    // The user has completed the tap gesture.\n                    // TODO: Add code to handle the tap gesture.\n                    Toast.makeText(getApplicationContext(), R.string.message, Toast.LENGTH_SHORT)\n                            .show();\n                    break;\n            }\n            invalidate();\n        }\n";
            stringBuilder5 = stringBuilder;
            string4 = string5;
            bl3 = false;
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string4 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            bl3 = false;
            bl2 = false;
            it$iv = string4;
            bl = false;
            bl3 = false;
            string = string4;
            if (string == null) {
                string = "";
            }
        }
        stringBuilder5.append(string).append("\n\n        @Override\n        public void onDraw(Canvas canvas, Rect bounds) {\n            // Draw the background.\n            if (isInAmbientMode()) {\n                canvas.drawColor(Color.BLACK);\n            } else {\n                canvas.drawRect(0, 0, bounds.width(), bounds.height(), mBackgroundPaint);\n            }\n\n            // Draw H:MM in ambient mode or H:MM:SS in interactive mode.\n            long now = System.currentTimeMillis();\n            mCalendar.setTimeInMillis(now);\n\n            String text = mAmbient\n                    ? String.format(\"%d:%02d\", mCalendar.get(Calendar.HOUR),\n                            mCalendar.get(Calendar.MINUTE))\n                    : String.format(\"%d:%02d:%02d\", mCalendar.get(Calendar.HOUR),\n                            mCalendar.get(Calendar.MINUTE), mCalendar.get(Calendar.SECOND));\n            canvas.drawText(text, mXOffset, mYOffset, mTextPaint);\n        }\n\n        /**\n         * Starts the {@link #mUpdateTimeHandler} timer if it should be running and isn\"t currently\n         * or stops it if it shouldn\"t be running but currently is.\n         */\n        private void updateTimer() {\n            mUpdateTimeHandler.removeMessages(MSG_UPDATE_TIME);\n            if (shouldTimerBeRunning()) {\n                mUpdateTimeHandler.sendEmptyMessage(MSG_UPDATE_TIME);\n            }\n        }\n\n        /**\n         * Returns whether the {@link #mUpdateTimeHandler} timer should be running. The timer should\n         * only run when we\"re visible and in interactive mode.\n         */\n        private boolean shouldTimerBeRunning() {\n            return isVisible() && !isInAmbientMode();\n        }\n\n        /**\n         * Handle updating the time periodically in interactive mode.\n         */\n        private void handleUpdateTimeMessage() {\n            invalidate();\n            if (shouldTimerBeRunning()) {\n                long timeMs = System.currentTimeMillis();\n                long delayMs = INTERACTIVE_UPDATE_RATE_MS\n                        - (timeMs % INTERACTIVE_UPDATE_RATE_MS);\n                mUpdateTimeHandler.sendEmptyMessageDelayed(MSG_UPDATE_TIME, delayMs);\n            }\n        }\n    }\n\n    private static class EngineHandler extends Handler {\n        private final WeakReference<");
        stringBuilder2.append(serviceClass).append(".Engine> mWeakReference;\n\n        public EngineHandler(").append(serviceClass).append(".Engine reference) {\n            mWeakReference = new WeakReference<>(reference);\n        }\n\n        @Override\n        public void handleMessage(Message msg) {\n            ").append(serviceClass).append(".Engine engine = mWeakReference.get();\n            if (engine != null) {\n                switch (msg.what) {\n                    case MSG_UPDATE_TIME:\n                        engine.handleUpdateTimeMessage();\n                        break;\n                }\n            }\n        }\n    }\n}\n");
        return stringBuilder2.toString();
    }
}

