/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.other.watchFaceService.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"myAnalogWatchFaceServiceKt", "", "isInteractive", "", "packageName", "serviceClass", "useAndroidX", "intellij.android.wizardTemplate.impl"})
public final class MyAnalogWatchFaceServiceKtKt {
    @NotNull
    public static final String myAnalogWatchFaceServiceKt(boolean isInteractive, @NotNull String packageName, @NotNull String serviceClass, boolean useAndroidX) {
        String string;
        String string2;
        boolean bl;
        String it$iv;
        boolean bl2;
        String string3;
        boolean bl3;
        String string4;
        String string5;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)serviceClass, (String)"serviceClass");
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = stringBuilder2.append("\npackage ").append(TemplateHelpersKt.escapeKotlinIdentifier(packageName)).append("\n\nimport android.content.BroadcastReceiver\nimport android.content.Context\nimport android.content.Intent\nimport android.content.IntentFilter\nimport android.graphics.Bitmap\nimport android.graphics.BitmapFactory\nimport android.graphics.Canvas\nimport android.graphics.Color\nimport android.graphics.ColorMatrix\nimport android.graphics.ColorMatrixColorFilter\nimport android.graphics.Paint\nimport android.graphics.Rect\nimport android.os.Bundle\nimport android.os.Handler\nimport android.os.Looper\nimport android.os.Message\nimport ").append(TemplateHelpersKt.getMaterialComponentName("android.support.v7.graphics.Palette", useAndroidX)).append("\nimport android.support.wearable.watchface.CanvasWatchFaceService\nimport android.support.wearable.watchface.WatchFaceService\nimport android.support.wearable.watchface.WatchFaceStyle\nimport android.view.SurfaceHolder\n");
        boolean trim$iv = true;
        boolean skipLine$iv = true;
        boolean $i$f$renderIf = false;
        if (isInteractive) {
            stringBuilder = stringBuilder3;
            boolean bl4 = false;
            string5 = "import android.widget.Toast";
            stringBuilder3 = stringBuilder;
            string4 = string5;
            bl3 = false;
            string3 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string4 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            bl3 = false;
            bl2 = false;
            it$iv = string4;
            bl = false;
            bl3 = false;
            string3 = string4;
            if (string3 == null) {
                string3 = "";
            }
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append("\n\nimport java.lang.ref.WeakReference\nimport java.util.Calendar\nimport java.util.TimeZone\n\n/**\n * Updates rate in milliseconds for interactive mode. We update once a second to advance the\n * second hand.\n */\nprivate const val INTERACTIVE_UPDATE_RATE_MS = 1000\n\n/**\n * Handler message id for updating the time periodically in interactive mode.\n */\nprivate const val MSG_UPDATE_TIME = 0\n\nprivate const val HOUR_STROKE_WIDTH = 5f\nprivate const val MINUTE_STROKE_WIDTH = 3f\nprivate const val SECOND_TICK_STROKE_WIDTH = 2f\n\nprivate const val CENTER_GAP_AND_CIRCLE_RADIUS = 4f\n\nprivate const val SHADOW_RADIUS = 6f\n\n/**\n * Analog watch face with a ticking second hand. In ambient mode, the second hand isn\"t\n * shown. On devices with low-bit ambient mode, the hands are drawn without anti-aliasing in ambient\n * mode. The watch face is drawn with less contrast in mute mode.\n *\n *\n * Important Note: Because watch face apps do not have a default Activity in\n * their project, you will need to set your Configurations to\n * \"Do not launch Activity\" for both the Wear and/or Application modules. If you\n * are unsure how to do this, please review the \"Run Starter project\" section\n * in the Google Watch Face Code Lab:\n * https://codelabs.developers.google.com/codelabs/watchface/index.html#0\n */\nclass ").append(serviceClass).append(" : CanvasWatchFaceService() {\n\n    override fun onCreateEngine(): Engine {\n        return Engine()\n    }\n\n    private class EngineHandler(reference: ").append(serviceClass).append(".Engine) : Handler(Looper.myLooper()!!) {\n        private val mWeakReference: WeakReference<").append(serviceClass).append(".Engine> = WeakReference(reference)\n\n        override fun handleMessage(msg: Message) {\n            val engine = mWeakReference.get()\n            if (engine != null) {\n                when (msg.what) {\n                    MSG_UPDATE_TIME -> engine.handleUpdateTimeMessage()\n                }\n            }\n        }\n    }\n\n    inner class Engine : CanvasWatchFaceService.Engine() {\n\n        private lateinit var mCalendar: Calendar\n\n        private var mRegisteredTimeZoneReceiver = false\n        private var mMuteMode: Boolean = false\n        private var mCenterX: Float = 0F\n        private var mCenterY: Float = 0F\n\n        private var mSecondHandLength: Float = 0F\n        private var sMinuteHandLength: Float = 0F\n        private var sHourHandLength: Float = 0F\n\n        /* Colors for all hands (hour, minute, seconds, ticks) based on photo loaded. */\n        private var mWatchHandColor: Int = 0\n        private var mWatchHandHighlightColor: Int = 0\n        private var mWatchHandShadowColor: Int = 0\n\n        private lateinit var mHourPaint: Paint\n        private lateinit var mMinutePaint: Paint\n        private lateinit var mSecondPaint: Paint\n        private lateinit var mTickAndCirclePaint: Paint\n\n        private lateinit var mBackgroundPaint: Paint\n        private lateinit var mBackgroundBitmap: Bitmap\n        private lateinit var mGrayBackgroundBitmap: Bitmap\n\n        private var mAmbient: Boolean = false\n        private var mLowBitAmbient: Boolean = false\n        private var mBurnInProtection: Boolean = false\n\n        /* Handler to update the time once a second in interactive mode. */\n        private val mUpdateTimeHandler = EngineHandler(this)\n\n        private val mTimeZoneReceiver = object : BroadcastReceiver() {\n            override fun onReceive(context: Context, intent: Intent) {\n                mCalendar.timeZone = TimeZone.getDefault()\n                invalidate()\n            }\n        }\n\n        override fun onCreate(holder: SurfaceHolder) {\n            super.onCreate(holder)\n\n            setWatchFaceStyle(WatchFaceStyle.Builder(this@").append(serviceClass).append(")\n                    ");
        trim$iv = true;
        skipLine$iv = true;
        $i$f$renderIf = false;
        if (isInteractive) {
            stringBuilder = stringBuilder4;
            boolean bl5 = false;
            string5 = ".setAcceptsTapEvents(true)";
            stringBuilder4 = stringBuilder;
            string4 = string5;
            bl3 = false;
            string2 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string4 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            bl3 = false;
            bl2 = false;
            it$iv = string4;
            bl = false;
            bl3 = false;
            string2 = string4;
            if (string2 == null) {
                string2 = "";
            }
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string2).append("\n                    .build())\n\n            mCalendar = Calendar.getInstance()\n\n            initializeBackground()\n            initializeWatchFace()\n        }\n\n        private fun initializeBackground() {\n            mBackgroundPaint = Paint().apply {\n                color = Color.BLACK\n            }\n            mBackgroundBitmap = BitmapFactory.decodeResource(resources, R.drawable.watchface_service_bg)\n\n            /* Extracts colors from background image to improve watchface style. */\n            Palette.from(mBackgroundBitmap).generate {\n                it?.let {\n                    mWatchHandHighlightColor = it.getVibrantColor(Color.RED)\n                    mWatchHandColor = it.getLightVibrantColor(Color.WHITE)\n                    mWatchHandShadowColor = it.getDarkMutedColor(Color.BLACK)\n                    updateWatchHandStyle()\n                }\n            }\n        }\n\n        private fun initializeWatchFace() {\n            /* Set defaults for colors */\n            mWatchHandColor = Color.WHITE\n            mWatchHandHighlightColor = Color.RED\n            mWatchHandShadowColor = Color.BLACK\n\n            mHourPaint = Paint().apply {\n                color = mWatchHandColor\n                strokeWidth = HOUR_STROKE_WIDTH\n                isAntiAlias = true\n                strokeCap = Paint.Cap.ROUND\n                setShadowLayer(\n                        SHADOW_RADIUS, 0f, 0f, mWatchHandShadowColor)\n            }\n\n            mMinutePaint = Paint().apply {\n                color = mWatchHandColor\n                strokeWidth = MINUTE_STROKE_WIDTH\n                isAntiAlias = true\n                strokeCap = Paint.Cap.ROUND\n                setShadowLayer(\n                        SHADOW_RADIUS, 0f, 0f, mWatchHandShadowColor)\n            }\n\n            mSecondPaint = Paint().apply {\n                color = mWatchHandHighlightColor\n                strokeWidth = SECOND_TICK_STROKE_WIDTH\n                isAntiAlias = true\n                strokeCap = Paint.Cap.ROUND\n                setShadowLayer(\n                        SHADOW_RADIUS, 0f, 0f, mWatchHandShadowColor)\n            }\n\n            mTickAndCirclePaint = Paint().apply {\n                color = mWatchHandColor\n                strokeWidth = SECOND_TICK_STROKE_WIDTH\n                isAntiAlias = true\n                style = Paint.Style.STROKE\n                setShadowLayer(\n                        SHADOW_RADIUS, 0f, 0f, mWatchHandShadowColor)\n            }\n        }\n\n        override fun onDestroy() {\n            mUpdateTimeHandler.removeMessages(MSG_UPDATE_TIME)\n            super.onDestroy()\n        }\n\n        override fun onPropertiesChanged(properties: Bundle) {\n            super.onPropertiesChanged(properties)\n            mLowBitAmbient = properties.getBoolean(\n                    WatchFaceService.PROPERTY_LOW_BIT_AMBIENT, false)\n            mBurnInProtection = properties.getBoolean(\n                    WatchFaceService.PROPERTY_BURN_IN_PROTECTION, false)\n        }\n\n        override fun onTimeTick() {\n            super.onTimeTick()\n            invalidate()\n        }\n\n        override fun onAmbientModeChanged(inAmbientMode: Boolean) {\n            super.onAmbientModeChanged(inAmbientMode)\n            mAmbient = inAmbientMode\n\n            updateWatchHandStyle()\n\n            // Check and trigger whether or not timer should be running (only\n            // in active mode).\n            updateTimer()\n        }\n\n        private fun updateWatchHandStyle() {\n            if (mAmbient) {\n                mHourPaint.color = Color.WHITE\n                mMinutePaint.color = Color.WHITE\n                mSecondPaint.color = Color.WHITE\n                mTickAndCirclePaint.color = Color.WHITE\n\n                mHourPaint.isAntiAlias = false\n                mMinutePaint.isAntiAlias = false\n                mSecondPaint.isAntiAlias = false\n                mTickAndCirclePaint.isAntiAlias = false\n\n                mHourPaint.clearShadowLayer()\n                mMinutePaint.clearShadowLayer()\n                mSecondPaint.clearShadowLayer()\n                mTickAndCirclePaint.clearShadowLayer()\n\n            } else {\n                mHourPaint.color = mWatchHandColor\n                mMinutePaint.color = mWatchHandColor\n                mSecondPaint.color = mWatchHandHighlightColor\n                mTickAndCirclePaint.color = mWatchHandColor\n\n                mHourPaint.isAntiAlias = true\n                mMinutePaint.isAntiAlias = true\n                mSecondPaint.isAntiAlias = true\n                mTickAndCirclePaint.isAntiAlias = true\n\n                mHourPaint.setShadowLayer(\n                        SHADOW_RADIUS, 0f, 0f, mWatchHandShadowColor)\n                mMinutePaint.setShadowLayer(\n                        SHADOW_RADIUS, 0f, 0f, mWatchHandShadowColor)\n                mSecondPaint.setShadowLayer(\n                        SHADOW_RADIUS, 0f, 0f, mWatchHandShadowColor)\n                mTickAndCirclePaint.setShadowLayer(\n                        SHADOW_RADIUS, 0f, 0f, mWatchHandShadowColor)\n            }\n        }\n\n        override fun onInterruptionFilterChanged(interruptionFilter: Int) {\n            super.onInterruptionFilterChanged(interruptionFilter)\n            val inMuteMode = interruptionFilter == WatchFaceService.INTERRUPTION_FILTER_NONE\n\n            /* Dim display in mute mode. */\n            if (mMuteMode != inMuteMode) {\n                mMuteMode = inMuteMode\n                mHourPaint.alpha = if (inMuteMode) 100 else 255\n                mMinutePaint.alpha = if (inMuteMode) 100 else 255\n                mSecondPaint.alpha = if (inMuteMode) 80 else 255\n                invalidate()\n            }\n        }\n\n        override fun onSurfaceChanged(holder: SurfaceHolder, format: Int, width: Int, height: Int) {\n            super.onSurfaceChanged(holder, format, width, height)\n\n            /*\n             * Find the coordinates of the center point on the screen, and ignore the window\n             * insets, so that, on round watches with a \"chin\", the watch face is centered on the\n             * entire screen, not just the usable portion.\n             */\n            mCenterX = width / 2f\n            mCenterY = height / 2f\n\n            /*\n             * Calculate lengths of different hands based on watch screen size.\n             */\n            mSecondHandLength = (mCenterX * 0.875).toFloat()\n            sMinuteHandLength = (mCenterX * 0.75).toFloat()\n            sHourHandLength = (mCenterX * 0.5).toFloat()\n\n\n            /* Scale loaded background image (more efficient) if surface dimensions change. */\n            val scale = width.toFloat() / mBackgroundBitmap.width.toFloat()\n\n            mBackgroundBitmap = Bitmap.createScaledBitmap(mBackgroundBitmap,\n                    (mBackgroundBitmap.width * scale).toInt(),\n                    (mBackgroundBitmap.height * scale).toInt(), true)\n\n            /*\n             * Create a gray version of the image only if it will look nice on the device in\n             * ambient mode. That means we don\"t want devices that support burn-in\n             * protection (slight movements in pixels, not great for images going all the way to\n             * edges) and low ambient mode (degrades image quality).\n             *\n             * Also, if your watch face will know about all images ahead of time (users aren\"t\n             * selecting their own photos for the watch face), it will be more\n             * efficient to create a black/white version (png, etc.) and load that when you need it.\n             */\n            if (!mBurnInProtection && !mLowBitAmbient) {\n                initGrayBackgroundBitmap()\n            }\n        }\n\n        private fun initGrayBackgroundBitmap() {\n            mGrayBackgroundBitmap = Bitmap.createBitmap(\n                    mBackgroundBitmap.width,\n                    mBackgroundBitmap.height,\n                    Bitmap.Config.ARGB_8888)\n            val canvas = Canvas(mGrayBackgroundBitmap)\n            val grayPaint = Paint()\n            val colorMatrix = ColorMatrix()\n            colorMatrix.setSaturation(0f)\n            val filter = ColorMatrixColorFilter(colorMatrix)\n            grayPaint.colorFilter = filter\n            canvas.drawBitmap(mBackgroundBitmap, 0f, 0f, grayPaint)\n        }\n\n");
        trim$iv = true;
        skipLine$iv = true;
        $i$f$renderIf = false;
        if (isInteractive) {
            stringBuilder = stringBuilder5;
            boolean bl6 = false;
            string5 = "\n        /**\n         * Captures tap event (and tap type). The [WatchFaceService.TAP_TYPE_TAP] case can be\n         * used for implementing specific logic to handle the gesture.\n         */\n        override fun onTapCommand(tapType: Int, x: Int, y: Int, eventTime: Long) {\n            when (tapType) {\n                WatchFaceService.TAP_TYPE_TOUCH -> {\n                    // The user has started touching the screen.\n                }\n                WatchFaceService.TAP_TYPE_TOUCH_CANCEL -> {\n                    // The user has started a different gesture or otherwise cancelled the tap.\n                }\n                WatchFaceService.TAP_TYPE_TAP ->\n                    // The user has completed the tap gesture.\n                    // TODO: Add code to handle the tap gesture.\n                    Toast.makeText(applicationContext, R.string.message, Toast.LENGTH_SHORT)\n                            .show()\n            }\n            invalidate()\n        }\n";
            stringBuilder5 = stringBuilder;
            string4 = string5;
            bl3 = false;
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string4 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            bl3 = false;
            bl2 = false;
            it$iv = string4;
            bl = false;
            bl3 = false;
            string = string4;
            if (string == null) {
                string = "";
            }
        }
        stringBuilder5.append(string).append("\n\n        override fun onDraw(canvas: Canvas, bounds: Rect) {\n            val now = System.currentTimeMillis()\n            mCalendar.timeInMillis = now\n\n            drawBackground(canvas)\n            drawWatchFace(canvas)\n        }\n\n        private fun drawBackground(canvas: Canvas) {\n\n            if (mAmbient && (mLowBitAmbient || mBurnInProtection)) {\n                canvas.drawColor(Color.BLACK)\n            } else if (mAmbient) {\n                canvas.drawBitmap(mGrayBackgroundBitmap, 0f, 0f, mBackgroundPaint)\n            } else {\n                canvas.drawBitmap(mBackgroundBitmap, 0f, 0f, mBackgroundPaint)\n            }\n        }\n\n        private fun drawWatchFace(canvas: Canvas) {\n\n            /*\n             * Draw ticks. Usually you will want to bake this directly into the photo, but in\n             * cases where you want to allow users to select their own photos, this dynamically\n             * creates them on top of the photo.\n             */\n            val innerTickRadius = mCenterX - 10\n            val outerTickRadius = mCenterX\n            for (tickIndex in 0..11) {\n                val tickRot = (tickIndex.toDouble() * Math.PI * 2.0 / 12).toFloat()\n                val innerX = Math.sin(tickRot.toDouble()).toFloat() * innerTickRadius\n                val innerY = (-Math.cos(tickRot.toDouble())).toFloat() * innerTickRadius\n                val outerX = Math.sin(tickRot.toDouble()).toFloat() * outerTickRadius\n                val outerY = (-Math.cos(tickRot.toDouble())).toFloat() * outerTickRadius\n                canvas.drawLine(mCenterX + innerX, mCenterY + innerY,\n                        mCenterX + outerX, mCenterY + outerY, mTickAndCirclePaint)\n            }\n\n            /*\n             * These calculations reflect the rotation in degrees per unit of time, e.g.,\n             * 360 / 60 = 6 and 360 / 12 = 30.\n             */\n            val seconds =\n                    mCalendar.get(Calendar.SECOND) + mCalendar.get(Calendar.MILLISECOND) / 1000f\n            val secondsRotation = seconds * 6f\n\n            val minutesRotation = mCalendar.get(Calendar.MINUTE) * 6f\n\n            val hourHandOffset = mCalendar.get(Calendar.MINUTE) / 2f\n            val hoursRotation = mCalendar.get(Calendar.HOUR) * 30 + hourHandOffset\n\n            /*\n             * Save the canvas state before we can begin to rotate it.\n             */\n            canvas.save()\n\n            canvas.rotate(hoursRotation, mCenterX, mCenterY)\n            canvas.drawLine(\n                    mCenterX,\n                    mCenterY - CENTER_GAP_AND_CIRCLE_RADIUS,\n                    mCenterX,\n                    mCenterY - sHourHandLength,\n                    mHourPaint)\n\n            canvas.rotate(minutesRotation - hoursRotation, mCenterX, mCenterY)\n            canvas.drawLine(\n                    mCenterX,\n                    mCenterY - CENTER_GAP_AND_CIRCLE_RADIUS,\n                    mCenterX,\n                    mCenterY - sMinuteHandLength,\n                    mMinutePaint)\n\n            /*\n             * Ensure the \"seconds\" hand is drawn only when we are in interactive mode.\n             * Otherwise, we only update the watch face once a minute.\n             */\n            if (!mAmbient) {\n                canvas.rotate(secondsRotation - minutesRotation, mCenterX, mCenterY)\n                canvas.drawLine(\n                        mCenterX,\n                        mCenterY - CENTER_GAP_AND_CIRCLE_RADIUS,\n                        mCenterX,\n                        mCenterY - mSecondHandLength,\n                        mSecondPaint)\n\n            }\n            canvas.drawCircle(\n                    mCenterX,\n                    mCenterY,\n                    CENTER_GAP_AND_CIRCLE_RADIUS,\n                    mTickAndCirclePaint)\n\n            /* Restore the canvas\" original orientation. */\n            canvas.restore()\n        }\n\n        override fun onVisibilityChanged(visible: Boolean) {\n            super.onVisibilityChanged(visible)\n\n            if (visible) {\n                registerReceiver()\n                /* Update time zone in case it changed while we weren\"t visible. */\n                mCalendar.timeZone = TimeZone.getDefault()\n                invalidate()\n            } else {\n                unregisterReceiver()\n            }\n\n            /* Check and trigger whether or not timer should be running (only in active mode). */\n            updateTimer()\n        }\n\n        private fun registerReceiver() {\n            if (mRegisteredTimeZoneReceiver) {\n                return\n            }\n            mRegisteredTimeZoneReceiver = true\n            val filter = IntentFilter(Intent.ACTION_TIMEZONE_CHANGED)\n            this@").append(serviceClass).append(".registerReceiver(mTimeZoneReceiver, filter)\n        }\n\n        private fun unregisterReceiver() {\n            if (!mRegisteredTimeZoneReceiver) {\n                return\n            }\n            mRegisteredTimeZoneReceiver = false\n            this@").append(serviceClass).append(".unregisterReceiver(mTimeZoneReceiver)\n        }\n\n        /**\n         * Starts/stops the [.mUpdateTimeHandler] timer based on the state of the watch face.\n         */\n        private fun updateTimer() {\n            mUpdateTimeHandler.removeMessages(MSG_UPDATE_TIME)\n            if (shouldTimerBeRunning()) {\n                mUpdateTimeHandler.sendEmptyMessage(MSG_UPDATE_TIME)\n            }\n        }\n\n        /**\n         * Returns whether the [.mUpdateTimeHandler] timer should be running. The timer\n         * should only run in active mode.\n         */\n        private fun shouldTimerBeRunning(): Boolean {\n            return isVisible && !mAmbient\n        }\n\n        /**\n         * Handle updating the time periodically in interactive mode.\n         */\n        fun handleUpdateTimeMessage() {\n            invalidate()\n            if (shouldTimerBeRunning()) {\n                val timeMs = System.currentTimeMillis()\n                val delayMs = INTERACTIVE_UPDATE_RATE_MS - timeMs % INTERACTIVE_UPDATE_RATE_MS\n                mUpdateTimeHandler.sendEmptyMessageDelayed(MSG_UPDATE_TIME, delayMs)\n            }\n        }\n    }\n}\n\n\n");
        return stringBuilder2.toString();
    }
}

