/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.other.sliceProvider.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"sliceProviderKt", "", "className", "packageName", "pathPrefix", "intellij.android.wizardTemplate.impl"})
public final class SliceProviderKtKt {
    @NotNull
    public static final String sliceProviderKt(@NotNull String className, @NotNull String packageName, @NotNull String pathPrefix) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)pathPrefix, (String)"pathPrefix");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + "\n\nimport android.content.ContentResolver\nimport android.content.Intent\nimport android.net.Uri\nimport androidx.slice.Slice\nimport androidx.slice.SliceProvider\nimport androidx.slice.builders.ListBuilder\nimport androidx.slice.builders.SliceAction\n\nclass " + className + " : SliceProvider() {\n    /**\n     * Instantiate any required objects. Return true if the provider was successfully created,\n     * false otherwise.\n     */\n    override fun onCreateSliceProvider(): Boolean {\n        return true\n    }\n\n    /**\n     * Converts URL to content URI (i.e. content://" + packageName + "...)\n     */\n    override fun onMapIntentToUri(intent: Intent?): Uri {\n        // Note: implementing this is only required if you plan on catching URL requests.\n        // This is an example solution.\n        var uriBuilder: Uri.Builder = Uri.Builder().scheme(ContentResolver.SCHEME_CONTENT)\n        if (intent == null) return uriBuilder.build()\n        val data = intent.data\n\tval dataPath = data?.path\n        if (data != null && dataPath != null) {\n            val path = dataPath.replace(\"" + pathPrefix + "\", \"\")\n            uriBuilder = uriBuilder.path(path)\n        }\n        val context = context\n        if (context != null) {\n            uriBuilder = uriBuilder.authority(context.packageName)\n        }\n        return uriBuilder.build()\n    }\n\n    /**\n     * Construct the Slice and bind data if available.\n     */\n    override fun onBindSlice(sliceUri: Uri): Slice? {\n        // Note: you should switch your build.gradle dependency to\n        // slice-builders-ktx for a nicer interface in Kotlin.\n        val context = context ?: return null\n        val activityAction = createActivityAction() ?: return null\n        return if (sliceUri.path == \"/\") {\n            // Path recognized. Customize the Slice using the androidx.slice.builders API.\n            // Note: ANR and StrictMode are enforced here so don\"t do any heavy operations. \n            // Only bind data that is currently available in memory.\n            ListBuilder(context, sliceUri, ListBuilder.INFINITY)\n                .addRow(\n                    ListBuilder.RowBuilder()\n                        .setTitle(\"URI found.\")\n                        .setPrimaryAction(activityAction)\n                )\n                .build()\n        } else {\n            // Error: Path not found.\n            ListBuilder(context, sliceUri, ListBuilder.INFINITY)\n                .addRow(\n                    ListBuilder.RowBuilder()\n                        .setTitle(\"URI not found.\")\n                        .setPrimaryAction(activityAction)\n                )\n                .build()\n        }\n    }\n\n    private fun createActivityAction(): SliceAction? {\n        return null\n        /*\n        Instead of returning null, you should create a SliceAction. Here is an example:\n        return SliceAction.create(\n            PendingIntent.getActivity(\n                context, 0, Intent(context, MyActivityClass::class.java), 0\n            ),\n            IconCompat.createWithResource(context, R.drawable.ic_launcher_foreground),\n            ListBuilder.ICON_IMAGE,\n            \"Open App\"\n        )\n        */\n    }\n\n    /**\n     * Slice has been pinned to external process. Subscribe to data source if necessary.\n     */\n    override fun onSlicePinned(sliceUri: Uri?) {\n        // When data is received, call context.contentResolver.notifyChange(sliceUri, null) to\n        // trigger " + className + "#onBindSlice(Uri) again.\n    }\n\n    /**\n     * Unsubscribe from data source if necessary.\n     */\n    override fun onSliceUnpinned(sliceUri: Uri?) {\n        // Remove any observers if necessary to avoid memory leaks.\n    }\n}\n";
    }
}

