/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.loginActivity.src.app_package.ui.login;

import com.android.tools.idea.wizard.template.Language;
import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import com.android.tools.idea.wizard.template.impl.activities.common.ViewBindingUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"loginActivityJava", "", "layoutName", "packageName", "useAndroidX", "", "isViewBindingSupported", "intellij.android.wizardTemplate.impl"})
public final class LoginActivityJavaKt {
    @NotNull
    public static final String loginActivityJava(@NotNull String layoutName2, @NotNull String packageName, boolean useAndroidX, boolean isViewBindingSupported) {
        String string;
        Intrinsics.checkNotNullParameter((Object)layoutName2, (String)"layoutName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String contentViewBlock = isViewBindingSupported ? "\n     binding = " + ViewBindingUtilsKt.layoutToViewBindingClass(layoutName2) + ".inflate(getLayoutInflater());\n     setContentView(binding.getRoot());\n  " : "setContentView(R.layout." + layoutName2 + ");";
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("package  ").append(packageName).append(".ui.login;\n\nimport android.app.Activity;\nimport ").append(TemplateHelpersKt.getMaterialComponentName("android.arch.lifecycle.Observer", useAndroidX)).append(";\nimport ").append(TemplateHelpersKt.getMaterialComponentName("android.arch.lifecycle.ViewModelProvider", useAndroidX)).append(";\nimport android.os.Bundle;\nimport ").append(TemplateHelpersKt.getMaterialComponentName("android.support.annotation.Nullable", useAndroidX)).append(";\nimport ").append(TemplateHelpersKt.getMaterialComponentName("android.support.annotation.StringRes", useAndroidX)).append(";\nimport ").append(TemplateHelpersKt.getMaterialComponentName("android.support.v7.app.AppCompatActivity", useAndroidX)).append(";\nimport android.text.Editable;\nimport android.text.TextWatcher;\nimport android.view.KeyEvent;\nimport android.view.View;\nimport android.view.inputmethod.EditorInfo;\nimport android.widget.Button;\nimport android.widget.EditText;\nimport android.widget.ProgressBar;\nimport android.widget.TextView;\nimport android.widget.Toast;\n\nimport ").append(packageName).append(".R;\nimport ").append(packageName).append(".ui.login.LoginViewModel;\nimport ").append(packageName).append(".ui.login.LoginViewModelFactory;\n").append(ViewBindingUtilsKt.importViewBindingClass(isViewBindingSupported, packageName, layoutName2, Language.Java)).append("\n\npublic class LoginActivity extends AppCompatActivity {\n\n    private LoginViewModel loginViewModel;\n");
        boolean trim$iv = true;
        boolean skipLine$iv = true;
        boolean $i$f$renderIf = false;
        if (isViewBindingSupported) {
            StringBuilder stringBuilder3 = stringBuilder2;
            boolean bl = false;
            String string2 = "\n    private " + ViewBindingUtilsKt.layoutToViewBindingClass(layoutName2) + " binding;\n";
            stringBuilder2 = stringBuilder3;
            String string3 = string2;
            boolean bl2 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            String string5 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            boolean bl = false;
            boolean bl3 = false;
            String it$iv = string5;
            boolean bl4 = false;
            bl = false;
            string = string5;
            if (string == null) {
                string = "";
            }
        }
        stringBuilder2.append(string).append("\n\n    @Override\n    public void onCreate(Bundle savedInstanceState) {\n        super.onCreate(savedInstanceState);\n        ");
        stringBuilder.append(contentViewBlock).append("\n        loginViewModel = new ViewModelProvider(this, new LoginViewModelFactory())\n                .get(LoginViewModel.class);\n\n        final EditText usernameEditText = ").append(ViewBindingUtilsKt.findViewById$default(Language.Java, isViewBindingSupported, "username", null, null, null, 56, null)).append(";\n        final EditText passwordEditText = ").append(ViewBindingUtilsKt.findViewById$default(Language.Java, isViewBindingSupported, "password", null, null, null, 56, null)).append(";\n        final Button loginButton = ").append(ViewBindingUtilsKt.findViewById$default(Language.Java, isViewBindingSupported, "login", null, null, null, 56, null)).append(";\n        final ProgressBar loadingProgressBar = ").append(ViewBindingUtilsKt.findViewById$default(Language.Java, isViewBindingSupported, "loading", null, null, null, 56, null)).append(";\n\n        loginViewModel.getLoginFormState().observe(this, new Observer<LoginFormState>() {\n            @Override\n            public void onChanged(@Nullable LoginFormState loginFormState) {\n                if (loginFormState == null) {\n                    return;\n                }\n                loginButton.setEnabled(loginFormState.isDataValid());\n                if (loginFormState.getUsernameError() != null) {\n                    usernameEditText.setError(getString(loginFormState.getUsernameError()));\n                }\n                if (loginFormState.getPasswordError() != null) {\n                    passwordEditText.setError(getString(loginFormState.getPasswordError()));\n                }\n            }\n        });\n\n        loginViewModel.getLoginResult().observe(this, new Observer<LoginResult>() {\n            @Override\n            public void onChanged(@Nullable LoginResult loginResult) {\n                if (loginResult == null) {\n                    return;\n                }\n                loadingProgressBar.setVisibility(View.GONE);\n                if (loginResult.getError() != null) {\n                    showLoginFailed(loginResult.getError());\n                }\n                if (loginResult.getSuccess() != null) {\n                    updateUiWithUser(loginResult.getSuccess());\n                }\n                setResult(Activity.RESULT_OK);\n\n                //Complete and destroy login activity once successful\n                finish();\n            }\n        });\n\n        TextWatcher afterTextChangedListener = new TextWatcher() {\n            @Override\n            public void beforeTextChanged(CharSequence s, int start, int count, int after) {\n                // ignore\n            }\n\n            @Override\n            public void onTextChanged(CharSequence s, int start, int before, int count) {\n                // ignore\n            }\n\n            @Override\n            public void afterTextChanged(Editable s) {\n                loginViewModel.loginDataChanged(usernameEditText.getText().toString(),\n                        passwordEditText.getText().toString());\n            }\n        };\n        usernameEditText.addTextChangedListener(afterTextChangedListener);\n        passwordEditText.addTextChangedListener(afterTextChangedListener);\n        passwordEditText.setOnEditorActionListener(new TextView.OnEditorActionListener() {\n\n            @Override\n            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {\n                if (actionId == EditorInfo.IME_ACTION_DONE) {\n                    loginViewModel.login(usernameEditText.getText().toString(),\n                            passwordEditText.getText().toString());\n                }\n                return false;\n            }\n        });\n\n        loginButton.setOnClickListener(new View.OnClickListener() {\n            @Override\n            public void onClick(View v) {\n                loadingProgressBar.setVisibility(View.VISIBLE);\n                loginViewModel.login(usernameEditText.getText().toString(),\n                        passwordEditText.getText().toString());\n            }\n        });\n    }\n\n    private void updateUiWithUser(LoggedInUserView model) {\n        String welcome = getString(R.string.welcome) + model.getDisplayName();\n        // TODO : initiate successful logged in experience\n        Toast.makeText(getApplicationContext(), welcome, Toast.LENGTH_LONG).show();\n    }\n\n    private void showLoginFailed(@StringRes Integer errorString) {\n        Toast.makeText(getApplicationContext(), errorString, Toast.LENGTH_SHORT).show();\n    }\n}\n");
        return stringBuilder.toString();
    }
}

