/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.googlePayActivity.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u00a8\u0006\u0004"}, d2={"checkoutViewModelKt", "", "viewModelClass", "packageName", "intellij.android.wizardTemplate.impl"})
public final class CheckoutViewModelKtKt {
    @NotNull
    public static final String checkoutViewModelKt(@NotNull String viewModelClass2, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)viewModelClass2, (String)"viewModelClass");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(Intrinsics.stringPlus((String)packageName, (Object)".viewmodel")) + "\n\nimport android.app.Application\nimport android.util.Log\n\nimport androidx.lifecycle.AndroidViewModel\nimport androidx.lifecycle.LiveData\nimport androidx.lifecycle.MutableLiveData\n\nimport com.google.android.gms.common.api.ApiException\nimport com.google.android.gms.tasks.Task\nimport com.google.android.gms.wallet.IsReadyToPayRequest\nimport com.google.android.gms.wallet.PaymentData\nimport com.google.android.gms.wallet.PaymentDataRequest\nimport com.google.android.gms.wallet.PaymentsClient\n\nimport " + packageName + ".util.PaymentsUtil\n\nclass " + viewModelClass2 + "(application: Application) : AndroidViewModel(application) {\n\n    // A client for interacting with the Google Pay API.\n    private val paymentsClient: PaymentsClient = PaymentsUtil.createPaymentsClient(application)\n\n    // LiveData with the result of whether the user can pay using Google Pay\n    private val _canUseGooglePay: MutableLiveData<Boolean> by lazy {\n        MutableLiveData<Boolean>().also {\n            fetchCanUseGooglePay()\n        }\n    }\n\n    val canUseGooglePay: LiveData<Boolean> = _canUseGooglePay\n\n    /**\n     * Determine the user's ability to pay with a payment method supported by your app and display\n     * a Google Pay payment button.\n     *\n     * @return a [LiveData] object that holds the future result of the call.\n     * @see [](https://developers.google.com/android/reference/com/google/android/gms/wallet/PaymentsClient.html.isReadyToPay)\n    ) */\n    private fun fetchCanUseGooglePay() {\n        val isReadyToPayJson = PaymentsUtil.isReadyToPayRequest()\n        if (isReadyToPayJson == null) _canUseGooglePay.value = false\n\n        val request = IsReadyToPayRequest.fromJson(isReadyToPayJson.toString())\n        val task = paymentsClient.isReadyToPay(request)\n        task.addOnCompleteListener { completedTask ->\n            try {\n                _canUseGooglePay.value = completedTask.getResult(ApiException::class.java)\n            } catch (exception: ApiException) {\n                Log.w(\"isReadyToPay failed\", exception)\n                _canUseGooglePay.value = false\n            }\n        }\n    }\n\n    /**\n     * Creates a [Task] that starts the payment process with the transaction details included.\n     *\n     * @param priceCents the price to show on the payment sheet.\n     * @return a [Task] with the payment information.\n     * @see [](https://developers.google.com/android/reference/com/google/android/gms/wallet/PaymentsClient#loadPaymentData(com.google.android.gms.wallet.PaymentDataRequest)\n    ) */\n    fun getLoadPaymentDataTask(priceCents: Long): Task<PaymentData> {\n        val paymentDataRequestJson = PaymentsUtil.getPaymentDataRequest(priceCents)\n        val request = PaymentDataRequest.fromJson(paymentDataRequestJson.toString())\n        return paymentsClient.loadPaymentData(request)\n    }\n}\n";
    }
}

