/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.googlePayActivity.app_package;

import com.android.tools.idea.wizard.template.Language;
import com.android.tools.idea.wizard.template.impl.activities.common.ViewBindingUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"checkoutActivityJava", "", "activityClass", "viewModelClass", "layoutName", "packageName", "isViewBindingSupported", "", "intellij.android.wizardTemplate.impl"})
public final class CheckoutActivityJavaKt {
    @NotNull
    public static final String checkoutActivityJava(@NotNull String activityClass2, @NotNull String viewModelClass2, @NotNull String layoutName2, @NotNull String packageName, boolean isViewBindingSupported) {
        String string;
        Intrinsics.checkNotNullParameter((Object)activityClass2, (String)"activityClass");
        Intrinsics.checkNotNullParameter((Object)viewModelClass2, (String)"viewModelClass");
        Intrinsics.checkNotNullParameter((Object)layoutName2, (String)"layoutName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String contentViewBlock = isViewBindingSupported ? "layoutBinding = " + ViewBindingUtilsKt.layoutToViewBindingClass(layoutName2) + ".inflate(getLayoutInflater());\n     setContentView(layoutBinding.getRoot());\n  " : "setContentView(R.layout." + layoutName2 + ");";
        String googlePayButtonBlock = isViewBindingSupported ? "googlePayButton = layoutBinding.googlePayButton.getRoot();" : "googlePayButton = findViewById(R.id.googlePayButton);";
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("\npackage ").append(packageName).append(";\n\nimport android.content.Intent;\nimport android.os.Bundle;\nimport android.util.Log;\nimport android.view.View;\nimport android.widget.Toast;\n\nimport androidx.annotation.Nullable;\nimport androidx.appcompat.app.AppCompatActivity;\nimport androidx.lifecycle.ViewModelProvider;\n\nimport com.google.android.gms.common.api.Status;\nimport com.google.android.gms.tasks.Task;\nimport com.google.android.gms.wallet.AutoResolveHelper;\nimport com.google.android.gms.wallet.PaymentData;\n\nimport ").append(packageName).append(".R;\nimport ").append(packageName).append(".viewmodel.").append(viewModelClass2).append(";\n\nimport java.util.Locale;\n\nimport org.json.JSONException;\nimport org.json.JSONObject;\n").append(ViewBindingUtilsKt.importViewBindingClass(isViewBindingSupported, packageName, layoutName2, Language.Java)).append("\n\n/**\n * Checkout implementation for the app\n */\npublic class ").append(activityClass2).append(" extends AppCompatActivity {\n\n  // Arbitrarily-picked constant integer you define to track a request for payment data activity.\n  private static final int LOAD_PAYMENT_DATA_REQUEST_CODE = 991;\n\n  private ").append(viewModelClass2).append(" model;\n\n  ");
        boolean trim$iv = true;
        boolean skipLine$iv = true;
        boolean $i$f$renderIf = false;
        if (isViewBindingSupported) {
            StringBuilder stringBuilder3 = stringBuilder2;
            boolean bl = false;
            String string2 = "\n    private " + ViewBindingUtilsKt.layoutToViewBindingClass(layoutName2) + " layoutBinding;\n  ";
            stringBuilder2 = stringBuilder3;
            String string3 = string2;
            boolean bl2 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            String string5 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            boolean bl = false;
            boolean bl3 = false;
            String it$iv = string5;
            boolean bl4 = false;
            bl = false;
            string = string5;
            if (string == null) {
                string = "";
            }
        }
        stringBuilder2.append(string).append("\n  private View googlePayButton;\n\n  /**\n   * Initialize the Google Pay API on creation of the activity\n   *\n   * @see AppCompatActivity#onCreate(android.os.Bundle)\n   */\n  @Override\n  protected void onCreate(Bundle savedInstanceState) {\n    super.onCreate(savedInstanceState);\n    initializeUi();\n\n    model = new ViewModelProvider(this).get(").append(viewModelClass2).append(".class);\n    model.canUseGooglePay.observe(this, this::setGooglePayAvailable);\n  }\n\n  private void initializeUi() {\n\n    // Use view binding to access the UI elements\n    ").append(contentViewBlock).append("\n\n    // The Google Pay button is a layout file \u2013 take the root view\n    ").append(googlePayButtonBlock).append("\n    googlePayButton.setOnClickListener(this::requestPayment);\n  }\n\n  /**\n   * If isReadyToPay returned {@code true}, show the button and hide the \"checking\" text.\n   * Otherwise, notify the user that Google Pay is not available. Please adjust to fit in with\n   * your current user flow. You are not required to explicitly let the user know if isReadyToPay\n   * returns {@code false}.\n   *\n   * @param available isReadyToPay API response.\n   */\n  private void setGooglePayAvailable(boolean available) {\n    if (available) {\n      googlePayButton.setVisibility(View.VISIBLE);\n    } else {\n      Toast.makeText(this, R.string.googlepay_status_unavailable, Toast.LENGTH_LONG).show();\n    }\n  }\n\n  public void requestPayment(View view) {\n\n    // Disables the button to prevent multiple clicks.\n    googlePayButton.setClickable(false);\n\n    // The price provided to the API should include taxes and shipping.\n    // This price is not displayed to the user.\n    long dummyPriceCents = 100;\n    long shippingCostCents = 900;\n    long totalPriceCents = dummyPriceCents + shippingCostCents;\n    final Task<PaymentData> task = model.getLoadPaymentDataTask(totalPriceCents);\n\n    // Shows the payment sheet and forwards the result to the onActivityResult method.\n    AutoResolveHelper.resolveTask(task, this, LOAD_PAYMENT_DATA_REQUEST_CODE);\n  }\n\n  /**\n   * Handle a resolved activity from the Google Pay payment sheet.\n   *\n   * @param requestCode Request code originally supplied to AutoResolveHelper in requestPayment().\n   * @param resultCode  Result code returned by the Google Pay API.\n   * @param data        Intent from the Google Pay API containing payment or error data.\n   * @see <a href=\"https://developer.android.com/training/basics/intents/result\">Getting a result\n   * from an Activity</a>\n   */\n  @SuppressWarnings(\"deprecation\")\n  // Suppressing deprecation until `registerForActivityResult` can be used with the Google Pay API.\n  @Override\n  public void onActivityResult(int requestCode, int resultCode, Intent data) {\n    super.onActivityResult(requestCode, resultCode, data);\n    switch (requestCode) {\n      // value passed in AutoResolveHelper\n      case LOAD_PAYMENT_DATA_REQUEST_CODE:\n        switch (resultCode) {\n\n          case AppCompatActivity.RESULT_OK:\n            PaymentData paymentData = PaymentData.getFromIntent(data);\n            handlePaymentSuccess(paymentData);\n            break;\n\n          case AppCompatActivity.RESULT_CANCELED:\n            // The user cancelled the payment attempt\n            break;\n\n          case AutoResolveHelper.RESULT_ERROR:\n            Status status = AutoResolveHelper.getStatusFromIntent(data);\n            handleError(status);\n            break;\n        }\n\n        // Re-enables the Google Pay payment button.\n        googlePayButton.setClickable(true);\n    }\n  }\n\n  /**\n   * PaymentData response object contains the payment information, as well as any additional\n   * requested information, such as billing and shipping address.\n   *\n   * @param paymentData A response object returned by Google after a payer approves payment.\n   * @see <a href=\"https://developers.google.com/pay/api/android/reference/\n   * object#PaymentData\">PaymentData</a>\n   */\n  private void handlePaymentSuccess(@Nullable PaymentData paymentData) {\n    final String paymentInfo = paymentData.toJson();\n\n    try {\n      JSONObject paymentMethodData = new JSONObject(paymentInfo).getJSONObject(\"paymentMethodData\");\n      // If the gateway is set to \"example\", no payment information is returned - instead, the\n      // token will only consist of \"examplePaymentMethodToken\".\n\n      final JSONObject tokenizationData = paymentMethodData.getJSONObject(\"tokenizationData\");\n      final String token = tokenizationData.getString(\"token\");\n      final JSONObject info = paymentMethodData.getJSONObject(\"info\");\n      final String billingName = info.getJSONObject(\"billingAddress\").getString(\"name\");\n      Toast.makeText(\n          this, getString(R.string.payments_show_name, billingName),\n          Toast.LENGTH_LONG).show();\n\n      // Logging token string.\n      Log.d(\"Google Pay token: \", token);\n\n    } catch (JSONException e) {\n      throw new RuntimeException(\"The selected garment cannot be parsed from the list of elements\");\n    }\n  }\n\n  /**\n   * At this stage, the user has already seen a popup informing them an error occurred. Normally,\n   * only logging is required.\n   *\n   * @param status will hold the value of any constant from CommonStatusCode or one of the\n   *                   WalletConstants.ERROR_CODE_* constants.\n   * @see <a href=\"https://developers.google.com/android/reference/com/google/android/gms/wallet/\n   * WalletConstants#constant-summary\">Wallet Constants Library</a>\n   */\n  private void handleError(@Nullable Status status) {\n    String errorString = \"Unknown error.\";\n    if (status != null) {\n      int statusCode = status.getStatusCode();\n      errorString = String.format(Locale.getDefault(), \"Error code: %d\", statusCode);\n    }\n\n    Log.e(\"loadPaymentData failed\", errorString);\n  }\n}\n");
        return stringBuilder.toString();
    }
}

