/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.androidTVActivity.src.app_package;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u00a8\u0006\b"}, d2={"videoDetailsFragmentJava", "", "activityClass", "detailsActivity", "detailsFragment", "minApiLevel", "", "packageName", "intellij.android.wizardTemplate.impl"})
public final class VideoDetailsFragmentJavaKt {
    @NotNull
    public static final String videoDetailsFragmentJava(@NotNull String activityClass2, @NotNull String detailsActivity2, @NotNull String detailsFragment2, int minApiLevel, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)activityClass2, (String)"activityClass");
        Intrinsics.checkNotNullParameter((Object)detailsActivity2, (String)"detailsActivity");
        Intrinsics.checkNotNullParameter((Object)detailsFragment2, (String)"detailsFragment");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String contextArgBlock = minApiLevel >= 23 ? "getContext()" : "getActivity()";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\npackage ").append(packageName).append(";\n\nimport android.content.Context;\nimport android.content.Intent;\nimport android.graphics.Bitmap;\nimport android.os.Bundle;\nimport android.graphics.drawable.Drawable;\nimport androidx.annotation.NonNull;\nimport androidx.annotation.Nullable;\nimport androidx.leanback.app.DetailsSupportFragment;\nimport androidx.leanback.app.DetailsSupportFragmentBackgroundController;\nimport androidx.leanback.widget.Action;\nimport androidx.leanback.widget.ArrayObjectAdapter;\nimport androidx.leanback.widget.ClassPresenterSelector;\nimport androidx.leanback.widget.DetailsOverviewRow;\nimport androidx.leanback.widget.FullWidthDetailsOverviewRowPresenter;\nimport androidx.leanback.widget.FullWidthDetailsOverviewSharedElementHelper;\nimport androidx.leanback.widget.HeaderItem;\nimport androidx.leanback.widget.ImageCardView;\nimport androidx.leanback.widget.ListRow;\nimport androidx.leanback.widget.ListRowPresenter;\nimport androidx.leanback.widget.OnActionClickedListener;\nimport androidx.leanback.widget.OnItemViewClickedListener;\nimport androidx.leanback.widget.Presenter;\nimport androidx.leanback.widget.Row;\nimport androidx.leanback.widget.RowPresenter;\nimport androidx.core.app.ActivityOptionsCompat;\nimport androidx.core.content.ContextCompat;\nimport android.util.Log;\nimport android.widget.Toast;\n\nimport com.bumptech.glide.Glide;\nimport com.bumptech.glide.request.target.SimpleTarget;\nimport com.bumptech.glide.request.transition.Transition;\n\nimport java.util.Collections;\nimport java.util.List;\n\n/*\n * LeanbackDetailsFragment extends DetailsFragment, a Wrapper fragment for leanback details screens.\n * It shows a detailed view of video and its meta plus related videos.\n */\npublic class ").append(detailsFragment2).append(" extends DetailsSupportFragment {\n    private static final String TAG = \"").append(StringsKt.take((String)detailsFragment2, (int)23)).append("\";\n\n    private static final int ACTION_WATCH_TRAILER = 1;\n    private static final int ACTION_RENT = 2;\n    private static final int ACTION_BUY = 3;\n\n    private static final int DETAIL_THUMB_WIDTH = 274;\n    private static final int DETAIL_THUMB_HEIGHT = 274;\n\n    private static final int NUM_COLS = 10;\n\n    private Movie mSelectedMovie;\n\n    private ArrayObjectAdapter mAdapter;\n    private ClassPresenterSelector mPresenterSelector;\n\n    private DetailsSupportFragmentBackgroundController mDetailsBackground;\n\n    @Override\n    public void onCreate(Bundle savedInstanceState) {\n        Log.d(TAG, \"onCreate DetailsFragment\");\n        super.onCreate(savedInstanceState);\n\n        mDetailsBackground = new DetailsSupportFragmentBackgroundController(this);\n\n        mSelectedMovie =\n                (Movie) getActivity().getIntent() .getSerializableExtra(").append(detailsActivity2).append(".MOVIE);\n        if (mSelectedMovie != null) {\n            mPresenterSelector = new ClassPresenterSelector();\n            mAdapter = new ArrayObjectAdapter(mPresenterSelector);\n            setupDetailsOverviewRow();\n            setupDetailsOverviewRowPresenter();\n            setupRelatedMovieListRow();\n            setAdapter(mAdapter);\n            initializeBackground(mSelectedMovie);\n            setOnItemViewClickedListener(new ItemViewClickedListener());\n        } else {\n            Intent intent = new Intent(getActivity(), ").append(activityClass2).append(".class);\n            startActivity(intent);\n        }\n    }\n\n    private void initializeBackground(Movie data) {\n        mDetailsBackground.enableParallax();\n        Glide.with(getActivity())\n                .asBitmap()\n                .centerCrop()\n                .error(R.drawable.default_background)\n                .load(data.getBackgroundImageUrl())\n                .into(new SimpleTarget<Bitmap>() {\n                    @Override\n                    public void onResourceReady(@NonNull Bitmap bitmap,\n                                                @Nullable Transition<? super Bitmap> transition) {\n                        mDetailsBackground.setCoverBitmap(bitmap);\n                        mAdapter.notifyArrayItemRangeChanged(0, mAdapter.size());\n                    }\n                });\n    }\n\n    private void setupDetailsOverviewRow() {\n        Log.d(TAG, \"doInBackground: \" + mSelectedMovie.toString());\n        final DetailsOverviewRow row = new DetailsOverviewRow(mSelectedMovie);\n        row.setImageDrawable(\n                ContextCompat.getDrawable(").append(contextArgBlock).append(", R.drawable.default_background));\n        int width = convertDpToPixel(getActivity().getApplicationContext(), DETAIL_THUMB_WIDTH);\n        int height = convertDpToPixel(getActivity().getApplicationContext(), DETAIL_THUMB_HEIGHT);\n        Glide.with(getActivity())\n                .load(mSelectedMovie.getCardImageUrl())\n                .centerCrop()\n                .error(R.drawable.default_background)\n                .into(new SimpleTarget<Drawable>(width, height) {\n                    @Override\n                    public void onResourceReady(@NonNull Drawable drawable,\n                                                @Nullable Transition<? super Drawable> transition) {\n                        Log.d(TAG, \"details overview card image url ready: \" + drawable);\n                        row.setImageDrawable(drawable);\n                        mAdapter.notifyArrayItemRangeChanged(0, mAdapter.size());\n                    }\n                });\n\n        ArrayObjectAdapter actionAdapter = new ArrayObjectAdapter();\n\n        actionAdapter.add(\n                new Action(\n                        ACTION_WATCH_TRAILER,\n                        getResources().getString(R.string.watch_trailer_1),\n                        getResources().getString(R.string.watch_trailer_2)));\n        actionAdapter.add(\n                new Action(\n                        ACTION_RENT,\n                        getResources().getString(R.string.rent_1),\n                        getResources().getString(R.string.rent_2)));\n        actionAdapter.add(\n                new Action(\n                        ACTION_BUY,\n                        getResources().getString(R.string.buy_1),\n                        getResources().getString(R.string.buy_2)));\n        row.setActionsAdapter(actionAdapter);\n\n        mAdapter.add(row);\n    }\n\n    private void setupDetailsOverviewRowPresenter() {\n        // Set detail background.\n        FullWidthDetailsOverviewRowPresenter detailsPresenter =\n                new FullWidthDetailsOverviewRowPresenter(new DetailsDescriptionPresenter());\n        detailsPresenter.setBackgroundColor(\n                ContextCompat.getColor(").append(contextArgBlock).append(", R.color.selected_background));\n\n        // Hook up transition element.\n        FullWidthDetailsOverviewSharedElementHelper sharedElementHelper =\n                new FullWidthDetailsOverviewSharedElementHelper();\n        sharedElementHelper.setSharedElementEnterTransition(\n                getActivity(), ").append(detailsActivity2).append(".SHARED_ELEMENT_NAME);\n        detailsPresenter.setListener(sharedElementHelper);\n        detailsPresenter.setParticipatingEntranceTransition(true);\n\n        detailsPresenter.setOnActionClickedListener(new OnActionClickedListener() {\n            @Override\n            public void onActionClicked(Action action) {\n                if (action.getId() == ACTION_WATCH_TRAILER) {\n                    Intent intent = new Intent(getActivity(), PlaybackActivity.class);\n                    intent.putExtra(").append(detailsActivity2).append(".MOVIE, mSelectedMovie);\n                    startActivity(intent);\n                } else {\n                    Toast.makeText(getActivity(), action.toString(), Toast.LENGTH_SHORT).show();\n                }\n            }\n        });\n        mPresenterSelector.addClassPresenter(DetailsOverviewRow.class, detailsPresenter);\n    }\n\n    private void setupRelatedMovieListRow() {\n        String subcategories[] = {getString(R.string.related_movies)};\n        List<Movie> list = MovieList.getList();\n\n        Collections.shuffle(list);\n        ArrayObjectAdapter listRowAdapter = new ArrayObjectAdapter(new CardPresenter());\n        for (int j = 0; j < NUM_COLS; j++) {\n            listRowAdapter.add(list.get(j % 5));\n        }\n\n        HeaderItem header = new HeaderItem(0, subcategories[0]);\n        mAdapter.add(new ListRow(header, listRowAdapter));\n        mPresenterSelector.addClassPresenter(ListRow.class, new ListRowPresenter());\n    }\n\n    private int convertDpToPixel(Context context, int dp) {\n        float density = context.getResources().getDisplayMetrics().density;\n        return Math.round((float) dp * density);\n    }\n\n    private final class ItemViewClickedListener implements OnItemViewClickedListener {\n        @Override\n        public void onItemClicked(\n                Presenter.ViewHolder itemViewHolder,\n                Object item,\n                RowPresenter.ViewHolder rowViewHolder,\n                Row row) {\n\n            if (item instanceof Movie) {\n                Log.d(TAG, \"Item: \" + item.toString());\n                Intent intent = new Intent(getActivity(), ").append(detailsActivity2).append(".class);\n                intent.putExtra(getResources().getString(R.string.movie), mSelectedMovie);\n\n                Bundle bundle =\n                        ActivityOptionsCompat.makeSceneTransitionAnimation(\n                            getActivity(),\n                            ((ImageCardView) itemViewHolder.view).getMainImageView(),\n                            ").append(detailsActivity2).append(".SHARED_ELEMENT_NAME)\n                        .toBundle();\n                getActivity().startActivity(intent, bundle);\n            }\n        }\n    }\n}\n");
        return stringBuilder.toString();
    }
}

