/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.androidTVActivity.src.app_package;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"playbackVideoFragmentJava", "", "minApiLevel", "", "packageName", "intellij.android.wizardTemplate.impl"})
public final class PlaybackVideoFragmentJavaKt {
    @NotNull
    public static final String playbackVideoFragmentJava(int minApiLevel, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String contextArgBlock = minApiLevel >= 23 ? "getContext()" : "getActivity()";
        return "\npackage " + packageName + ";\n\nimport android.net.Uri;\nimport android.os.Bundle;\nimport androidx.leanback.app.VideoSupportFragment;\nimport androidx.leanback.app.VideoSupportFragmentGlueHost;\nimport androidx.leanback.media.MediaPlayerAdapter;\nimport androidx.leanback.media.PlaybackTransportControlGlue;\nimport androidx.leanback.widget.PlaybackControlsRow;\n\n/** Handles video playback with media controls. */\npublic class PlaybackVideoFragment extends VideoSupportFragment {\n\n    private PlaybackTransportControlGlue<MediaPlayerAdapter> mTransportControlGlue;\n\n    @Override\n    public void onCreate(Bundle savedInstanceState) {\n        super.onCreate(savedInstanceState);\n\n        final Movie movie =\n                (Movie) getActivity().getIntent().getSerializableExtra(DetailsActivity.MOVIE);\n\n        VideoSupportFragmentGlueHost glueHost =\n                new VideoSupportFragmentGlueHost(PlaybackVideoFragment.this);\n\n        MediaPlayerAdapter playerAdapter = new MediaPlayerAdapter(" + contextArgBlock + ");\n        playerAdapter.setRepeatAction(PlaybackControlsRow.RepeatAction.INDEX_NONE);\n\n        mTransportControlGlue = new PlaybackTransportControlGlue<>(" + contextArgBlock + ", playerAdapter);\n        mTransportControlGlue.setHost(glueHost);\n        mTransportControlGlue.setTitle(movie.getTitle());\n        mTransportControlGlue.setSubtitle(movie.getDescription());\n        mTransportControlGlue.playWhenPrepared();\n        playerAdapter.setDataSource(Uri.parse(movie.getVideoUrl()));\n    }\n\n    @Override\n    public void onPause() {\n        super.onPause();\n        if (mTransportControlGlue != null) {\n            mTransportControlGlue.pause();\n        }\n    }\n}\n";
    }
}

