/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.reference.SoftReference;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.vfs.TestDataGroupVirtualFile;

public class TestDataGroupFileEditor
extends UserDataHolderBase
implements TextEditor {
    private final Project myProject;
    private final TestDataGroupVirtualFile myFile;
    private final TextEditor myBeforeEditor;
    private final TextEditor myAfterEditor;
    private WeakReference<Splitter> myComponent;

    public TestDataGroupFileEditor(Project project, TestDataGroupVirtualFile file) {
        this.myProject = project;
        this.myFile = file;
        this.myBeforeEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(project, file.getBeforeFile());
        this.myAfterEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(project, file.getAfterFile());
    }

    @NotNull
    public JComponent getComponent() {
        Splitter result = (Splitter)SoftReference.dereference(this.myComponent);
        if (result == null) {
            result = this.createComponent();
            this.myComponent = new WeakReference<Splitter>(result);
        }
        Splitter splitter = result;
        if (splitter == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(0);
        }
        return splitter;
    }

    private Splitter createComponent() {
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.5f, 0.1f, 0.9f);
        splitter.setFirstComponent(TestDataGroupFileEditor.wrapWithTitle(this.myFile.getBeforeFile().getName(), (FileEditor)this.myBeforeEditor));
        splitter.setSecondComponent(TestDataGroupFileEditor.wrapWithTitle(this.myFile.getAfterFile().getName(), (FileEditor)this.myAfterEditor));
        return splitter;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = (SwingUtilities.isEventDispatchThread() && this.isBeforeEditorFocused() ? this.myBeforeEditor : this.myAfterEditor).getEditor();
        if (editor == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(1);
        }
        return editor;
    }

    private boolean isBeforeEditorFocused() {
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
        Component focusOwner = focusManager.getFocusOwner();
        Splitter splitter = (Splitter)this.getComponent();
        return UIUtil.isDescendingFrom((Component)focusOwner, (Component)splitter.getFirstComponent());
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(2);
        }
        return false;
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(3);
        }
    }

    private static JComponent wrapWithTitle(@NlsSafe String name, FileEditor beforeEditor) {
        JPanel panel2 = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel(name, UIUtil.ComponentStyle.SMALL);
        label.setBorder((Border)JBUI.Borders.empty((int)1, (int)4, (int)2, (int)0));
        panel2.add("North", (Component)label);
        panel2.add("Center", beforeEditor.getComponent());
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(5);
        }
    }

    public boolean isModified() {
        return this.myBeforeEditor.isModified() || this.myAfterEditor.isModified();
    }

    public boolean isValid() {
        return this.myBeforeEditor.isValid() && this.myAfterEditor.isValid();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(6);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(7);
        }
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @NotNull
    public VirtualFile getFile() {
        TestDataGroupVirtualFile testDataGroupVirtualFile = this.myFile;
        if (testDataGroupVirtualFile == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(8);
        }
        return testDataGroupVirtualFile;
    }

    public void dispose() {
        TextEditorProvider.getInstance().disposeEditor((FileEditor)this.myBeforeEditor);
        TextEditorProvider.getInstance().disposeEditor((FileEditor)this.myAfterEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataGroupFileEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataGroupFileEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

