/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DescriptionType;

public final class DescriptionCheckerUtil {
    public static StreamEx<GlobalSearchScope> searchScopes(Module module) {
        Object[] objectArray = new Supplier[5];
        objectArray[0] = () -> GlobalSearchScope.EMPTY_SCOPE;
        objectArray[1] = () -> module.getModuleScope(false);
        objectArray[2] = () -> ((Module)module).getModuleWithDependenciesScope();
        objectArray[3] = () -> {
            GlobalSearchScope[] scopes = (GlobalSearchScope[])ContainerUtil.map2Array((Collection)ModuleUtilCore.getAllDependentModules((Module)module), (Object[])GlobalSearchScope.EMPTY_ARRAY, Module::getModuleContentWithDependenciesScope);
            return scopes.length == 0 ? GlobalSearchScope.EMPTY_SCOPE : GlobalSearchScope.union((GlobalSearchScope[])scopes);
        };
        objectArray[4] = () -> GlobalSearchScopesCore.projectProductionScope((Project)module.getProject());
        return ((StreamEx)StreamEx.of((Object[])objectArray).takeWhile(supplier -> !module.isDisposed())).map(Supplier::get).pairMap((prev, next) -> next.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)prev)));
    }

    public static StreamEx<PsiDirectory> allDescriptionDirs(Module module, DescriptionType descriptionType) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        PsiPackage psiPackage = javaPsiFacade.findPackage(descriptionType.getDescriptionFolder());
        if (psiPackage == null) {
            return StreamEx.empty();
        }
        return (StreamEx)DescriptionCheckerUtil.searchScopes(module).flatMap(scope -> StreamEx.of((Object[])psiPackage.getDirectories(scope))).distinct();
    }

    public static PsiDirectory[] getDescriptionsDirs(Module module, DescriptionType descriptionType) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        PsiPackage psiPackage = javaPsiFacade.findPackage(descriptionType.getDescriptionFolder());
        if (psiPackage != null) {
            return psiPackage.getDirectories(GlobalSearchScope.moduleWithDependenciesScope((Module)module));
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    public static String getDescriptionDirName(PsiClass aClass) {
        Object descriptionDir = "";
        for (PsiClass each = aClass; each != null; each = each.getContainingClass()) {
            String name = each.getName();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return null;
            }
            descriptionDir = name + (String)descriptionDir;
        }
        return descriptionDir;
    }
}

